/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json.jpath;

import java.util.ArrayList;
import java.util.List;
import jsonij.json.Value;
import jsonij.json.jpath.PredicateComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionPredicate
extends PredicateComponent {
    String expression = null;
    ArrayList<ExpressionPredicateCondition> conditions = new ArrayList();

    public ArrayList<ExpressionPredicateCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(ArrayList<ExpressionPredicateCondition> conditions) {
        this.conditions = conditions;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ArrayList<ExpressionPredicateCondition> conditions() {
        return this.conditions;
    }

    public String toString() {
        StringBuilder conditionString = new StringBuilder();
        for (ExpressionPredicateCondition epc : this.conditions()) {
            conditionString.append(epc);
            conditionString.append(" ");
        }
        String output = String.format("ExpressionPredicate (\"%s\" -> %s)", this.getExpression(), conditionString);
        return output;
    }

    @Override
    public List<Value> evaluate(List<Value> values, List<Value> results) {
        for (Value value : values) {
            if (value.getValueType() != Value.TYPE.ARRAY) continue;
            for (int j = 0; j < value.size(); ++j) {
                Value checkElement = value.get(j);
                if (checkElement.getValueType() != Value.TYPE.OBJECT) continue;
                boolean expressionValid = true;
                for (ExpressionPredicateCondition condition : this.conditions) {
                    Value checkValue = checkElement.get(condition.getAttribute());
                    if (checkValue == null) {
                        expressionValid = false;
                        break;
                    }
                    ExpressionPredicateOperator expressionConditionOperator = condition.getOperator();
                    if (expressionConditionOperator.equals((Object)ExpressionPredicateOperator.NOT_NULL)) {
                        if (!checkValue.isNull()) continue;
                        expressionValid = false;
                        break;
                    }
                    if (expressionConditionOperator.equals((Object)ExpressionPredicateOperator.EQUAL)) {
                        if (checkValue.equals(condition.value)) continue;
                        expressionValid = false;
                        break;
                    }
                    if (!expressionConditionOperator.equals((Object)ExpressionPredicateOperator.LESS) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.GREATER) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.LESS_EQUAL) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.GREATER_EQUAL)) continue;
                }
                if (!expressionValid) continue;
                results.add(checkElement);
            }
        }
        return results;
    }

    public static class ExpressionPredicateCondition {
        ExpressionPredicateCombineOperator combine;
        String attribute;
        ExpressionPredicateOperator operator;
        Value value;

        public ExpressionPredicateCondition() {
            this.combine = null;
            this.attribute = null;
            this.operator = null;
            this.value = null;
        }

        public ExpressionPredicateCondition(String attribute, ExpressionPredicateOperator operator) {
            this.attribute = attribute;
            this.operator = operator;
            this.value = null;
        }

        public ExpressionPredicateCondition(String attribute, ExpressionPredicateOperator operator, Value value) {
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }

        public ExpressionPredicateCondition(ExpressionPredicateCombineOperator combine, String attribute, ExpressionPredicateOperator operator, Value value) {
            this.combine = combine;
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }

        public ExpressionPredicateCombineOperator getCombine() {
            return this.combine;
        }

        public void setCombine(ExpressionPredicateCombineOperator combine) {
            this.combine = combine;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public ExpressionPredicateOperator getOperator() {
            return this.operator;
        }

        public void setOperator(ExpressionPredicateOperator operator) {
            this.operator = operator;
        }

        public Value getValue() {
            return this.value;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        public String toString() {
            return String.format("ExpressionPredicateCondition (%s%s %s %s)", new Object[]{this.combine != null ? String.format("%s ", new Object[]{this.combine}) : "", this.attribute, this.operator, this.value.toJSON()});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpressionPredicateCombineOperator {
        AND,
        OR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpressionPredicateOperator {
        NOT_NULL,
        EQUAL,
        LESS,
        GREATER,
        LESS_EQUAL,
        GREATER_EQUAL;

    }
}

