/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.Serializable;
import jsonij.json.JSON;
import jsonij.json.Value;

public class StringImp
extends Value
implements Serializable,
CharSequence {
    protected String value;

    public StringImp(String orig) {
        this.value = orig;
    }

    protected Value.TYPE internalType() {
        return Value.TYPE.STRING;
    }

    public char charAt(int index) {
        return this.value.charAt(index);
    }

    public int length() {
        return this.value.length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public boolean equals(Object o) {
        if (o instanceof String || o instanceof JSON.String) {
            return o.toString().equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.value;
    }

    public int nestedSize() {
        return 0;
    }

    public String toJSON() {
        StringBuilder outputStringBuilder = new StringBuilder();
        block10: for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            switch (c) {
                case '\"': {
                    outputStringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    outputStringBuilder.append("\\\\");
                    continue block10;
                }
                case '/': {
                    outputStringBuilder.append("\\/");
                    continue block10;
                }
                case '\b': {
                    outputStringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    outputStringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    outputStringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    outputStringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    outputStringBuilder.append("\\t");
                    continue block10;
                }
                default: {
                    char a = c;
                    if (a == ' ' || a == '!' || a >= '#' && a <= '[' || a >= ']' && a <= '\u007f') {
                        outputStringBuilder.append(c);
                        continue block10;
                    }
                    String hex = Integer.toHexString(a);
                    StringBuilder hexPrefix = new StringBuilder();
                    for (int j = hex.length(); j < 4; ++j) {
                        hexPrefix.append("0");
                    }
                    outputStringBuilder.append("\\u").append((CharSequence)hexPrefix).append(hex);
                }
            }
        }
        return String.format("\"%s\"", outputStringBuilder.toString());
    }
}

