/*
 * Decompiled with CFR 0.152.
 */
package jsonij.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsonij.parser.BaseParserException;
import jsonij.parser.ParserException;
import jsonij.parser.Position;

public abstract class ReaderParser {
    protected Reader reader;
    protected int peekValue;
    protected boolean hasPeeked;
    protected Position position;
    static final Logger logger = Logger.getLogger(ReaderParser.class.getName());

    public ReaderParser() {
        this(null);
    }

    public ReaderParser(Reader reader) {
        this.reader = reader;
        this.peekValue = -1;
        this.hasPeeked = false;
        this.position = new Position();
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public Position getPosition() {
        return this.position;
    }

    protected Position setPosition(Position position) {
        this.position = position;
        return this.position;
    }

    public boolean isHasPeeked() {
        return this.hasPeeked();
    }

    public boolean hasPeeked() {
        return this.hasPeeked;
    }

    public void setHasPeeked(boolean hasPeeked) {
        this.hasPeeked = hasPeeked;
    }

    public int getLineNumber() {
        return this.getPosition().getLineNumber();
    }

    public int getPositionNumber() {
        return this.getPosition().getPostionNumber();
    }

    public int peek() throws IOException, ParserException {
        if (!this.hasPeeked) {
            this.peekValue = this.readNext();
            this.hasPeeked = true;
        }
        return this.peekValue;
    }

    public int read() throws IOException, ParserException {
        if (this.hasPeeked) {
            this.hasPeeked = false;
            return this.peekValue;
        }
        return this.readNext();
    }

    protected abstract int readNext() throws IOException, ParserException;

    protected void handleNewLine() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "handleNewLine()");
        }
        this.getPosition().newLine();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "handleNewLine()");
        }
    }

    public String toString() {
        String state = "";
        try {
            state = String.format("Next Char %s", Character.valueOf((char)this.peek()));
        }
        catch (IOException e) {
            state = String.format("Unknown State: %s", e.toString());
        }
        catch (BaseParserException e) {
            state = String.format("Unknown State: %s", e.toString());
        }
        return String.format("JSONReader %s: %s", this.getPosition(), state);
    }
}

