/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jsonij.json.JSON;
import jsonij.json.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectImp<K extends JSON.String, V extends Value>
extends Value
implements Map<K, V> {
    protected HashMap<K, V> mapValue = new HashMap();
    protected ArrayList<K> valueOrder = new ArrayList();

    @Override
    protected Value.TYPE type() {
        return Value.TYPE.OBJECT;
    }

    @Override
    public void clear() {
        this.mapValue.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mapValue.containsKey((JSON.String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mapValue.containsValue((Value)value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mapValue.entrySet();
    }

    public V get(int i) {
        return (V)((Value)this.mapValue.get((JSON.String)this.valueOrder.get(i)));
    }

    @Override
    public V get(Object key) {
        return (V)((Value)this.mapValue.get((JSON.String)key));
    }

    @Override
    public boolean isEmpty() {
        return this.mapValue.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.mapValue.keySet();
    }

    @Override
    public V put(K key, V value) {
        this.valueOrder.add(key);
        return (V)((Value)this.mapValue.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (JSON.String k : m.keySet()) {
            this.valueOrder.add(k);
        }
        this.mapValue.putAll(m);
    }

    @Override
    public V remove(Object key) {
        this.valueOrder.remove((JSON.String)key);
        return (V)((Value)this.mapValue.remove((JSON.String)key));
    }

    @Override
    public int size() {
        return this.mapValue.size();
    }

    @Override
    public Collection<V> values() {
        return this.mapValue.values();
    }

    @Override
    public int nestedSize() {
        int c = 0;
        for (Value v : this.values()) {
            c += v.nestedSize();
        }
        return this.size() + c;
    }

    @Override
    public String toJSON() {
        StringBuilder json = new StringBuilder();
        JSON.String k = null;
        Object v = null;
        Iterator<K> keyIterator = this.valueOrder.iterator();
        if (keyIterator.hasNext()) {
            json.append('{');
            k = (JSON.String)keyIterator.next();
            v = this.get(k);
            json.append(String.format("%s%s%s%s%s", Character.valueOf('\"'), k.toString(), Character.valueOf('\"'), Character.valueOf(':'), ((Value)v).toJSON()));
            while (keyIterator.hasNext()) {
                k = (JSON.String)keyIterator.next();
                v = this.get(k);
                json.append(String.format(",%s%s%s%s%s", Character.valueOf('\"'), k, Character.valueOf('\"'), Character.valueOf(':'), ((Value)v).toJSON()));
            }
            json.append('}');
        } else {
            json.append(248);
        }
        return json.toString();
    }
}

