/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.marshal;

import cc.plural.jsonij.marshal.InspectorFilter;
import cc.plural.jsonij.marshal.InspectorProperty;
import cc.plural.jsonij.marshal.annotation.JSONAccessor;
import cc.plural.jsonij.marshal.annotation.JSONIgnore;
import cc.plural.jsonij.marshal.annotation.JSONMutator;
import cc.plural.jsonij.marshal.annotation.JSONName;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inspector {
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    public static final String GET_PREFIX = "get";
    Object o;
    Class<?> c;
    InspectorProperty[] properties;
    InspectorFilter filter;
    boolean innerArray;
    boolean innerObject;

    public Inspector(Class<?> c) {
        this.c = c;
        this.o = null;
        this.properties = null;
        this.filter = InspectorFilter.getDefaultFilters();
        this.innerArray = false;
        this.innerObject = false;
    }

    public Inspector(Object o) {
        this.o = o;
        this.properties = null;
        this.filter = InspectorFilter.getDefaultFilters();
        this.innerArray = false;
        this.innerObject = false;
    }

    public Object getC() {
        return this.c;
    }

    public Object getO() {
        return this.o;
    }

    public boolean hasInnerArray() {
        return this.innerArray;
    }

    public boolean hasInnerObject() {
        return this.innerObject;
    }

    public boolean hasProperty(String name) {
        for (InspectorProperty property : this.properties) {
            if (!property.getPropertyName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public InspectorProperty getProperty(String name) {
        for (InspectorProperty property : this.properties) {
            if (!property.getPropertyName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public void inspect() {
        Class<?> objectClass;
        InspectorProperty[] propertyList;
        if (this.o == null && this.c == null) {
            return;
        }
        if (this.o != null) {
            this.c = this.o.getClass();
        }
        if ((propertyList = this.getMethodProperties(objectClass = this.c)) != null) {
            InspectorProperty[] fieldPropertyList = this.getAttributeProperties(objectClass);
            if (fieldPropertyList != null) {
                HashMap<String, InspectorProperty> propertiesMap = new HashMap<String, InspectorProperty>();
                for (InspectorProperty prop : propertyList) {
                    propertiesMap.put(prop.getPropertyName(), prop);
                }
                for (InspectorProperty prop : fieldPropertyList) {
                    if (propertiesMap.containsKey(prop.getPropertyName())) {
                        InspectorProperty existingProp = (InspectorProperty)propertiesMap.get(prop.getPropertyName());
                        if (!existingProp.hasAccessor()) {
                            existingProp.setAccessName(prop.getAccessName());
                            existingProp.setAccessPropertyType(InspectorProperty.TYPE.FIELD);
                        }
                        if (existingProp.hasMutator()) continue;
                        existingProp.setMutateName(prop.getMutateName());
                        existingProp.setMutatePropertyType(InspectorProperty.TYPE.FIELD);
                        continue;
                    }
                    propertiesMap.put(prop.getPropertyName(), prop);
                }
                propertyList = new InspectorProperty[propertiesMap.size()];
                propertiesMap.values().toArray(propertyList);
            }
        } else {
            propertyList = this.getAttributeProperties(objectClass);
        }
        if (propertyList == null) {
            propertyList = new InspectorProperty[]{};
        }
        this.properties = propertyList;
        Class<?>[] interfaces = null;
        Class<?> parent = objectClass.getSuperclass();
        if (parent != null) {
            block2: do {
                interfaces = parent.getInterfaces();
                for (int i = 0; i < Array.getLength(interfaces); ++i) {
                    if (interfaces[i] == List.class) {
                        this.innerArray = true;
                    }
                    if (interfaces[i] == Map.class) {
                        this.innerObject = true;
                    }
                    if (this.innerArray && this.innerObject) continue block2;
                }
            } while ((!this.innerArray || !this.innerObject) && (parent = parent.getSuperclass()) != null);
        }
    }

    public InspectorProperty[] getAttributeProperties(Class<?> objectClass) {
        Field[] objectFields;
        InspectorProperty[] result = null;
        HashMap<String, InspectorProperty> attributeProperties = new HashMap<String, InspectorProperty>();
        for (Field field : objectFields = objectClass.getFields()) {
            InspectionData fieldInspectionData;
            if (this.isJSONIgnored(field) || this.filter.isFiltered(field.getDeclaringClass()) || (fieldInspectionData = this.getFieldInspectionData(field)) == null || !fieldInspectionData.hasPropertyName()) continue;
            String propertyName = fieldInspectionData.getPropertyName();
            InspectorProperty property = null;
            if (attributeProperties.containsKey(propertyName)) continue;
            property = new InspectorProperty(propertyName, InspectorProperty.TYPE.FIELD);
            attributeProperties.put(propertyName, property);
            property.setPropertyName(propertyName);
            property.setAccessName(fieldInspectionData.getName());
            property.setMutateName(fieldInspectionData.getName());
            property.setAccessReturnType(fieldInspectionData.getReturnType());
            property.setMutateInputType(fieldInspectionData.getArgumentType());
        }
        if (!attributeProperties.isEmpty()) {
            result = new InspectorProperty[attributeProperties.size()];
            attributeProperties.values().toArray(result);
        }
        return result;
    }

    public InspectorProperty[] getMethodProperties(Class<?> objectClass) {
        Method[] objectMethods;
        InspectorProperty[] result = null;
        HashMap<String, InspectorProperty> methodProperties = new HashMap<String, InspectorProperty>();
        for (Method method : objectMethods = objectClass.getMethods()) {
            InspectionData methodInspectionData;
            if (this.isJSONIgnored(method) || this.filter.isFiltered(method.getDeclaringClass()) || (methodInspectionData = this.getMethodInspectionData(method)) == null || !methodInspectionData.hasPropertyName()) continue;
            String propertyName = methodInspectionData.getPropertyName();
            InspectorProperty property = null;
            if (methodProperties.containsKey(propertyName)) {
                property = (InspectorProperty)methodProperties.get(propertyName);
            } else {
                property = new InspectorProperty(propertyName, InspectorProperty.TYPE.METHOD);
                methodProperties.put(propertyName, property);
            }
            if (methodInspectionData.getAccessType() == ACCESS_TYPE.ACCESS && !property.hasAccessor()) {
                property.setAccessName(methodInspectionData.getName());
                property.setAccessReturnType(methodInspectionData.getReturnType());
                continue;
            }
            if (methodInspectionData.getAccessType() != ACCESS_TYPE.MUTATE || property.hasMutator()) continue;
            property.setMutateName(methodInspectionData.getName());
            property.setMutateInputType(methodInspectionData.getArgumentType());
        }
        if (!methodProperties.isEmpty()) {
            result = new InspectorProperty[methodProperties.size()];
            methodProperties.values().toArray(result);
        }
        return result;
    }

    public InspectionData getFieldInspectionData(Field field) {
        InspectionData fieldInspectionData = new InspectionData();
        fieldInspectionData.setName(field.getName());
        fieldInspectionData.setAccessType(ACCESS_TYPE.BOTH);
        String jsonName = Inspector.getJSONName(field);
        if (jsonName != null) {
            fieldInspectionData.setPropertyName(jsonName);
        }
        if (!fieldInspectionData.hasPropertyName()) {
            fieldInspectionData.setPropertyName(fieldInspectionData.getName());
        }
        fieldInspectionData.setArgumentType(field.getType());
        fieldInspectionData.setReturnType(field.getType());
        return fieldInspectionData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InspectionData getMethodInspectionData(Method method) {
        String mutatorName;
        String accessorName;
        InspectionData methodInspectionData = new InspectionData();
        methodInspectionData.setName(method.getName());
        String jsonName = Inspector.getJSONName(method);
        if (jsonName != null) {
            methodInspectionData.setPropertyName(jsonName);
        }
        if (!methodInspectionData.hasPropertyName() && (accessorName = Inspector.getJSONAccessor(method)) != null) {
            methodInspectionData.setPropertyName(accessorName);
            methodInspectionData.setAccessType(ACCESS_TYPE.ACCESS);
        }
        if (!methodInspectionData.hasPropertyName() && (mutatorName = Inspector.getJSONMutator(method)) != null) {
            methodInspectionData.setPropertyName(mutatorName);
            methodInspectionData.setAccessType(ACCESS_TYPE.MUTATE);
        }
        methodInspectionData.setReturnType(method.getReturnType());
        if (!methodInspectionData.hasPropertyName()) {
            char ch;
            String propertyName = null;
            String methodName = methodInspectionData.getName();
            Class<?> returnType = methodInspectionData.getReturnType();
            if (methodName.length() > IS_PREFIX.length() && methodName.startsWith(IS_PREFIX) && returnType == Boolean.TYPE && Character.isUpperCase(ch = methodName.charAt(IS_PREFIX.length()))) {
                propertyName = Character.toLowerCase(ch) + methodName.substring(IS_PREFIX.length() + 1, methodName.length());
                methodInspectionData.setPropertyName(propertyName);
                methodInspectionData.setAccessType(ACCESS_TYPE.ACCESS);
            } else if (methodName.length() > SET_PREFIX.length() && methodName.startsWith(SET_PREFIX) && Character.isUpperCase(ch = methodName.charAt(SET_PREFIX.length()))) {
                propertyName = Character.toLowerCase(ch) + methodName.substring(SET_PREFIX.length() + 1, methodName.length());
                methodInspectionData.setPropertyName(propertyName);
                methodInspectionData.setAccessType(ACCESS_TYPE.MUTATE);
            } else if (methodName.length() > GET_PREFIX.length() && methodName.startsWith(GET_PREFIX) && Character.isUpperCase(ch = methodName.charAt(GET_PREFIX.length())) && returnType != null) {
                propertyName = Character.toLowerCase(ch) + methodName.substring(GET_PREFIX.length() + 1, methodName.length());
                methodInspectionData.setPropertyName(propertyName);
                methodInspectionData.setAccessType(ACCESS_TYPE.ACCESS);
            }
        }
        if (methodInspectionData.getAccessType() == ACCESS_TYPE.ACCESS) {
            Class<?> returnType = method.getReturnType();
            if (returnType == null) return null;
            methodInspectionData.setReturnType(returnType);
            return methodInspectionData;
        } else {
            if (methodInspectionData.getAccessType() != ACCESS_TYPE.MUTATE) return methodInspectionData;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (Array.getLength(parameterTypes) != 1) return null;
            Class<?> parameterType = parameterTypes[0];
            methodInspectionData.setArgumentType(parameterType);
        }
        return methodInspectionData;
    }

    public InspectorProperty[] getProperties() {
        if (this.o != null && this.properties == null) {
            this.inspect();
        }
        return this.properties;
    }

    public void setProperties(InspectorProperty[] properties) {
        this.properties = properties;
    }

    public boolean isJSONIgnored(AccessibleObject object) {
        return object.getAnnotation(JSONIgnore.class) != null;
    }

    public static String getAnnotatedName(AccessibleObject object) {
        String name = Inspector.getJSONName(object);
        if (name == null) {
            name = Inspector.getJSONMutator(object);
        }
        if (name == null) {
            name = Inspector.getJSONAccessor(object);
        }
        return name;
    }

    public static String getJSONName(AccessibleObject object) {
        String name = null;
        JSONName jsonNameAnnotation = object.getAnnotation(JSONName.class);
        if (jsonNameAnnotation != null) {
            name = jsonNameAnnotation.value();
        }
        return name;
    }

    public static String getJSONMutator(AccessibleObject object) {
        String name = null;
        JSONMutator jsonMutatorAnnotation = object.getAnnotation(JSONMutator.class);
        if (jsonMutatorAnnotation != null) {
            name = jsonMutatorAnnotation.value();
        }
        return name;
    }

    public static String getJSONAccessor(AccessibleObject object) {
        String name = null;
        JSONAccessor jsonAccessorAnnotation = object.getAnnotation(JSONAccessor.class);
        if (jsonAccessorAnnotation != null) {
            name = jsonAccessorAnnotation.value();
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InspectionData {
        protected String name = null;
        protected String propertyName = null;
        protected Class<?> returnType = null;
        protected Class<?> argumentType;
        protected ACCESS_TYPE accessType;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public void setReturnType(Class<?> returnType) {
            this.returnType = returnType;
        }

        public Class<?> getArgumentType() {
            return this.argumentType;
        }

        public void setArgumentType(Class<?> argumentType) {
            this.argumentType = argumentType;
        }

        public boolean hasPropertyName() {
            return this.propertyName != null;
        }

        public ACCESS_TYPE getAccessType() {
            return this.accessType;
        }

        public void setAccessType(ACCESS_TYPE accessType) {
            this.accessType = accessType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ACCESS_TYPE {
        ACCESS,
        MUTATE,
        BOTH;

    }
}

