/*
 * Decompiled with CFR 0.152.
 */
package cc.duduhuo.util.android.crypto;

import android.util.Base64;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0007J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\bH\u0003J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bH\u0003J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcc/duduhuo/util/android/crypto/AES;", "", "()V", "ALGORITHM", "", "TRANSFORMATION", "decrypt", "input", "", "seed", "encrypt", "getRawKey", "Ljavax/crypto/SecretKey;", "toDecrypt", "key", "encrypted", "toEncrypt", "digest-util-android_release"})
public final class AES {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES";
    public static final AES INSTANCE;

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull byte[] input, @NotNull byte[] seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        byte[] byArray = Arrays.copyOf(seed, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(seed, 16)");
        SecretKey key = INSTANCE.getRawKey(byArray);
        byte[] result = INSTANCE.toEncrypt(key, input);
        String string = Base64.encodeToString((byte[])result, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.encodeToString(result, Base64.DEFAULT)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull String input, @NotNull byte[] seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        byte[] byArray = Arrays.copyOf(seed, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(seed, 16)");
        SecretKey key = INSTANCE.getRawKey(byArray);
        String string = input;
        SecretKey secretKey = key;
        AES aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray2;
        byte[] result = aES.toEncrypt(secretKey, byArray3);
        String string2 = Base64.encodeToString((byte[])result, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(result, Base64.DEFAULT)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull byte[] input, @NotNull String seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        String string = seed;
        AES aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] byArray3 = Arrays.copyOf(byArray2, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"Arrays.copyOf(seed.toByteArray(), 16)");
        SecretKey key = aES.getRawKey(byArray3);
        byte[] result = INSTANCE.toEncrypt(key, input);
        String string2 = Base64.encodeToString((byte[])result, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(result, Base64.DEFAULT)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String encrypt(@NotNull String input, @NotNull String seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        String string = seed;
        AES aES = INSTANCE;
        Object object = Charsets.UTF_8;
        byte[] byArray = string.getBytes((Charset)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Object object2 = byArray;
        byte[] byArray2 = Arrays.copyOf(object2, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Arrays.copyOf(seed.toByteArray(), 16)");
        SecretKey key = aES.getRawKey(byArray2);
        object = input;
        object2 = key;
        aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray3 = ((String)object).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        byte[] result = aES.toEncrypt((SecretKey)object2, byArray4);
        String string2 = Base64.encodeToString((byte[])result, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(result, Base64.DEFAULT)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull byte[] input, @NotNull byte[] seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        byte[] byArray = Arrays.copyOf(seed, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(seed, 16)");
        SecretKey key = INSTANCE.getRawKey(byArray);
        byte[] encrypted = Base64.decode((byte[])input, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)encrypted, (String)"encrypted");
        byte[] result = INSTANCE.toDecrypt(key, encrypted);
        return new String(result, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull String input, @NotNull byte[] seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        byte[] byArray = Arrays.copyOf(seed, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOf(seed, 16)");
        SecretKey key = INSTANCE.getRawKey(byArray);
        byte[] encrypted = Base64.decode((String)input, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)encrypted, (String)"encrypted");
        byte[] result = INSTANCE.toDecrypt(key, encrypted);
        return new String(result, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull byte[] input, @NotNull String seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        String string = seed;
        AES aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] byArray3 = Arrays.copyOf(byArray2, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"Arrays.copyOf(seed.toByteArray(), 16)");
        SecretKey key = aES.getRawKey(byArray3);
        byte[] encrypted = Base64.decode((byte[])input, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)encrypted, (String)"encrypted");
        byte[] result = INSTANCE.toDecrypt(key, encrypted);
        return new String(result, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String decrypt(@NotNull String input, @NotNull String seed) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)seed, (String)"seed");
        String string = seed;
        AES aES = INSTANCE;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] byArray3 = Arrays.copyOf(byArray2, 16);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"Arrays.copyOf(seed.toByteArray(), 16)");
        SecretKey key = aES.getRawKey(byArray3);
        byte[] encrypted = Base64.decode((String)input, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)encrypted, (String)"encrypted");
        byte[] result = INSTANCE.toDecrypt(key, encrypted);
        return new String(result, Charsets.UTF_8);
    }

    private final SecretKey getRawKey(byte[] seed) throws Exception {
        return new SecretKeySpec(seed, "AES");
    }

    private final byte[] toEncrypt(SecretKey key, byte[] input) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] byArray = cipher.doFinal(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(input)");
        return byArray;
    }

    private final byte[] toDecrypt(SecretKey key, byte[] encrypted) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        byte[] byArray = cipher.doFinal(encrypted);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cipher.doFinal(encrypted)");
        return byArray;
    }

    private AES() {
        INSTANCE = this;
    }

    static {
        new AES();
    }
}

