/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SCP
extends AbstractSegment {
    public SCP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Number Of Decontamination/Sterilization Devices");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Labor Calculation Type");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Date Format");
            this.add(EI.class, false, 1, 8, new Object[]{this.getMessage()}, "Device Number");
            this.add(ST.class, false, 1, 999, new Object[]{this.getMessage()}, "Device Name");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "Device Model Name");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Device Type");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Lot Control");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SCP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getNumberOfDecontaminationSterilizationDevices() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getScp1_NumberOfDecontaminationSterilizationDevices() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getLaborCalculationType() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getScp2_LaborCalculationType() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getDateFormat() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getScp3_DateFormat() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getDeviceNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getScp4_DeviceNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getDeviceName() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getScp5_DeviceName() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getDeviceModelName() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getScp6_DeviceModelName() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getDeviceType() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getScp7_DeviceType() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getLotControl() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getScp8_LotControl() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

