/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.OML_O21_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.OML_O21_PRIOR_RESULT;
import ca.uhn.hl7v2.model.v26.group.OML_O21_SPECIMEN;
import ca.uhn.hl7v2.model.v26.segment.CTD;
import ca.uhn.hl7v2.model.v26.segment.DG1;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBR;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OML_O21_OBSERVATION_REQUEST
extends AbstractGroup {
    public OML_O21_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(TCD.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(ROL.class, false, true, false);
            this.add(CTD.class, false, false, false);
            this.add(DG1.class, false, true, false);
            this.add(OML_O21_OBSERVATION.class, false, true, false);
            this.add(OML_O21_SPECIMEN.class, false, true, false);
            this.add(OML_O21_PRIOR_RESULT.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OML_O21_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public TCD getTCD() {
        TCD retVal = (TCD)this.getTyped("TCD", TCD.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ROL getROL() {
        ROL retVal = (ROL)this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = (ROL)this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public CTD getCTD() {
        CTD retVal = (CTD)this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public DG1 getDG1() {
        DG1 retVal = (DG1)this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = (DG1)this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public OML_O21_OBSERVATION getOBSERVATION() {
        OML_O21_OBSERVATION retVal = (OML_O21_OBSERVATION)this.getTyped("OBSERVATION", OML_O21_OBSERVATION.class);
        return retVal;
    }

    public OML_O21_OBSERVATION getOBSERVATION(int rep) {
        OML_O21_OBSERVATION retVal = (OML_O21_OBSERVATION)this.getTyped("OBSERVATION", rep, OML_O21_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<OML_O21_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", OML_O21_OBSERVATION.class);
    }

    public void insertOBSERVATION(OML_O21_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public OML_O21_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OML_O21_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OML_O21_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OML_O21_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public OML_O21_SPECIMEN getSPECIMEN() {
        OML_O21_SPECIMEN retVal = (OML_O21_SPECIMEN)this.getTyped("SPECIMEN", OML_O21_SPECIMEN.class);
        return retVal;
    }

    public OML_O21_SPECIMEN getSPECIMEN(int rep) {
        OML_O21_SPECIMEN retVal = (OML_O21_SPECIMEN)this.getTyped("SPECIMEN", rep, OML_O21_SPECIMEN.class);
        return retVal;
    }

    public int getSPECIMENReps() {
        return this.getReps("SPECIMEN");
    }

    public List<OML_O21_SPECIMEN> getSPECIMENAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN", OML_O21_SPECIMEN.class);
    }

    public void insertSPECIMEN(OML_O21_SPECIMEN structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN", (Structure)structure, rep);
    }

    public OML_O21_SPECIMEN insertSPECIMEN(int rep) throws HL7Exception {
        return (OML_O21_SPECIMEN)super.insertRepetition("SPECIMEN", rep);
    }

    public OML_O21_SPECIMEN removeSPECIMEN(int rep) throws HL7Exception {
        return (OML_O21_SPECIMEN)super.removeRepetition("SPECIMEN", rep);
    }

    public OML_O21_PRIOR_RESULT getPRIOR_RESULT() {
        OML_O21_PRIOR_RESULT retVal = (OML_O21_PRIOR_RESULT)this.getTyped("PRIOR_RESULT", OML_O21_PRIOR_RESULT.class);
        return retVal;
    }

    public OML_O21_PRIOR_RESULT getPRIOR_RESULT(int rep) {
        OML_O21_PRIOR_RESULT retVal = (OML_O21_PRIOR_RESULT)this.getTyped("PRIOR_RESULT", rep, OML_O21_PRIOR_RESULT.class);
        return retVal;
    }

    public int getPRIOR_RESULTReps() {
        return this.getReps("PRIOR_RESULT");
    }

    public List<OML_O21_PRIOR_RESULT> getPRIOR_RESULTAll() throws HL7Exception {
        return this.getAllAsList("PRIOR_RESULT", OML_O21_PRIOR_RESULT.class);
    }

    public void insertPRIOR_RESULT(OML_O21_PRIOR_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRIOR_RESULT", (Structure)structure, rep);
    }

    public OML_O21_PRIOR_RESULT insertPRIOR_RESULT(int rep) throws HL7Exception {
        return (OML_O21_PRIOR_RESULT)super.insertRepetition("PRIOR_RESULT", rep);
    }

    public OML_O21_PRIOR_RESULT removePRIOR_RESULT(int rep) throws HL7Exception {
        return (OML_O21_PRIOR_RESULT)super.removeRepetition("PRIOR_RESULT", rep);
    }
}

