/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.HD;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class NSC
extends AbstractSegment {
    public NSC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(IS.class, true, 1, 4, new Object[]{this.getMessage(), new Integer(409)}, "Application Change Type");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Current CPU");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Current Fileserver");
            this.add(HD.class, false, 1, 30, new Object[]{this.getMessage()}, "Current Application");
            this.add(HD.class, false, 1, 30, new Object[]{this.getMessage()}, "Current Facility");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "New CPU");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "New Fileserver");
            this.add(HD.class, false, 1, 30, new Object[]{this.getMessage()}, "New Application");
            this.add(HD.class, false, 1, 30, new Object[]{this.getMessage()}, "New Facility");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating NSC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public IS getApplicationChangeType() {
        IS retVal = (IS)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getNsc1_ApplicationChangeType() {
        IS retVal = (IS)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getCurrentCPU() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getNsc2_CurrentCPU() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getCurrentFileserver() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getNsc3_CurrentFileserver() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public HD getCurrentApplication() {
        HD retVal = (HD)this.getTypedField(4, 0);
        return retVal;
    }

    public HD getNsc4_CurrentApplication() {
        HD retVal = (HD)this.getTypedField(4, 0);
        return retVal;
    }

    public HD getCurrentFacility() {
        HD retVal = (HD)this.getTypedField(5, 0);
        return retVal;
    }

    public HD getNsc5_CurrentFacility() {
        HD retVal = (HD)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getNewCPU() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getNsc6_NewCPU() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getNewFileserver() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getNsc7_NewFileserver() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public HD getNewApplication() {
        HD retVal = (HD)this.getTypedField(8, 0);
        return retVal;
    }

    public HD getNsc8_NewApplication() {
        HD retVal = (HD)this.getTypedField(8, 0);
        return retVal;
    }

    public HD getNewFacility() {
        HD retVal = (HD)this.getTypedField(9, 0);
        return retVal;
    }

    public HD getNsc9_NewFacility() {
        HD retVal = (HD)this.getTypedField(9, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new IS(this.getMessage(), new Integer(409));
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new HD(this.getMessage());
            }
            case 4: {
                return new HD(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new HD(this.getMessage());
            }
            case 8: {
                return new HD(this.getMessage());
            }
        }
        return null;
    }
}

