/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.HD;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EVN
extends AbstractSegment {
    public EVN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(3)}, "Event Type Code");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Recorded Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Date/Time Planned Event");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(62)}, "Event Reason Code");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Operator ID");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Event Occurred");
            this.add(HD.class, false, 1, 241, new Object[]{this.getMessage()}, "Event Facility");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating EVN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getEventTypeCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getEvn1_EventTypeCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getRecordedDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getEvn2_RecordedDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getDateTimePlannedEvent() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getEvn3_DateTimePlannedEvent() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public IS getEventReasonCode() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public IS getEvn4_EventReasonCode() {
        IS retVal = (IS)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN[] getOperatorID() {
        XCN[] retVal = (XCN[])this.getTypedField(5, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getEvn5_OperatorID() {
        XCN[] retVal = (XCN[])this.getTypedField(5, (Type[])new XCN[0]);
        return retVal;
    }

    public int getOperatorIDReps() {
        return this.getReps(5);
    }

    public XCN getOperatorID(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public XCN getEvn5_OperatorID(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getEvn5_OperatorIDReps() {
        return this.getReps(5);
    }

    public XCN insertOperatorID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN insertEvn5_OperatorID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN removeOperatorID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public XCN removeEvn5_OperatorID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public DTM getEventOccurred() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getEvn6_EventOccurred() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public HD getEventFacility() {
        HD retVal = (HD)this.getTypedField(7, 0);
        return retVal;
    }

    public HD getEvn7_EventFacility() {
        HD retVal = (HD)this.getTypedField(7, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(3));
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(62));
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new HD(this.getMessage());
            }
        }
        return null;
    }
}

