/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.MFR_M05_MF_QUERY;
import ca.uhn.hl7v2.model.v251.segment.DSC;
import ca.uhn.hl7v2.model.v251.segment.ERR;
import ca.uhn.hl7v2.model.v251.segment.MFI;
import ca.uhn.hl7v2.model.v251.segment.MSA;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.QAK;
import ca.uhn.hl7v2.model.v251.segment.QRD;
import ca.uhn.hl7v2.model.v251.segment.QRF;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFR_M05
extends AbstractMessage {
    public MFR_M05() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFR_M05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(QAK.class, false, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFR_M05_MF_QUERY.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating MFR_M05 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return (ERR)this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public QAK getQAK() {
        return (QAK)this.getTyped("QAK", QAK.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return (QRF)this.getTyped("QRF", QRF.class);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFR_M05_MF_QUERY getMF_QUERY() {
        return (MFR_M05_MF_QUERY)this.getTyped("MF_QUERY", MFR_M05_MF_QUERY.class);
    }

    public MFR_M05_MF_QUERY getMF_QUERY(int rep) {
        return (MFR_M05_MF_QUERY)this.getTyped("MF_QUERY", rep, MFR_M05_MF_QUERY.class);
    }

    public int getMF_QUERYReps() {
        return this.getReps("MF_QUERY");
    }

    public List<MFR_M05_MF_QUERY> getMF_QUERYAll() throws HL7Exception {
        return this.getAllAsList("MF_QUERY", MFR_M05_MF_QUERY.class);
    }

    public void insertMF_QUERY(MFR_M05_MF_QUERY structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_QUERY", (Structure)structure, rep);
    }

    public MFR_M05_MF_QUERY insertMF_QUERY(int rep) throws HL7Exception {
        return (MFR_M05_MF_QUERY)super.insertRepetition("MF_QUERY", rep);
    }

    public MFR_M05_MF_QUERY removeMF_QUERY(int rep) throws HL7Exception {
        return (MFR_M05_MF_QUERY)super.removeRepetition("MF_QUERY", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

