/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.group.RAR_RAR_ORDER;
import ca.uhn.hl7v2.model.v251.group.RAR_RAR_PATIENT;
import ca.uhn.hl7v2.model.v251.segment.QRD;
import ca.uhn.hl7v2.model.v251.segment.QRF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAR_RAR_DEFINITION
extends AbstractGroup {
    public RAR_RAR_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(QRD.class, true, false, false);
            this.add(QRF.class, false, false, false);
            this.add(RAR_RAR_PATIENT.class, false, false, false);
            this.add(RAR_RAR_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RAR_RAR_DEFINITION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public QRD getQRD() {
        QRD retVal = (QRD)this.getTyped("QRD", QRD.class);
        return retVal;
    }

    public QRF getQRF() {
        QRF retVal = (QRF)this.getTyped("QRF", QRF.class);
        return retVal;
    }

    public RAR_RAR_PATIENT getPATIENT() {
        RAR_RAR_PATIENT retVal = (RAR_RAR_PATIENT)this.getTyped("PATIENT", RAR_RAR_PATIENT.class);
        return retVal;
    }

    public RAR_RAR_ORDER getORDER() {
        RAR_RAR_ORDER retVal = (RAR_RAR_ORDER)this.getTyped("ORDER", RAR_RAR_ORDER.class);
        return retVal;
    }

    public RAR_RAR_ORDER getORDER(int rep) {
        RAR_RAR_ORDER retVal = (RAR_RAR_ORDER)this.getTyped("ORDER", rep, RAR_RAR_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RAR_RAR_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RAR_RAR_ORDER.class);
    }

    public void insertORDER(RAR_RAR_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public RAR_RAR_ORDER insertORDER(int rep) throws HL7Exception {
        return (RAR_RAR_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RAR_RAR_ORDER removeORDER(int rep) throws HL7Exception {
        return (RAR_RAR_ORDER)super.removeRepetition("ORDER", rep);
    }
}

