/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.PPG_PCG_PROBLEM_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.PPG_PCG_PROBLEM_ROLE;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.PRB;
import ca.uhn.hl7v2.model.v25.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPG_PCG_PROBLEM
extends AbstractGroup {
    public PPG_PCG_PROBLEM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PRB.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(VAR.class, false, true, false);
            this.add(PPG_PCG_PROBLEM_ROLE.class, false, true, false);
            this.add(PPG_PCG_PROBLEM_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPG_PCG_PROBLEM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public PRB getPRB() {
        PRB retVal = (PRB)this.getTyped("PRB", PRB.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPG_PCG_PROBLEM_ROLE getPROBLEM_ROLE() {
        PPG_PCG_PROBLEM_ROLE retVal = (PPG_PCG_PROBLEM_ROLE)this.getTyped("PROBLEM_ROLE", PPG_PCG_PROBLEM_ROLE.class);
        return retVal;
    }

    public PPG_PCG_PROBLEM_ROLE getPROBLEM_ROLE(int rep) {
        PPG_PCG_PROBLEM_ROLE retVal = (PPG_PCG_PROBLEM_ROLE)this.getTyped("PROBLEM_ROLE", rep, PPG_PCG_PROBLEM_ROLE.class);
        return retVal;
    }

    public int getPROBLEM_ROLEReps() {
        return this.getReps("PROBLEM_ROLE");
    }

    public List<PPG_PCG_PROBLEM_ROLE> getPROBLEM_ROLEAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM_ROLE", PPG_PCG_PROBLEM_ROLE.class);
    }

    public void insertPROBLEM_ROLE(PPG_PCG_PROBLEM_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_ROLE", (Structure)structure, rep);
    }

    public PPG_PCG_PROBLEM_ROLE insertPROBLEM_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM_ROLE)super.insertRepetition("PROBLEM_ROLE", rep);
    }

    public PPG_PCG_PROBLEM_ROLE removePROBLEM_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM_ROLE)super.removeRepetition("PROBLEM_ROLE", rep);
    }

    public PPG_PCG_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION() {
        PPG_PCG_PROBLEM_OBSERVATION retVal = (PPG_PCG_PROBLEM_OBSERVATION)this.getTyped("PROBLEM_OBSERVATION", PPG_PCG_PROBLEM_OBSERVATION.class);
        return retVal;
    }

    public PPG_PCG_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION(int rep) {
        PPG_PCG_PROBLEM_OBSERVATION retVal = (PPG_PCG_PROBLEM_OBSERVATION)this.getTyped("PROBLEM_OBSERVATION", rep, PPG_PCG_PROBLEM_OBSERVATION.class);
        return retVal;
    }

    public int getPROBLEM_OBSERVATIONReps() {
        return this.getReps("PROBLEM_OBSERVATION");
    }

    public List<PPG_PCG_PROBLEM_OBSERVATION> getPROBLEM_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM_OBSERVATION", PPG_PCG_PROBLEM_OBSERVATION.class);
    }

    public void insertPROBLEM_OBSERVATION(PPG_PCG_PROBLEM_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_OBSERVATION", (Structure)structure, rep);
    }

    public PPG_PCG_PROBLEM_OBSERVATION insertPROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM_OBSERVATION)super.insertRepetition("PROBLEM_OBSERVATION", rep);
    }

    public PPG_PCG_PROBLEM_OBSERVATION removePROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM_OBSERVATION)super.removeRepetition("PROBLEM_OBSERVATION", rep);
    }
}

