/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.SQR_S25_GENERAL_RESOURCE;
import ca.uhn.hl7v2.model.v25.group.SQR_S25_LOCATION_RESOURCE;
import ca.uhn.hl7v2.model.v25.group.SQR_S25_PERSONNEL_RESOURCE;
import ca.uhn.hl7v2.model.v25.group.SQR_S25_SERVICE;
import ca.uhn.hl7v2.model.v25.segment.RGS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQR_S25_RESOURCES
extends AbstractGroup {
    public SQR_S25_RESOURCES(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RGS.class, true, false, false);
            this.add(SQR_S25_SERVICE.class, false, true, false);
            this.add(SQR_S25_GENERAL_RESOURCE.class, false, true, false);
            this.add(SQR_S25_PERSONNEL_RESOURCE.class, false, true, false);
            this.add(SQR_S25_LOCATION_RESOURCE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SQR_S25_RESOURCES - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public RGS getRGS() {
        RGS retVal = (RGS)this.getTyped("RGS", RGS.class);
        return retVal;
    }

    public SQR_S25_SERVICE getSERVICE() {
        SQR_S25_SERVICE retVal = (SQR_S25_SERVICE)this.getTyped("SERVICE", SQR_S25_SERVICE.class);
        return retVal;
    }

    public SQR_S25_SERVICE getSERVICE(int rep) {
        SQR_S25_SERVICE retVal = (SQR_S25_SERVICE)this.getTyped("SERVICE", rep, SQR_S25_SERVICE.class);
        return retVal;
    }

    public int getSERVICEReps() {
        return this.getReps("SERVICE");
    }

    public List<SQR_S25_SERVICE> getSERVICEAll() throws HL7Exception {
        return this.getAllAsList("SERVICE", SQR_S25_SERVICE.class);
    }

    public void insertSERVICE(SQR_S25_SERVICE structure, int rep) throws HL7Exception {
        super.insertRepetition("SERVICE", (Structure)structure, rep);
    }

    public SQR_S25_SERVICE insertSERVICE(int rep) throws HL7Exception {
        return (SQR_S25_SERVICE)super.insertRepetition("SERVICE", rep);
    }

    public SQR_S25_SERVICE removeSERVICE(int rep) throws HL7Exception {
        return (SQR_S25_SERVICE)super.removeRepetition("SERVICE", rep);
    }

    public SQR_S25_GENERAL_RESOURCE getGENERAL_RESOURCE() {
        SQR_S25_GENERAL_RESOURCE retVal = (SQR_S25_GENERAL_RESOURCE)this.getTyped("GENERAL_RESOURCE", SQR_S25_GENERAL_RESOURCE.class);
        return retVal;
    }

    public SQR_S25_GENERAL_RESOURCE getGENERAL_RESOURCE(int rep) {
        SQR_S25_GENERAL_RESOURCE retVal = (SQR_S25_GENERAL_RESOURCE)this.getTyped("GENERAL_RESOURCE", rep, SQR_S25_GENERAL_RESOURCE.class);
        return retVal;
    }

    public int getGENERAL_RESOURCEReps() {
        return this.getReps("GENERAL_RESOURCE");
    }

    public List<SQR_S25_GENERAL_RESOURCE> getGENERAL_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("GENERAL_RESOURCE", SQR_S25_GENERAL_RESOURCE.class);
    }

    public void insertGENERAL_RESOURCE(SQR_S25_GENERAL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("GENERAL_RESOURCE", (Structure)structure, rep);
    }

    public SQR_S25_GENERAL_RESOURCE insertGENERAL_RESOURCE(int rep) throws HL7Exception {
        return (SQR_S25_GENERAL_RESOURCE)super.insertRepetition("GENERAL_RESOURCE", rep);
    }

    public SQR_S25_GENERAL_RESOURCE removeGENERAL_RESOURCE(int rep) throws HL7Exception {
        return (SQR_S25_GENERAL_RESOURCE)super.removeRepetition("GENERAL_RESOURCE", rep);
    }

    public SQR_S25_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE() {
        SQR_S25_PERSONNEL_RESOURCE retVal = (SQR_S25_PERSONNEL_RESOURCE)this.getTyped("PERSONNEL_RESOURCE", SQR_S25_PERSONNEL_RESOURCE.class);
        return retVal;
    }

    public SQR_S25_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE(int rep) {
        SQR_S25_PERSONNEL_RESOURCE retVal = (SQR_S25_PERSONNEL_RESOURCE)this.getTyped("PERSONNEL_RESOURCE", rep, SQR_S25_PERSONNEL_RESOURCE.class);
        return retVal;
    }

    public int getPERSONNEL_RESOURCEReps() {
        return this.getReps("PERSONNEL_RESOURCE");
    }

    public List<SQR_S25_PERSONNEL_RESOURCE> getPERSONNEL_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("PERSONNEL_RESOURCE", SQR_S25_PERSONNEL_RESOURCE.class);
    }

    public void insertPERSONNEL_RESOURCE(SQR_S25_PERSONNEL_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("PERSONNEL_RESOURCE", (Structure)structure, rep);
    }

    public SQR_S25_PERSONNEL_RESOURCE insertPERSONNEL_RESOURCE(int rep) throws HL7Exception {
        return (SQR_S25_PERSONNEL_RESOURCE)super.insertRepetition("PERSONNEL_RESOURCE", rep);
    }

    public SQR_S25_PERSONNEL_RESOURCE removePERSONNEL_RESOURCE(int rep) throws HL7Exception {
        return (SQR_S25_PERSONNEL_RESOURCE)super.removeRepetition("PERSONNEL_RESOURCE", rep);
    }

    public SQR_S25_LOCATION_RESOURCE getLOCATION_RESOURCE() {
        SQR_S25_LOCATION_RESOURCE retVal = (SQR_S25_LOCATION_RESOURCE)this.getTyped("LOCATION_RESOURCE", SQR_S25_LOCATION_RESOURCE.class);
        return retVal;
    }

    public SQR_S25_LOCATION_RESOURCE getLOCATION_RESOURCE(int rep) {
        SQR_S25_LOCATION_RESOURCE retVal = (SQR_S25_LOCATION_RESOURCE)this.getTyped("LOCATION_RESOURCE", rep, SQR_S25_LOCATION_RESOURCE.class);
        return retVal;
    }

    public int getLOCATION_RESOURCEReps() {
        return this.getReps("LOCATION_RESOURCE");
    }

    public List<SQR_S25_LOCATION_RESOURCE> getLOCATION_RESOURCEAll() throws HL7Exception {
        return this.getAllAsList("LOCATION_RESOURCE", SQR_S25_LOCATION_RESOURCE.class);
    }

    public void insertLOCATION_RESOURCE(SQR_S25_LOCATION_RESOURCE structure, int rep) throws HL7Exception {
        super.insertRepetition("LOCATION_RESOURCE", (Structure)structure, rep);
    }

    public SQR_S25_LOCATION_RESOURCE insertLOCATION_RESOURCE(int rep) throws HL7Exception {
        return (SQR_S25_LOCATION_RESOURCE)super.insertRepetition("LOCATION_RESOURCE", rep);
    }

    public SQR_S25_LOCATION_RESOURCE removeLOCATION_RESOURCE(int rep) throws HL7Exception {
        return (SQR_S25_LOCATION_RESOURCE)super.removeRepetition("LOCATION_RESOURCE", rep);
    }
}

