/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.SQM_S25_RESOURCES;
import ca.uhn.hl7v2.model.v24.segment.APR;
import ca.uhn.hl7v2.model.v24.segment.ARQ;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SQM_S25_REQUEST
extends AbstractGroup {
    public SQM_S25_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ARQ.class, true, false, false);
            this.add(APR.class, false, false, false);
            this.add(PID.class, false, false, false);
            this.add(SQM_S25_RESOURCES.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SQM_S25_REQUEST - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ARQ getARQ() {
        ARQ retVal = (ARQ)this.getTyped("ARQ", ARQ.class);
        return retVal;
    }

    public APR getAPR() {
        APR retVal = (APR)this.getTyped("APR", APR.class);
        return retVal;
    }

    public PID getPID() {
        PID retVal = (PID)this.getTyped("PID", PID.class);
        return retVal;
    }

    public SQM_S25_RESOURCES getRESOURCES() {
        SQM_S25_RESOURCES retVal = (SQM_S25_RESOURCES)this.getTyped("RESOURCES", SQM_S25_RESOURCES.class);
        return retVal;
    }

    public SQM_S25_RESOURCES getRESOURCES(int rep) {
        SQM_S25_RESOURCES retVal = (SQM_S25_RESOURCES)this.getTyped("RESOURCES", rep, SQM_S25_RESOURCES.class);
        return retVal;
    }

    public int getRESOURCESReps() {
        return this.getReps("RESOURCES");
    }

    public List<SQM_S25_RESOURCES> getRESOURCESAll() throws HL7Exception {
        return this.getAllAsList("RESOURCES", SQM_S25_RESOURCES.class);
    }

    public void insertRESOURCES(SQM_S25_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", (Structure)structure, rep);
    }

    public SQM_S25_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SQM_S25_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SQM_S25_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SQM_S25_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

