/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.PL;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class LCH
extends AbstractSegment {
    public LCH(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PL.class, true, 1, 20, new Object[]{this.getMessage()}, "Primary Key Value");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(EI.class, false, 1, 80, new Object[]{this.getMessage()}, "Segment Unique Key");
            this.add(CE.class, true, 1, 80, new Object[]{this.getMessage()}, "Location Characteristic ID");
            this.add(CE.class, true, 1, 80, new Object[]{this.getMessage()}, "Location Characteristic Value");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating LCH - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public PL getPrimaryKeyValue() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public PL getLch1_PrimaryKeyValue() {
        PL retVal = (PL)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getLch2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getSegmentUniqueKey() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getLch3_SegmentUniqueKey() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getLocationCharacteristicID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getLch4_LocationCharacteristicID() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getLocationCharacteristicValue() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getLch5_LocationCharacteristicValue() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new PL(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

