/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RDR_RDR_DEFINITION;
import ca.uhn.hl7v2.model.v23.segment.DSC;
import ca.uhn.hl7v2.model.v23.segment.ERR;
import ca.uhn.hl7v2.model.v23.segment.MSA;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDR_RDR
extends AbstractMessage {
    public RDR_RDR() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RDR_RDR(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(RDR_RDR_DEFINITION.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RDR_RDR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public RDR_RDR_DEFINITION getDEFINITION() {
        return (RDR_RDR_DEFINITION)this.getTyped("DEFINITION", RDR_RDR_DEFINITION.class);
    }

    public RDR_RDR_DEFINITION getDEFINITION(int rep) {
        return (RDR_RDR_DEFINITION)this.getTyped("DEFINITION", rep, RDR_RDR_DEFINITION.class);
    }

    public int getDEFINITIONReps() {
        return this.getReps("DEFINITION");
    }

    public List<RDR_RDR_DEFINITION> getDEFINITIONAll() throws HL7Exception {
        return this.getAllAsList("DEFINITION", RDR_RDR_DEFINITION.class);
    }

    public void insertDEFINITION(RDR_RDR_DEFINITION structure, int rep) throws HL7Exception {
        super.insertRepetition("DEFINITION", (Structure)structure, rep);
    }

    public RDR_RDR_DEFINITION insertDEFINITION(int rep) throws HL7Exception {
        return (RDR_RDR_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }

    public RDR_RDR_DEFINITION removeDEFINITION(int rep) throws HL7Exception {
        return (RDR_RDR_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

