/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_INTERNAL_LOCATION;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PV2
extends AbstractSegment {
    public PV2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CM_INTERNAL_LOCATION.class, false, 1, 12, new Object[]{this.getMessage()}, "Prior Pending Location");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Accommodation Code");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Admit Reason");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Transfer Reason");
            this.add(ST.class, false, 0, 25, new Object[]{this.getMessage()}, "Patient Valuables");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Patient Valuables Location");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(130)}, "Visit User Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Expected Admit Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Expected Discharge Date");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PV2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CM_INTERNAL_LOCATION getPriorPendingLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(1, 0);
        return retVal;
    }

    public CM_INTERNAL_LOCATION getPv21_PriorPendingLocation() {
        CM_INTERNAL_LOCATION retVal = (CM_INTERNAL_LOCATION)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getAccommodationCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getPv22_AccommodationCode() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getAdmitReason() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getPv23_AdmitReason() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getTransferReason() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getPv24_TransferReason() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getPatientValuables() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getPv25_PatientValuables() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public int getPatientValuablesReps() {
        return this.getReps(5);
    }

    public ST getPatientValuables(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getPv25_PatientValuables(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPv25_PatientValuablesReps() {
        return this.getReps(5);
    }

    public ST insertPatientValuables(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertPv25_PatientValuables(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removePatientValuables(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removePv25_PatientValuables(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST getPatientValuablesLocation() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPv26_PatientValuablesLocation() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getVisitUserCode() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getPv27_VisitUserCode() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public DT getExpectedAdmitDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getPv28_ExpectedAdmitDate() {
        DT retVal = (DT)this.getTypedField(8, 0);
        return retVal;
    }

    public DT getExpectedDischargeDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    public DT getPv29_ExpectedDischargeDate() {
        DT retVal = (DT)this.getTypedField(9, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CM_INTERNAL_LOCATION(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(130));
            }
            case 7: {
                return new DT(this.getMessage());
            }
            case 8: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

