/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CE;
import ca.uhn.hl7v2.model.v21.datatype.CN;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ORO
extends AbstractSegment {
    public ORO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "ORDER ITEM ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "SUBSTITUTE ALLOWED");
            this.add(CN.class, false, 0, 80, new Object[]{this.getMessage()}, "RESULTS COPIES TO");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(12)}, "STOCK LOCATION");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getORDERITEMID() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getOro1_ORDERITEMID() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSUBSTITUTEALLOWED() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getOro2_SUBSTITUTEALLOWED() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CN[] getRESULTSCOPIESTO() {
        CN[] retVal = (CN[])this.getTypedField(3, (Type[])new CN[0]);
        return retVal;
    }

    public CN[] getOro3_RESULTSCOPIESTO() {
        CN[] retVal = (CN[])this.getTypedField(3, (Type[])new CN[0]);
        return retVal;
    }

    public int getRESULTSCOPIESTOReps() {
        return this.getReps(3);
    }

    public CN getRESULTSCOPIESTO(int rep) {
        CN retVal = (CN)this.getTypedField(3, rep);
        return retVal;
    }

    public CN getOro3_RESULTSCOPIESTO(int rep) {
        CN retVal = (CN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOro3_RESULTSCOPIESTOReps() {
        return this.getReps(3);
    }

    public CN insertRESULTSCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(3, rep);
    }

    public CN insertOro3_RESULTSCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.insertRepetition(3, rep);
    }

    public CN removeRESULTSCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(3, rep);
    }

    public CN removeOro3_RESULTSCOPIESTO(int rep) throws HL7Exception {
        return (CN)super.removeRepetition(3, rep);
    }

    public ID getSTOCKLOCATION() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getOro4_STOCKLOCATION() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 2: {
                return new CN(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(12));
            }
        }
        return null;
    }
}

