/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.hapi.server;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.hoh.api.IMessageHandler;
import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.api.IResponseSendable;
import ca.uhn.hl7v2.hoh.api.MessageProcessingException;
import ca.uhn.hl7v2.hoh.raw.api.RawSendable;
import ca.uhn.hl7v2.hoh.raw.server.HohRawServlet;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AppRoutingDataImpl;
import ca.uhn.hl7v2.protocol.impl.ApplicationRouterImpl;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import java.util.HashMap;

public class HohServlet
extends HohRawServlet {
    private static final long serialVersionUID = 1L;
    private ApplicationRouter myApplicationRouter;

    public HohServlet() {
        super.setMessageHandler(new MessageHandlerImpl());
    }

    public void setApplication(ReceivingApplication<? extends Message> theApplication) {
        this.myApplicationRouter = new ApplicationRouterImpl();
        this.myApplicationRouter.bindApplication((ApplicationRouter.AppRoutingData)new AppRoutingDataImpl("*", "*", "*", "*"), theApplication);
    }

    public void setApplicationRouter(ApplicationRouter theApplicationRouter) {
        this.myApplicationRouter = theApplicationRouter;
    }

    @Override
    public void setMessageHandler(IMessageHandler<String> theMessageHandler) {
        throw new UnsupportedOperationException();
    }

    private class MessageHandlerImpl
    implements IMessageHandler<String> {
        private MessageHandlerImpl() {
        }

        @Override
        public IResponseSendable<String> messageReceived(IReceivable<String> theMessage) throws MessageProcessingException {
            Transportable response;
            TransportableImpl received = new TransportableImpl(theMessage.getMessage(), new HashMap<String, Object>(theMessage.getMetadata()));
            try {
                response = HohServlet.this.myApplicationRouter.processMessage((Transportable)received);
            }
            catch (HL7Exception e) {
                throw new MessageProcessingException(e);
            }
            return new RawSendable(response.getMessage());
        }
    }
}

