/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import java.util.HashMap;
import java.util.Map;

public enum EncodingStyle {
    ER7("application/hl7-v2"),
    XML("application/hl7-v2+xml");

    private static final Map<String, EncodingStyle> ourContentTypeToEncodingStyles;
    private final String myContentType;

    private EncodingStyle(String theContentType) {
        this.myContentType = theContentType;
    }

    public static EncodingStyle getEncodingStyleForContentType(String theContentType) {
        return ourContentTypeToEncodingStyles.get(theContentType.toLowerCase());
    }

    public static EncodingStyle detect(String theMessage) {
        if (theMessage == null) {
            throw new NullPointerException("Message can not be null");
        }
        for (int i = 0; i < theMessage.length(); ++i) {
            char nextChar = theMessage.charAt(i);
            if (Character.isLetter(nextChar)) {
                return ER7;
            }
            if (Character.isWhitespace(nextChar) || nextChar != '<') continue;
            return XML;
        }
        throw new IllegalArgumentException("Message does not appear to be ER7 or XML");
    }

    public String getContentType() {
        return this.myContentType;
    }

    static {
        ourContentTypeToEncodingStyles = new HashMap<String, EncodingStyle>();
        for (EncodingStyle next : EncodingStyle.values()) {
            ourContentTypeToEncodingStyles.put(next.myContentType, next);
        }
    }
}

