/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.sockets;

import ca.uhn.hl7v2.hoh.sockets.CustomCertificateTlsSocketFactory;
import ca.uhn.hl7v2.hoh.sockets.ISocketFactory;
import ca.uhn.hl7v2.hoh.util.RandomServerPortProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLServerSocket;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomCertificateTlsSocketFactoryTest {
    private static final Logger ourLog = LoggerFactory.getLogger(CustomCertificateTlsSocketFactoryTest.class);
    private int myPort;

    @Before
    public void before() {
        this.myPort = RandomServerPortProvider.findFreePort();
    }

    @Test
    public void testConnectToNonTrustedSocket() throws IOException, InterruptedException {
        CustomCertificateTlsSocketFactory badServer = CustomCertificateTlsSocketFactoryTest.createTrustedServerSocketFactory();
        Receiver receiver = new Receiver(badServer);
        receiver.start();
        Thread.sleep(500L);
        try {
            CustomCertificateTlsSocketFactory goodClient = CustomCertificateTlsSocketFactoryTest.createNonTrustedClientSocketFactory();
            Socket client = goodClient.createClientSocket();
            client.connect(new InetSocketAddress("localhost", this.myPort));
            client.getOutputStream().write("HELLO WORLD".getBytes());
            Assert.fail();
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            // empty catch block
        }
    }

    @Test
    public void testConnectToTrustedSocket() throws IOException, InterruptedException {
        CustomCertificateTlsSocketFactory goodServer = CustomCertificateTlsSocketFactoryTest.createTrustedServerSocketFactory();
        Receiver receiver = new Receiver(goodServer);
        receiver.start();
        Thread.sleep(500L);
        CustomCertificateTlsSocketFactory goodClient = new CustomCertificateTlsSocketFactory();
        goodClient.setKeystoreFilename("src/test/resources/truststore.jks");
        Socket client = goodClient.createClientSocket();
        client.connect(new InetSocketAddress("localhost", this.myPort));
        client.getOutputStream().write("HELLO WORLD".getBytes());
        client.close();
        Thread.sleep(500L);
        String expected = "HELLO WORLD";
        String actual = receiver.myString;
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static CustomCertificateTlsSocketFactory createNonTrustedClientSocketFactory() {
        CustomCertificateTlsSocketFactory goodClient = new CustomCertificateTlsSocketFactory();
        goodClient.setKeystoreFilename("src/test/resources/truststore2.jks");
        goodClient.setKeystorePassphrase("trustpassword");
        return goodClient;
    }

    public static CustomCertificateTlsSocketFactory createTrustedClientSocketFactory() {
        CustomCertificateTlsSocketFactory goodClient = new CustomCertificateTlsSocketFactory();
        goodClient.setKeystoreFilename("src/test/resources/truststore.jks");
        return goodClient;
    }

    public static CustomCertificateTlsSocketFactory createTrustedServerSocketFactory() {
        CustomCertificateTlsSocketFactory goodServer = new CustomCertificateTlsSocketFactory();
        goodServer.setKeystoreFilename("src/test/resources/keystore.jks");
        goodServer.setKeystorePassphrase("changeit");
        return goodServer;
    }

    public static void main(String[] args) throws Exception {
        Server s = new Server();
        SslSelectChannelConnector ssl = new SslSelectChannelConnector();
        ssl.setKeystore("src/test/resources/keystore.jks");
        ssl.setPassword("changeit");
        ssl.setKeyPassword("changeit");
        ssl.setPort(60647);
        s.addConnector((Connector)ssl);
        s.start();
    }

    private class Receiver
    extends Thread {
        private ISocketFactory myFactory;
        private ServerSocket myServer;
        private String myString;

        public Receiver(ISocketFactory theFactory) {
            this.myFactory = theFactory;
        }

        public void run() {
            block13: {
                try {
                    try {
                        int next;
                        ourLog.info("Listening on port {}", (Object)CustomCertificateTlsSocketFactoryTest.this.myPort);
                        this.myServer = this.myFactory.createServerSocket();
                        this.myServer.bind(new InetSocketAddress(CustomCertificateTlsSocketFactoryTest.this.myPort));
                        this.myServer.setSoTimeout(3000);
                        SSLServerSocket ss = (SSLServerSocket)this.myServer;
                        ourLog.info(Arrays.asList(ss.getEnabledCipherSuites()).toString());
                        Socket socket = this.myServer.accept();
                        socket.setSoTimeout(2000);
                        InputStream is = socket.getInputStream();
                        StringBuilder b = new StringBuilder();
                        while ((next = is.read()) != -1) {
                            b.append((char)next);
                            ourLog.info("Received: " + b);
                        }
                        this.myString = b.toString();
                    }
                    catch (Throwable e) {
                        ourLog.error("Failed", e);
                        Assert.fail((String)e.getMessage());
                        if (this.myServer == null) break block13;
                        try {
                            this.myServer.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (this.myServer != null) {
                        try {
                            this.myServer.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

