/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.hapi.api;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.hoh.api.IResponseSendable;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.encoder.ResponseCode;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.hl7v2.util.Terser;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageSendable
implements IResponseSendable<Message> {
    private static final Logger ourLog = LoggerFactory.getLogger(MessageSendable.class);
    private final Message myMessage;
    private final EncodingStyle myEncodingStyle;
    private ResponseCode myResponseCode;
    private String myRawMessage;

    public MessageSendable(Message theMessage) throws HL7Exception {
        this(theMessage, theMessage.getParser());
    }

    public MessageSendable(Message theMessage, Parser theParser) throws HL7Exception {
        if (theMessage == null) {
            throw new NullPointerException("Raw Message may not be null");
        }
        this.myMessage = theMessage;
        this.myEncodingStyle = this.detectEncodingStyle(theParser);
        this.myRawMessage = theParser.encode(this.myMessage);
    }

    private EncodingStyle detectEncodingStyle(Parser theParser) {
        if (theParser instanceof XMLParser) {
            return EncodingStyle.XML;
        }
        if (theParser instanceof GenericParser && !((GenericParser)theParser).isPipeParserPrimary()) {
            return EncodingStyle.XML;
        }
        return EncodingStyle.ER7;
    }

    @Override
    public void writeMessage(Writer theWriter) throws IOException {
        theWriter.append(this.myRawMessage);
        theWriter.flush();
    }

    @Override
    public EncodingStyle getEncodingStyle() {
        return this.myEncodingStyle;
    }

    @Override
    public ResponseCode getResponseCode() {
        if (this.myResponseCode == null) {
            try {
                this.myResponseCode = ResponseCode.detect(new Terser(this.myMessage).get("/MSA-2"));
                if (this.myResponseCode == null) {
                    throw new HL7Exception("No response code in message, this is probably an error");
                }
            }
            catch (HL7Exception e) {
                ourLog.info("Could not detect response code in message", (Throwable)e);
                this.myResponseCode = ResponseCode.HTTP_500_INTERNAL_SERVER_ERROR;
            }
        }
        return this.myResponseCode;
    }

    @Override
    public Message getMessage() {
        return this.myMessage;
    }
}

