/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttpEncoder;
import ca.uhn.hl7v2.hoh.encoder.ResponseCode;
import ca.uhn.hl7v2.hoh.util.VersionLogger;

public class Hl7OverHttpResponseEncoder
extends AbstractHl7OverHttpEncoder {
    private boolean myAddConnectionCloseHeader;

    protected void addSpecificHeaders() {
        this.getHeaders().put("Server", "HAPI (HL7 over HTTP) Server " + VersionLogger.getVersion());
        if (this.isGzipData()) {
            this.getHeaders().put("Content-Encoding", "gzip");
        }
        if (this.myAddConnectionCloseHeader) {
            this.getHeaders().put("Connection", "close");
        }
    }

    protected void setActionLineAppropriately() {
        ResponseCode resp = ResponseCode.detect(this.getMessage());
        this.setActionLine("HTTP/1.1 " + resp.getCode() + " " + resp.getMessage());
    }

    public void setAddConnectionCloseHeader(boolean theAddConnectionCloseHeader) {
        this.myAddConnectionCloseHeader = theAddConnectionCloseHeader;
    }

    public void setGzipData(boolean theGzipData) {
        super.setGzipData(theGzipData);
    }
}

