/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.NonHl7ResponseException;
import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttp;
import ca.uhn.hl7v2.hoh.encoder.AuthorizationFailureException;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestDecoder;
import ca.uhn.hl7v2.hoh.encoder.NoMessageReceivedException;
import ca.uhn.hl7v2.hoh.encoder.TransferEncoding;
import ca.uhn.hl7v2.hoh.sign.SignatureFailureException;
import ca.uhn.hl7v2.hoh.sign.SignatureVerificationException;
import ca.uhn.hl7v2.hoh.util.ByteUtils;
import ca.uhn.hl7v2.hoh.util.GZipUtils;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import ca.uhn.hl7v2.hoh.util.repackage.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHl7OverHttpDecoder
extends AbstractHl7OverHttp {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    public static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final Logger ourLog = LoggerFactory.getLogger(AbstractHl7OverHttpDecoder.class);
    private byte[] myBytes;
    private List<String> myConformanceProblems;
    private int myContentLength = -1;
    private String myContentType;
    private boolean myGzipCoding;
    private long myLastStartedReading;
    private long myReadTimeout = 30000L;
    private String myResponseName;
    private Integer myResponseStatus;
    private TransferEncoding myTransferEncoding;
    private String mySignature;
    private EncodingStyle myEncodingStyle;
    private boolean myConnectionCloseHeaderIsPresent;

    private void addConformanceProblem(String theString) {
        ourLog.debug("Conformance problem detected: {}", (Object)theString);
        if (this.myConformanceProblems == null) {
            this.myConformanceProblems = new ArrayList<String>();
        }
        this.myConformanceProblems.add(theString);
    }

    protected abstract void authorize() throws AuthorizationFailureException;

    public void decode() throws DecodeException, SignatureVerificationException {
        ourLog.trace("Entering decode()");
        this.verifyNotUsed();
        this.decodeHeaders();
        this.authorize();
        this.decodeBody();
        this.verifySignature();
        ourLog.trace("Exiting decode()");
    }

    private void decodeBody() throws DecodeException {
        byte[] bytes = this.myBytes;
        if (this.myGzipCoding) {
            ourLog.debug("Decoding message contents using GZIP encoding style");
            try {
                bytes = GZipUtils.uncompress(bytes);
            }
            catch (IOException e) {
                throw new DecodeException("Failed to uncompress GZip content", e);
            }
        }
        Charset charset = this.getCharset();
        ourLog.debug("Message is {} bytes with charset {}", (Object)bytes.length, (Object)charset.name());
        if (ourLog.isTraceEnabled()) {
            ourLog.trace("Raw message: {}", (Object)StringUtils.asciiEscape(bytes, charset));
        }
        String messageString = new String(bytes, charset);
        this.setMessage(messageString);
    }

    private void decodeHeaders() throws DecodeException {
        ourLog.trace("Header map contains: {}", (Object)this.getHeaders());
        for (Map.Entry nextEntry : this.getHeaders().entrySet()) {
            String nextHeader = ((String)nextEntry.getKey()).toLowerCase();
            String nextValue = (String)nextEntry.getValue();
            ourLog.trace("Next header: {}={}", (Object)nextHeader, (Object)nextValue);
            if ("transfer-encoding".equals(nextHeader)) {
                if ("chunked".equalsIgnoreCase(nextValue)) {
                    this.myTransferEncoding = TransferEncoding.CHUNKED;
                    ourLog.trace("Found chunked transfer encoding");
                    continue;
                }
                throw new DecodeException("Unknown transfer encoding: " + nextValue);
            }
            if ("connection".equals(nextHeader)) {
                if (!"close".equals(nextValue)) continue;
                this.myConnectionCloseHeaderIsPresent = true;
                continue;
            }
            if ("content-length".equals(nextHeader)) {
                try {
                    this.myContentLength = Integer.parseInt(nextValue);
                    ourLog.trace("Found content length: {}", (Object)this.myContentLength);
                }
                catch (NumberFormatException e) {
                    this.addConformanceProblem("Could not parse Content-Length header value: " + nextHeader);
                }
                continue;
            }
            if ("content-type".equals(nextHeader)) {
                int colonIndex = nextValue.indexOf(59);
                if (colonIndex == -1) {
                    this.myContentType = nextValue.trim();
                } else {
                    this.myContentType = nextValue.substring(0, colonIndex).trim();
                    String charsetDef = nextValue.substring(colonIndex + 1).trim();
                    if (charsetDef.startsWith("charset=")) {
                        Charset charset;
                        String charsetName = charsetDef.substring(8);
                        try {
                            charset = Charset.forName(charsetName);
                        }
                        catch (UnsupportedCharsetException e) {
                            this.addConformanceProblem("Unsupported or invalid charset: " + charsetName);
                            continue;
                        }
                        this.setCharset(charset);
                    }
                }
                this.myEncodingStyle = EncodingStyle.getEncodingStyleForContentType(this.myContentType);
                ourLog.trace("Found content type {} with resolves to encoding style {}", (Object)this.myContentType, (Object)this.myEncodingStyle);
                continue;
            }
            if ("authorization".equals(nextHeader)) {
                int spaceIndex = nextValue.indexOf(32);
                if (spaceIndex == -1) {
                    throw new DecodeException("Invalid authorization header. No authorization style detected");
                }
                String type = nextValue.substring(0, spaceIndex);
                if ("basic".equalsIgnoreCase(type)) {
                    String encodedCredentials = nextValue.substring(spaceIndex + 1);
                    byte[] decodedCredentials = Base64.decodeBase64(encodedCredentials);
                    String credentialsString = new String(decodedCredentials, AbstractHl7OverHttpDecoder.getDefaultCharset());
                    int colonIndex = credentialsString.indexOf(58);
                    if (colonIndex == -1) {
                        this.setUsername(credentialsString);
                    } else {
                        this.setUsername(credentialsString.substring(0, colonIndex));
                        this.setPassword(credentialsString.substring(colonIndex + 1));
                    }
                    ourLog.trace("Found authorization header with username: {}", (Object)this.getUsername());
                    continue;
                }
                this.addConformanceProblem("Invalid authorization type. Only basic authorization is supported.");
                continue;
            }
            if ("content-encoding".equals(nextHeader)) {
                if (StringUtils.isNotBlank(nextValue)) {
                    if ("gzip".equals(nextValue)) {
                        this.myGzipCoding = true;
                    } else {
                        throw new DecodeException("Unknown Content-Encoding: " + nextValue);
                    }
                }
                ourLog.trace("Found content coding: {}", (Object)nextValue);
                continue;
            }
            if (HTTP_HEADER_HL7_SIGNATURE_LC.equals(nextHeader)) {
                ourLog.trace("Found signature: {}", (Object)nextValue);
                this.mySignature = nextValue;
                continue;
            }
            ourLog.trace("Ignoring header {}={}", (Object)nextHeader, (Object)nextValue);
        }
        ourLog.trace("Done processing headers");
    }

    protected boolean isConnectionCloseHeaderPresent() {
        return this.myConnectionCloseHeaderIsPresent;
    }

    public EncodingStyle getEncodingStyle() {
        return this.myEncodingStyle;
    }

    private void doReadContentsFromInputStreamAndDecode(InputStream theInputStream) throws DecodeException, AuthorizationFailureException, IOException, SignatureVerificationException {
        this.decodeHeaders();
        this.authorize();
        this.myBytes = this.myTransferEncoding == TransferEncoding.CHUNKED ? this.readBytesChunked(theInputStream) : this.readBytesNonChunked(theInputStream);
        this.decodeBody();
        if (this.getContentType() == null) {
            throw new DecodeException("Content-Type not specified");
        }
        if (this.getEncodingStyle() == null) {
            throw new NonHl7ResponseException("Invalid Content-Type: " + this.getContentType(), this.getContentType(), this.getMessage());
        }
        this.verifySignature();
    }

    private byte[] readBytesChunked(InputStream theInputStream) throws DecodeException, IOException {
        boolean trailing;
        ourLog.debug("Decoding message bytes using CHUNKED encoding style");
        byte[] byteBuffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        block6: do {
            int nextChar;
            int nextSizeInt;
            String nextSize;
            try {
                nextSize = this.readLine(theInputStream);
            }
            catch (IOException e) {
                throw new DecodeException("Failed to decode CHUNKED encoding", e);
            }
            ourLog.trace("Going to interpret CHUNKED size value: {}", (Object)nextSize);
            if (nextSize.length() == 0) break;
            try {
                nextSizeInt = Integer.parseInt(nextSize, 16);
            }
            catch (NumberFormatException e) {
                throw new DecodeException("Failed to decode CHUNKED encoding", e);
            }
            ourLog.debug("Next CHUNKED size: {}", (Object)nextSizeInt);
            if (nextSizeInt < 0) {
                throw new DecodeException("Received invalid octet count in chunked transfer encoding: " + nextSize);
            }
            trailing = false;
            if (nextSizeInt > 0) {
                int totalRead = 0;
                this.myLastStartedReading = System.currentTimeMillis();
                do {
                    int nextRead;
                    int bytesRead;
                    if ((bytesRead = theInputStream.read(byteBuffer, 0, nextRead = Math.min(nextSizeInt, byteBuffer.length))) == -1) {
                        ourLog.debug("Exception in readBytesChunked(InputStream): Reached EOF. Buffer has {} bytes", (Object)bos.size());
                        throw new DecodeException("Reached EOF while reading in message chunk");
                    }
                    if (bytesRead == 0 && totalRead < nextSizeInt) {
                        this.pauseDuringTimedOutRead();
                    }
                    totalRead += bytesRead;
                    if (ourLog.isTraceEnabled()) {
                        ourLog.trace("Read {} byte chunk: {}", (Object)bytesRead, (Object)new String(byteBuffer, 0, bytesRead));
                    } else {
                        ourLog.debug("Read {} byte chunk", (Object)bytesRead);
                    }
                    bos.write(byteBuffer, 0, bytesRead);
                } while (totalRead < nextSizeInt);
            } else {
                trailing = true;
            }
            boolean had13 = false;
            boolean had10 = false;
            while (true) {
                block18: {
                    try {
                        nextChar = theInputStream.read();
                        if (!ourLog.isTraceEnabled()) break block18;
                        ourLog.trace("Read byte: " + (char)nextChar + " (" + nextChar + ")");
                    }
                    catch (SocketTimeoutException e) {
                        continue block6;
                    }
                }
                if (nextChar == -1) continue block6;
                if (nextChar != 13) break;
                if (had13) {
                    trailing = true;
                }
                had13 = true;
            }
            if (nextChar != 10 || !had10) continue;
            trailing = true;
        } while (!trailing);
        return bos.toByteArray();
    }

    private void verifySignature() throws SignatureVerificationException, DecodeException {
        if (this.getSigner() != null && StringUtils.isBlank(this.mySignature)) {
            String mode = this instanceof Hl7OverHttpRequestDecoder ? "request" : "response";
            throw new SignatureVerificationException("No HL7 Signature found in " + mode);
        }
        if (this.getSigner() != null) {
            try {
                this.getSigner().verify(this.myBytes, this.mySignature);
            }
            catch (SignatureFailureException e) {
                throw new DecodeException("Failed to verify signature due to an error (signature may possibly be valid, but verification failed)", e);
            }
        }
    }

    public List<String> getConformanceProblems() {
        if (this.myConformanceProblems == null) {
            this.myConformanceProblems = new ArrayList<String>();
        }
        return this.myConformanceProblems;
    }

    public String getContentType() {
        return this.myContentType;
    }

    public String getResponseName() {
        return this.myResponseName;
    }

    public Integer getResponseStatus() {
        return this.myResponseStatus;
    }

    protected abstract String readActionLineAndDecode(InputStream var1) throws IOException, NoMessageReceivedException, DecodeException;

    private byte[] readBytesNonChunked(InputStream theInputStream) throws IOException {
        ourLog.debug("Decoding message bytes using non-chunked encoding style");
        int length = this.myContentLength > 0 ? this.myContentLength : 4096;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        byte[] buffer = new byte[4096];
        this.myLastStartedReading = System.currentTimeMillis();
        while (this.myContentLength < 0 || bos.size() < this.myContentLength) {
            int max;
            if (this.myContentLength < 0) {
                try {
                    if (theInputStream.available() <= 0) {
                        ourLog.trace("No more bytes available");
                        break;
                    }
                }
                catch (IOException e) {
                    ourLog.debug("Received IOException while calling inputStream#available()", (Throwable)e);
                    throw e;
                }
            }
            if (this.myContentLength > 0) {
                max = this.myContentLength - bos.size();
                max = Math.min(max, buffer.length);
            } else {
                max = buffer.length;
            }
            try {
                int bytesRead = theInputStream.read(buffer, 0, max);
                this.myLastStartedReading = System.currentTimeMillis();
                if (bytesRead == -1) {
                    ourLog.trace("Read end of stream");
                    break;
                }
                if (ourLog.isTraceEnabled()) {
                    ourLog.trace("Read {} bytes from stream:\n{}", (Object)bytesRead, (Object)ByteUtils.formatBytesForLogging(bytesRead, 0, buffer));
                }
                bos.write(buffer, 0, bytesRead);
            }
            catch (SocketTimeoutException e) {
                long elapsed = System.currentTimeMillis() - this.myLastStartedReading;
                if (elapsed > this.myReadTimeout) {
                    throw e;
                }
                ourLog.debug("Trying to read for {} / {}ms, going to keep trying", (Object)elapsed, (Object)this.myReadTimeout);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {}
            }
            catch (IOException e) {
                ourLog.debug("Received IOException while calling inputStream#available()", (Throwable)e);
                throw e;
            }
        }
        return bos.toByteArray();
    }

    public void readContentsFromInputStreamAndDecode(InputStream theInputStream) throws AuthorizationFailureException, DecodeException, IOException, SignatureVerificationException {
        this.verifyNotUsed();
        this.doReadContentsFromInputStreamAndDecode(theInputStream);
    }

    protected String readFirstLine(InputStream theInputStream) throws IOException, NoMessageReceivedException {
        ourLog.trace("Entering readFirstLine(InputStream) with IS: {}", (Object)theInputStream);
        String retVal = this.readLine(theInputStream, true);
        ourLog.trace("Exiting readFirstLine(InputStream) with result: {}", (Object)retVal);
        return retVal;
    }

    public void readHeadersAndContentsFromInputStreamAndDecode(InputStream theInputStream) throws IOException, DecodeException, NoMessageReceivedException, SignatureVerificationException {
        this.verifyNotUsed();
        String actionLine = this.readActionLineAndDecode(theInputStream);
        ourLog.debug("Read action line: {}", (Object)actionLine);
        if (this.getHeaders() == null) {
            String nextLine;
            this.setHeaders(new LinkedHashMap());
            while ((nextLine = this.readLine(theInputStream)).length() != 0) {
                int colonIndex = nextLine.indexOf(58);
                if (colonIndex == -1) {
                    throw new DecodeException("Invalid HTTP header line detected. Value is: " + nextLine);
                }
                String key = nextLine.substring(0, colonIndex);
                String value = nextLine.substring(colonIndex + 1).trim();
                ourLog.debug("Read header {}={}", (Object)key, (Object)value);
                this.getHeaders().put(key, value);
            }
        }
        this.doReadContentsFromInputStreamAndDecode(theInputStream);
    }

    private String readLine(InputStream theInputStream) throws IOException {
        try {
            return this.readLine(theInputStream, false);
        }
        catch (NoMessageReceivedException e) {
            throw new Error("Threw a NoMessageReceivedException. This should not happen.", e);
        }
    }

    private String readLine(InputStream theInputStream, boolean theFirstLine) throws IOException, NoMessageReceivedException {
        this.myLastStartedReading = System.currentTimeMillis();
        StringBuilder retVal = new StringBuilder();
        while (true) {
            int b;
            block5: {
                try {
                    b = theInputStream.read();
                    if (!ourLog.isTraceEnabled()) break block5;
                    ourLog.trace("Read byte: " + (char)b + " (" + b + ")");
                }
                catch (SocketTimeoutException e) {
                    if (retVal.length() == 0 && theFirstLine) {
                        ourLog.trace("No message received, aborting readLine(InputStream, boolean)");
                        throw new NoMessageReceivedException();
                    }
                    ourLog.trace("No message received in readLine(InputStream, boolean), going to wait and continue");
                    this.pauseDuringTimedOutRead();
                    continue;
                }
            }
            if (b == 13) continue;
            if (b == 10) break;
            if (b == -1) {
                ourLog.debug("Current read line is: {}", (Object)retVal);
                ourLog.info("Read -1 from input stream, closing it");
                theInputStream.close();
                if (retVal.length() != 0) break;
                throw new SocketException("Received EOF from input stream");
            }
            if (b < 32) continue;
            retVal.append((char)b);
        }
        ourLog.debug("Current read line is: {}", (Object)retVal);
        return WHITESPACE_PATTERN.matcher(retVal.toString()).replaceAll(" ").trim();
    }

    private void pauseDuringTimedOutRead() throws SocketTimeoutException {
        long elapsed = System.currentTimeMillis() - this.myLastStartedReading;
        if (elapsed > this.myReadTimeout) {
            ourLog.trace("Elapsed time of {} exceeds max {}, throwing SocketTimeoutException", (Object)elapsed, (Object)this.myReadTimeout);
            throw new SocketTimeoutException();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setReadTimeout(long theReadTimeout) {
        this.myReadTimeout = theReadTimeout;
    }

    public void setResponseName(String theResponseName) {
        this.myResponseName = theResponseName;
    }

    public void setResponseStatus(Integer theResponseStatus) {
        this.myResponseStatus = theResponseStatus;
    }
}

