/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSResourceResolver;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final Logger ourLog = LoggerFactory.getLogger(XMLUtils.class);
    private static DOMImplementation IMPL;

    public static synchronized <T> T getDOMImpl() {
        if (IMPL == null) {
            try {
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                IMPL = registry.getDOMImplementation("LS 3.0");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return (T)IMPL;
    }

    public static Document parse(String s) {
        return XMLUtils.parseDocument(new InputSource(new StringReader(s)), false);
    }

    public static Document parse(String s, boolean validateIfSchema) {
        return XMLUtils.parseDocument(new InputSource(new StringReader(s)), validateIfSchema);
    }

    public static Document parse(InputStream s, boolean validateIfSchema) {
        return XMLUtils.parseDocument(new InputSource(s), validateIfSchema);
    }

    public static Document parseDocument(InputSource theInputSource, boolean theValidating) {
        DocumentBuilder builder;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setXIncludeAware(false);
            docBuilderFactory.setExpandEntityReferences(false);
            docBuilderFactory.setValidating(theValidating);
            try {
                docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (Exception e) {
                ourLog.warn("Failed to set feature on XML parser: " + e.toString());
            }
            builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            return builder.parse(theInputSource);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static void validate(Document d, String schema, DOMErrorHandler handler) {
        DOMConfiguration config = d.getDomConfig();
        config.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
        config.setParameter("validate", true);
        config.setParameter("schema-location", schema);
        config.setParameter("resource-resolver", new ClasspathResourceResolver());
        config.setParameter("error-handler", handler);
        d.normalizeDocument();
    }

    public static String serialize(Document document, boolean prettyPrint) {
        DOMImplementationLS impl = (DOMImplementationLS)XMLUtils.getDOMImpl();
        LSSerializer serializer = impl.createLSSerializer();
        DOMConfiguration config = serializer.getDomConfig();
        if (prettyPrint && config.canSetParameter("format-pretty-print", Boolean.TRUE)) {
            config.setParameter("format-pretty-print", true);
        }
        config.setParameter("xml-declaration", true);
        LSOutput output = impl.createLSOutput();
        output.setEncoding("UTF-8");
        StringWriter writer = new StringWriter();
        output.setCharacterStream(writer);
        serializer.write(document, output);
        return ((Object)writer).toString();
    }

    public static Document emptyDocument(String title) {
        DOMImplementation impl = (DOMImplementation)XMLUtils.getDOMImpl();
        return impl.createDocument("urn:hl7-org:v2xml", title, null);
    }

    private static class ClasspathResourceResolver
    implements LSResourceResolver {
        private final DOMImplementationLS impl = (DOMImplementationLS)XMLUtils.getDOMImpl();

        ClasspathResourceResolver() {
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            LSInput lsInput = this.impl.createLSInput();
            InputStream is = this.getClass().getResourceAsStream("/" + systemId);
            if (is == null) {
                return null;
            }
            lsInput.setByteStream(is);
            return lsInput;
        }
    }
}

