/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.util.Pair;
import ca.uhn.hl7v2.util.XMLUtils;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EncodedMessageComparator {
    static final GenericParser parser = new GenericParser();

    public static String standardize(String message) throws SAXException {
        String encoding = parser.getEncoding(message);
        String result = encoding.equals("XML") ? EncodedMessageComparator.standardizeXML(message) : EncodedMessageComparator.standardizeER7(message);
        return result;
    }

    public static String standardizeER7(String message) {
        char fieldDelimChar = ((String)message).charAt(3);
        Object fieldDelim = String.valueOf(fieldDelimChar);
        if (!Character.isLetterOrDigit(fieldDelimChar)) {
            fieldDelim = "\\" + fieldDelimChar;
        }
        char compSepChar = ((String)message).charAt(4);
        Object compSep = String.valueOf(compSepChar);
        if (!Character.isLetterOrDigit(compSepChar)) {
            compSep = "\\" + compSepChar;
        }
        char repSepChar = ((String)message).charAt(5);
        Object repSep = String.valueOf(repSepChar);
        if (!Character.isLetterOrDigit(repSepChar)) {
            repSep = "\\" + repSepChar;
        }
        char subSepChar = ((String)message).charAt(7);
        Object subSep = String.valueOf(subSepChar);
        if (!Character.isLetterOrDigit(subSepChar)) {
            subSep = "\\" + subSepChar;
        }
        Pattern endSegment = Pattern.compile("[" + (String)fieldDelim + (String)compSep + (String)repSep + (String)subSep + "]*[\n\r]+");
        message = endSegment.matcher((CharSequence)message).replaceAll("\r");
        Pattern endField = Pattern.compile("[" + (String)repSep + (String)compSep + (String)subSep + "]*" + (String)fieldDelim);
        message = endField.matcher((CharSequence)message).replaceAll((String)fieldDelim);
        Pattern endComp = Pattern.compile("[" + (String)subSep + "]*" + (String)compSep);
        message = endComp.matcher((CharSequence)message).replaceAll((String)compSep);
        message = ((String)message).substring(0, 7) + subSepChar + ((String)message).substring(7);
        return message;
    }

    public static String standardizeXML(String message) {
        try {
            Document doc = XMLUtils.parse(message);
            EncodedMessageComparator.clean(doc.getDocumentElement());
            return XMLUtils.serialize(doc, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while standardizing XML ", e);
        }
    }

    private static void clean(Element elem) {
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 7 || child.getNodeType() == 8) {
                elem.removeChild(child);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            EncodedMessageComparator.clean((Element)child);
        }
        NamedNodeMap attributes = elem.getAttributes();
        String[] names = new String[attributes.getLength()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = attributes.item(i).getNodeName();
        }
        for (String name : names) {
            attributes.removeNamedItem(name);
        }
    }

    public static boolean equivalent(String message1, String message2) throws HL7Exception {
        Pair<String> messages = EncodedMessageComparator.standardize(message1, message2);
        return messages.getValue1().equals(messages.getValue2());
    }

    static Pair<String> standardize(String message1, String message2) throws HL7Exception {
        String std2;
        String std1;
        String encoding2;
        String encoding1 = parser.getEncoding(message1);
        if (!encoding1.equals(encoding2 = parser.getEncoding(message2))) {
            if (encoding1.equals("XML")) {
                message1 = EncodedMessageComparator.safeER7Conversion(message1);
            } else {
                message2 = EncodedMessageComparator.safeER7Conversion(message2);
            }
        }
        try {
            std1 = EncodedMessageComparator.standardize(message1);
            std2 = EncodedMessageComparator.standardize(message2);
        }
        catch (SAXException e) {
            throw new HL7Exception("Equivalence check failed due to SAXException: " + e.getMessage());
        }
        return new Pair<String>(std1, std2);
    }

    static String safeER7Conversion(String xmlMessage) throws HL7Exception {
        Message m = parser.parse(xmlMessage);
        String check = parser.encode(m, "XML");
        if (!EncodedMessageComparator.equivalent(xmlMessage, check)) {
            throw new HL7Exception("Parsed and encoded message not equivalent to original (possibilities: invalid message, bug in parser)");
        }
        return parser.encode(m, "VB");
    }
}

