/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.Transportable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransport
implements TransportLayer {
    private static final Logger log = LoggerFactory.getLogger(AbstractTransport.class);
    private final Map<String, Object> myCommonMetadata = new HashMap<String, Object>();
    private boolean myIsConnected = false;

    @Override
    public Map<String, Object> getCommonMetadata() {
        return this.myCommonMetadata;
    }

    @Override
    public Transportable receive() throws TransportException {
        if (!this.isConnected()) {
            throw new TransportException("Can't receive because TransportLayer is not connected");
        }
        Transportable message = this.doReceive();
        if (message != null) {
            message.getMetadata().putAll(this.myCommonMetadata);
        }
        log.debug("Received: {} ", (Object)(message == null ? null : message.getMessage()));
        return message;
    }

    public abstract Transportable doReceive() throws TransportException;

    @Override
    public void send(Transportable theMessage) throws TransportException {
        if (!this.isConnected()) {
            throw new TransportException("Can't send because TransportLayer is not connected");
        }
        this.doSend(theMessage);
        log.debug("Sent: {}", (Object)(theMessage == null ? null : theMessage.getMessage()));
    }

    public abstract void doSend(Transportable var1) throws TransportException;

    @Override
    public void connect() throws TransportException {
        this.myIsConnected = false;
        this.doConnect();
        this.myIsConnected = true;
    }

    public abstract void doConnect() throws TransportException;

    @Override
    public boolean isConnected() {
        return this.myIsConnected;
    }

    @Override
    public void disconnect() throws TransportException {
        this.myIsConnected = false;
        this.doDisconnect();
    }

    public abstract void doDisconnect() throws TransportException;
}

