/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.parser.PipeParser;
import java.util.StringTokenizer;

public final class EncodingDetector {
    private EncodingDetector() {
    }

    public static void assertEr7Encoded(String theMessage) {
        if (theMessage.length() < 4) {
            throw new RuntimeException("The message is less than 4 characters long");
        }
        if (!theMessage.startsWith("MSH")) {
            throw new RuntimeException("The message does not start with MSH");
        }
        char fourthChar = theMessage.charAt(3);
        StringTokenizer st = new StringTokenizer(theMessage, "\r", false);
        while (st.hasMoreTokens()) {
            String x = st.nextToken();
            if (x.length() <= 0) continue;
            if (Character.isWhitespace(x.charAt(0))) {
                x = PipeParser.stripLeadingWhitespace(x);
            }
            if (x.length() < 4 || x.charAt(3) == fourthChar) continue;
            throw new RuntimeException(String.format("The 4th character should have been a %c, but it was a %c", Character.valueOf(x.charAt(3)), Character.valueOf(fourthChar)));
        }
        int nextFieldDelimLoc = 0;
        for (int i = 0; i < 11; ++i) {
            if ((nextFieldDelimLoc = theMessage.indexOf(fourthChar, nextFieldDelimLoc + 1)) >= 0) continue;
            throw new RuntimeException("Expected to find required field MSH-12");
        }
    }

    public static boolean isEr7Encoded(String theMessage) {
        try {
            EncodingDetector.assertEr7Encoded(theMessage);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void assertXmlEncoded(String theMessage) {
        if (!theMessage.contains("MSH.1>")) {
            throw new RuntimeException("Expected to find MSH.1");
        }
        if (!theMessage.contains("MSH.2>")) {
            throw new RuntimeException("Expected to find MSH.2");
        }
    }

    public static boolean isXmlEncoded(String theMessage) {
        try {
            EncodingDetector.assertXmlEncoded(theMessage);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

