/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.Processor;
import ca.uhn.hl7v2.protocol.SafeStorage;
import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.impl.ApplicationLoader;
import ca.uhn.hl7v2.protocol.impl.ApplicationRouterImpl;
import ca.uhn.hl7v2.protocol.impl.DualTransportConnector;
import ca.uhn.hl7v2.protocol.impl.MLLPTransport;
import ca.uhn.hl7v2.protocol.impl.NullSafeStorage;
import ca.uhn.hl7v2.protocol.impl.ProcessorContextImpl;
import ca.uhn.hl7v2.protocol.impl.ProcessorImpl;
import ca.uhn.hl7v2.protocol.impl.ServerSocketStreamSource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7Server {
    private static final Logger log = LoggerFactory.getLogger(HL7Server.class);
    private final ServerSocket myServerSocket;
    private ServerSocket myServerSocket2;
    private final ApplicationRouter myRouter;
    private final SafeStorage myStorage;
    private boolean myIsRunning = false;
    private List<Processor> myProcessors;

    public HL7Server(ServerSocket theServerSocket, ApplicationRouter theRouter, SafeStorage theStorage) {
        this.myServerSocket = theServerSocket;
        this.myRouter = theRouter;
        this.myStorage = theStorage;
        this.initProcessorList();
    }

    public HL7Server(ServerSocket theLocallyDriven, ServerSocket theRemotelyDriven, ApplicationRouter theRouter, SafeStorage theStorage) {
        this.myServerSocket = theLocallyDriven;
        this.myServerSocket2 = theRemotelyDriven;
        this.myRouter = theRouter;
        this.myStorage = theStorage;
        this.initProcessorList();
    }

    private void initProcessorList() {
        List<Processor> processors = this.myProcessors = new ArrayList<Processor>();
        Thread cleaner = new Thread(() -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            List list = processors;
            synchronized (list) {
                Iterator it = processors.iterator();
                while (it.hasNext()) {
                    Processor proc = (Processor)it.next();
                    if (proc.getContext().getLocallyDrivenTransportLayer().isConnected() && proc.getContext().getRemotelyDrivenTransportLayer().isConnected()) continue;
                    it.remove();
                }
            }
        });
        cleaner.start();
    }

    public Processor accept(String theAddress) throws TransportException {
        ProcessorContextImpl context;
        TransportLayer transport = HL7Server.getTransport(this.myServerSocket, theAddress);
        if (this.myServerSocket2 == null) {
            transport.connect();
            context = new ProcessorContextImpl(this.myRouter, transport, this.myStorage);
        } else {
            TransportLayer transport2 = HL7Server.getTransport(this.myServerSocket2, theAddress);
            DualTransportConnector connector = new DualTransportConnector(transport, transport2);
            connector.connect();
            context = new ProcessorContextImpl(this.myRouter, transport, transport2, this.myStorage);
        }
        return new ProcessorImpl(context, true);
    }

    private static TransportLayer getTransport(ServerSocket theServerSocket, String theAddress) throws TransportException {
        ServerSocketStreamSource ss = new ServerSocketStreamSource(theServerSocket, theAddress);
        return new MLLPTransport(ss);
    }

    public void start(String theAddress) {
        HL7Server server = this;
        Runnable acceptor = () -> {
            while (server.isRunning()) {
                try {
                    Processor p = server.accept(theAddress);
                    if (!this.myIsRunning) {
                        p.stop();
                        continue;
                    }
                    server.newProcessor(p);
                    Thread.sleep(1L);
                }
                catch (TransportException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        this.myIsRunning = true;
        Thread thd = new Thread(acceptor);
        thd.start();
    }

    private synchronized void newProcessor(Processor theProcessor) {
        this.myProcessors.add(theProcessor);
    }

    public synchronized void stop() {
        this.myIsRunning = false;
        for (Processor next : this.myProcessors) {
            next.stop();
        }
    }

    public boolean isRunning() {
        return this.myIsRunning;
    }

    public Processor[] getProcessors() {
        return this.myProcessors.toArray(new Processor[0]);
    }

    private static URL getURL(String theUrlSpec) throws MalformedURLException {
        URL url;
        if (theUrlSpec.startsWith("classpath:")) {
            StringTokenizer tok = new StringTokenizer(theUrlSpec, ":", false);
            tok.nextToken();
            String resource = tok.nextToken();
            url = Thread.currentThread().getContextClassLoader().getResource(resource);
        } else {
            url = new URL(theUrlSpec);
        }
        return url;
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 3) {
            System.out.println("Usage: HL7Server (shared_port | (locally_driven_port remotely_driven_port)) app_binding_URL");
            System.exit(1);
        }
        NullSafeStorage storage = new NullSafeStorage();
        ApplicationRouterImpl router = new ApplicationRouterImpl();
        try {
            String appURL;
            HL7Server server;
            if (args.length == 2) {
                int port = Integer.parseInt(args[0]);
                server = new HL7Server(new ServerSocket(port), router, storage);
                appURL = args[1];
            } else {
                int localPort = Integer.parseInt(args[0]);
                int remotePort = Integer.parseInt(args[1]);
                server = new HL7Server(new ServerSocket(localPort), new ServerSocket(remotePort), router, storage);
                appURL = args[2];
            }
            ApplicationLoader.loadApplications(router, HL7Server.getURL(appURL));
            server.start(null);
        }
        catch (NumberFormatException e) {
            System.out.println("Port arguments must be integers");
            System.exit(2);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(3);
        }
        catch (HL7Exception e) {
            e.printStackTrace();
            System.exit(4);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(5);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.exit(6);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.exit(7);
        }
    }
}

