/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.parser.DefaultEscaping;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.UnexpectedSegmentBehaviourEnum;
import ca.uhn.hl7v2.util.idgenerator.FileBasedHiLoGenerator;
import ca.uhn.hl7v2.util.idgenerator.IDGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ParserConfiguration {
    public static final UnexpectedSegmentBehaviourEnum DEFAULT_UNEXPECTED_SEGMENT_BEHAVIOUR = UnexpectedSegmentBehaviourEnum.ADD_INLINE;
    private boolean allowUnknownVersions;
    private boolean escapeSubcomponentDelimiterInPrimitive = false;
    private IDGenerator idGenerator = new FileBasedHiLoGenerator();
    private String myDefaultObx2Type;
    private boolean myEncodeEmptyMandatorySegments = true;
    private final Set<String> myForcedEncode = new HashSet<String>();
    private String myInvalidObx2Type;
    private UnexpectedSegmentBehaviourEnum myUnexpectedSegmentBehaviour;
    private boolean nonGreedyMode = false;
    private boolean prettyPrintWhenEncodingXml = true;
    private boolean validating = true;
    private Escaping escaping = new DefaultEscaping();
    private boolean xmlDisableWhitespaceTrimmingOnAllNodes = false;
    private Set<String> xmlDisableWhitespaceTrimmingOnNodeNames = Collections.emptySet();
    private String myInvalidMfe5Type;
    private String myDefaultMfe5Type;

    public void addForcedEncode(String theForcedEncode) {
        if (theForcedEncode == null) {
            throw new NullPointerException("forced encode may not be null");
        }
        int lastSlashIndex = theForcedEncode.lastIndexOf(47);
        if ((lastSlashIndex = Math.max(lastSlashIndex, 0)) == 0 ? !theForcedEncode.matches("[A-Z0-9]{3}(-[0-9]+){0,2}$") : lastSlashIndex == theForcedEncode.length() || !theForcedEncode.substring(lastSlashIndex + 1).matches("[A-Z0-9]{3}(-[0-9]+){0,2}$")) {
            throw new IllegalArgumentException("Definition must end with a segment name or field lookup, e.g. MSH or MSH-2");
        }
        this.myForcedEncode.add(theForcedEncode);
    }

    boolean determineForcedEncodeIncludesTerserPath(String theTerserPath) {
        for (String next : this.getForcedEncode()) {
            if (!next.startsWith(theTerserPath)) continue;
            return true;
        }
        return false;
    }

    int determineForcedFieldNumForTerserPath(String theCurrentTerserPath) {
        int forceUpToFieldNum = 0;
        for (String nextPath : this.getForcedEncode()) {
            if (!nextPath.startsWith(theCurrentTerserPath) || nextPath.length() <= theCurrentTerserPath.length()) continue;
            int endOfFieldDef = nextPath.indexOf(45, theCurrentTerserPath.length() + 1);
            if (endOfFieldDef == -1) {
                endOfFieldDef = nextPath.length();
            }
            String fieldNumString = nextPath.substring(theCurrentTerserPath.length() + 1, endOfFieldDef);
            forceUpToFieldNum = Math.max(forceUpToFieldNum, Integer.parseInt(fieldNumString));
        }
        return forceUpToFieldNum;
    }

    public String getDefaultObx2Type() {
        return this.myDefaultObx2Type;
    }

    public String getDefaultMfe5Type() {
        return this.myDefaultMfe5Type;
    }

    public Set<String> getForcedEncode() {
        return Collections.unmodifiableSet(this.myForcedEncode);
    }

    public IDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public String getInvalidObx2Type() {
        return this.myInvalidObx2Type;
    }

    public String getInvalidMfe5Type() {
        return this.myInvalidMfe5Type;
    }

    public UnexpectedSegmentBehaviourEnum getUnexpectedSegmentBehaviour() {
        if (this.myUnexpectedSegmentBehaviour == null) {
            this.myUnexpectedSegmentBehaviour = DEFAULT_UNEXPECTED_SEGMENT_BEHAVIOUR;
        }
        return this.myUnexpectedSegmentBehaviour;
    }

    public Set<String> getXmlDisableWhitespaceTrimmingOnNodeNames() {
        return this.xmlDisableWhitespaceTrimmingOnNodeNames;
    }

    public boolean isAllowUnknownVersions() {
        return this.allowUnknownVersions;
    }

    public boolean isEncodeEmptyMandatorySegments() {
        return this.myEncodeEmptyMandatorySegments;
    }

    public boolean isEscapeSubcomponentDelimiterInPrimitive() {
        return this.escapeSubcomponentDelimiterInPrimitive;
    }

    public boolean isNonGreedyMode() {
        return this.nonGreedyMode;
    }

    public boolean isPrettyPrintWhenEncodingXml() {
        return this.prettyPrintWhenEncodingXml;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public boolean isXmlDisableWhitespaceTrimmingOnAllNodes() {
        return this.xmlDisableWhitespaceTrimmingOnAllNodes;
    }

    public void removeForcedEncode(String theForcedEncode) {
        if (theForcedEncode == null) {
            throw new NullPointerException("forced encode may not be null");
        }
        this.myForcedEncode.remove(theForcedEncode);
    }

    public void setAllowUnknownVersions(boolean theAllowUnknownVersions) {
        this.allowUnknownVersions = theAllowUnknownVersions;
    }

    public void setDefaultObx2Type(String theDefaultObx2Type) {
        this.myDefaultObx2Type = theDefaultObx2Type;
    }

    public void setDefaultMfe5Type(String theDefaultMfe5Type) {
        this.myDefaultMfe5Type = theDefaultMfe5Type;
    }

    public void setEncodeEmptyMandatoryFirstSegments(boolean theEncodeEmptyMandatorySegments) {
        this.myEncodeEmptyMandatorySegments = theEncodeEmptyMandatorySegments;
    }

    public void setEscapeSubcomponentDelimiterInPrimitive(boolean escapeSubcomponentDelimiterInPrimitive) {
        this.escapeSubcomponentDelimiterInPrimitive = escapeSubcomponentDelimiterInPrimitive;
    }

    public void setIdGenerator(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void setInvalidObx2Type(String theInvalidObx2Type) {
        this.myInvalidObx2Type = theInvalidObx2Type;
    }

    public void setInvalidMfe5Type(String theInvalidMfe5Type) {
        this.myInvalidMfe5Type = theInvalidMfe5Type;
    }

    public void setNonGreedyMode(boolean theNonGreedyMode) {
        this.nonGreedyMode = theNonGreedyMode;
    }

    public void setPrettyPrintWhenEncodingXml(boolean thePrettyPrintWhenEncodingXml) {
        this.prettyPrintWhenEncodingXml = thePrettyPrintWhenEncodingXml;
    }

    public void setUnexpectedSegmentBehaviour(UnexpectedSegmentBehaviourEnum theUnexpectedSegmentBehaviour) {
        if (theUnexpectedSegmentBehaviour == null) {
            throw new NullPointerException("UnexpectedSegmentBehaviour can not be null");
        }
        this.myUnexpectedSegmentBehaviour = theUnexpectedSegmentBehaviour;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public Escaping getEscaping() {
        return this.escaping;
    }

    public void setEscaping(Escaping escaping) {
        if (escaping == null) {
            throw new NullPointerException("Escaping can not be null");
        }
        this.escaping = escaping;
    }

    public void setXmlDisableWhitespaceTrimmingOnAllNodes(boolean theXmlDisableWhitespaceTrimmingOnAllNodes) {
        this.xmlDisableWhitespaceTrimmingOnAllNodes = theXmlDisableWhitespaceTrimmingOnAllNodes;
    }

    public void setXmlDisableWhitespaceTrimmingOnNodeNames(Set<String> theXmlDisableWhitespaceTrimmingOnNodeNames) {
        this.xmlDisableWhitespaceTrimmingOnNodeNames = theXmlDisableWhitespaceTrimmingOnNodeNames == null ? Collections.emptySet() : theXmlDisableWhitespaceTrimmingOnNodeNames;
    }

    public void setXmlDisableWhitespaceTrimmingOnNodeNames(String ... theKeepAsOriginalNodes) {
        if (theKeepAsOriginalNodes == null) {
            this.setXmlDisableWhitespaceTrimmingOnNodeNames((Set<String>)null);
        } else {
            this.setXmlDisableWhitespaceTrimmingOnNodeNames(new HashSet<String>(Arrays.asList(theKeepAsOriginalNodes)));
        }
    }
}

