/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.parser.XMLParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;

public class GenericParser
extends Parser {
    private Parser primaryParser;
    private Parser secondaryParser;
    private final PipeParser pipeParser;
    private final XMLParser xmlParser;

    public GenericParser() {
        this(new DefaultHapiContext());
    }

    public GenericParser(HapiContext context) {
        super(context);
        this.pipeParser = new PipeParser(context);
        this.xmlParser = new DefaultXMLParser(context);
        this.setPipeParserAsPrimary();
    }

    public GenericParser(ModelClassFactory theFactory) {
        super(theFactory);
        this.pipeParser = new PipeParser(theFactory);
        this.xmlParser = new DefaultXMLParser(theFactory);
        this.setPipeParserAsPrimary();
    }

    public void setXMLParserAsPrimary() {
        this.primaryParser = this.xmlParser;
        this.secondaryParser = this.pipeParser;
    }

    public void setPipeParserAsPrimary() {
        this.primaryParser = this.pipeParser;
        this.secondaryParser = this.xmlParser;
    }

    public boolean isPipeParserPrimary() {
        return this.primaryParser == this.pipeParser;
    }

    @Override
    public void setValidationContext(ValidationContext theContext) {
        super.setValidationContext(theContext);
        if (this.xmlParser != null) {
            this.pipeParser.setValidationContext(theContext);
            this.xmlParser.setValidationContext(theContext);
        }
    }

    private Parser getAppropriateParser(String message) throws HL7Exception {
        String encoding = this.getEncoding(message);
        if ("VB".equalsIgnoreCase(encoding)) {
            return this.pipeParser;
        }
        if ("XML".equalsIgnoreCase(encoding)) {
            return this.xmlParser;
        }
        throw new HL7Exception("Can't find appropriate parser - encoding not recognized");
    }

    @Override
    protected String doEncode(Message source, String encoding) throws HL7Exception, EncodingNotSupportedException {
        String ret;
        if (encoding == null) {
            encoding = "";
        }
        if (encoding.equalsIgnoreCase("VB")) {
            ret = this.pipeParser.doEncode(source);
        } else if (encoding.equalsIgnoreCase("XML")) {
            ret = this.xmlParser.doEncode(source);
        } else {
            throw new EncodingNotSupportedException("The encoding " + encoding + " is not supported by " + this.getClass().getName());
        }
        return ret;
    }

    @Override
    public Segment getCriticalResponseData(String message) throws HL7Exception {
        return this.getAppropriateParser(message).getCriticalResponseData(message);
    }

    @Override
    public String getVersion(String message) throws HL7Exception {
        return this.getAppropriateParser(message).getVersion(message);
    }

    @Override
    public String getEncoding(String message) {
        String encoding = this.primaryParser.getEncoding(message);
        return encoding == null ? this.secondaryParser.getEncoding(message) : encoding;
    }

    @Override
    public String getAckID(String message) {
        try {
            return this.getAppropriateParser(message).getAckID(message);
        }
        catch (HL7Exception e) {
            return null;
        }
    }

    @Override
    public boolean supportsEncoding(String encoding) {
        return this.primaryParser.supportsEncoding(encoding) || this.secondaryParser.supportsEncoding(encoding);
    }

    @Override
    public String getDefaultEncoding() {
        return this.primaryParser.getDefaultEncoding();
    }

    @Override
    protected Message doParse(String message, String version) throws HL7Exception {
        return this.getAppropriateParser(message).doParse(message, version);
    }

    @Override
    public Message parse(String theMessage) throws HL7Exception {
        Message retVal = super.parse(theMessage);
        Parser parser = this.getAppropriateParser(theMessage);
        retVal.setParser(parser);
        return retVal;
    }

    @Override
    protected String doEncode(Message source) throws HL7Exception {
        return this.primaryParser.doEncode(source);
    }

    @Override
    public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
        return this.primaryParser.doEncode(structure, encodingCharacters);
    }

    @Override
    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        return this.primaryParser.doEncode(type, encodingCharacters);
    }

    @Override
    public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        this.primaryParser.parse(type, string, encodingCharacters);
    }

    @Override
    public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        this.primaryParser.parse(segment, string, encodingCharacters);
    }

    @Override
    public void parse(Message message, String string) throws HL7Exception {
        this.primaryParser.parse(message, string);
    }

    public static GenericParser getInstanceWithNoValidation() {
        return new GenericParser(new DefaultHapiContext(ValidationContextFactory.noValidation()));
    }

    @Override
    protected Message doParseForSpecificPackage(String theMessage, String theVersion, String thePackageName) throws HL7Exception {
        return this.primaryParser.doParseForSpecificPackage(theMessage, theVersion, thePackageName);
    }

    public static void main(String[] args) throws HL7Exception {
        String msgString = "MSH|^~\\&|RAMSOFT|SENDING FACILITY|RAMSOFT|RECEIVING FACILITY|20101223202939-0400||ADT^A08|101|P|2.3.1||||||||\rEVN|A08|20101223202939-0400||||\rPID||P12345^^^ISSUER|P12345^^^ISSUER||PATIENT^TEST^M^^^^||19741018|M|||10808 FOOTHILL BLVD^^RANCHO CUCAMONGA^CA^91730^US||(909)481-5872^^^sales@ramsoft.com|(909)481-5800x1||M||12345|286-50-9510|||\rPV1||O||||||||||||||||||||||||||||||||||||||||||||||||||\rAL1|1||^PORK^|\rAL1|2||^PENICILLIN^|";
        GenericParser parser = new GenericParser();
        parser.setValidationContext(ValidationContextFactory.noValidation());
        Message msg = parser.parse(msgString);
        System.out.println(msg.getClass().getName());
    }
}

