/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MllpDecoderState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MllpDecoder {
    protected final Charset charset;
    private static final Logger ourLog = LoggerFactory.getLogger(MllpDecoder.class);

    MllpDecoder(Charset charset) {
        this.charset = charset;
    }

    public String getMessage(InputStream in) throws IOException, LLPException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (MllpDecoderState state = MllpDecoderState.START; state != MllpDecoderState.END; state = state.read(in, out)) {
            }
        }
        catch (SocketTimeoutException e) {
            if (out.size() == 0) {
                ourLog.debug("Got SocketTimeoutException while waiting for data");
            } else {
                ourLog.warn("Got SocketTimeoutException while waiting for data, discarding {} bytes", (Object)out.size());
            }
            return null;
        }
        return out.size() > 0 ? this.toString(out.toByteArray()) : null;
    }

    protected String toString(byte[] data) {
        return MllpDecoder.asString(data, this.charset);
    }

    protected static String asString(byte[] data, Charset charset) {
        try {
            return new String(data, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

