/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.util.Pair;
import ca.uhn.hl7v2.util.XMLUtils;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EncodedMessageComparator {
    static final GenericParser parser = new GenericParser();

    public static String standardize(String message) throws SAXException {
        String result = null;
        String encoding = parser.getEncoding(message);
        result = encoding.equals("XML") ? EncodedMessageComparator.standardizeXML(message) : EncodedMessageComparator.standardizeER7(message);
        return result;
    }

    public static String standardizeER7(String message) {
        char fieldDelimChar = message.charAt(3);
        String fieldDelim = String.valueOf(fieldDelimChar);
        if (!Character.isLetterOrDigit(fieldDelimChar)) {
            fieldDelim = "\\" + fieldDelimChar;
        }
        char compSepChar = message.charAt(4);
        String compSep = String.valueOf(compSepChar);
        if (!Character.isLetterOrDigit(compSepChar)) {
            compSep = "\\" + compSepChar;
        }
        char repSepChar = message.charAt(5);
        String repSep = String.valueOf(repSepChar);
        if (!Character.isLetterOrDigit(repSepChar)) {
            repSep = "\\" + repSepChar;
        }
        char subSepChar = message.charAt(7);
        String subSep = String.valueOf(subSepChar);
        if (!Character.isLetterOrDigit(subSepChar)) {
            subSep = "\\" + subSepChar;
        }
        Pattern endSegment = Pattern.compile("[" + fieldDelim + compSep + repSep + subSep + "]*[\n\r]+");
        message = endSegment.matcher(message).replaceAll("\r");
        Pattern endField = Pattern.compile("[" + repSep + compSep + subSep + "]*" + fieldDelim);
        message = endField.matcher(message).replaceAll(String.valueOf(fieldDelim));
        Pattern endComp = Pattern.compile("[" + subSep + "]*" + compSep);
        message = endComp.matcher(message).replaceAll(String.valueOf(compSep));
        message = message.substring(0, 7) + subSepChar + message.substring(7);
        return message;
    }

    public static String standardizeXML(String message) throws SAXException {
        try {
            Document doc = XMLUtils.parse(message);
            EncodedMessageComparator.clean(doc.getDocumentElement());
            return XMLUtils.serialize(doc, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while standardizing XML ", e);
        }
    }

    private static void clean(Element elem) {
        int i;
        NodeList children = elem.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node child = children.item(i2);
            if (child.getNodeType() == 7 || child.getNodeType() == 8) {
                elem.removeChild(child);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            EncodedMessageComparator.clean((Element)child);
        }
        NamedNodeMap attributes = elem.getAttributes();
        String[] names = new String[attributes.getLength()];
        for (i = 0; i < names.length; ++i) {
            names[i] = attributes.item(i).getNodeName();
        }
        for (i = 0; i < names.length; ++i) {
            attributes.removeNamedItem(names[i]);
        }
    }

    public static boolean equivalent(String message1, String message2) throws HL7Exception {
        Pair<String> messages = EncodedMessageComparator.standardize(message1, message2);
        return messages.getValue1().equals(messages.getValue2());
    }

    static Pair<String> standardize(String message1, String message2) throws HL7Exception {
        String std2;
        String std1;
        String encoding2;
        String encoding1 = parser.getEncoding(message1);
        if (!encoding1.equals(encoding2 = parser.getEncoding(message2))) {
            if (encoding1.equals("XML")) {
                message1 = EncodedMessageComparator.safeER7Conversion(message1);
            } else {
                message2 = EncodedMessageComparator.safeER7Conversion(message2);
            }
        }
        try {
            std1 = EncodedMessageComparator.standardize(message1);
            std2 = EncodedMessageComparator.standardize(message2);
        }
        catch (SAXException e) {
            throw new HL7Exception("Equivalence check failed due to SAXException: " + e.getMessage());
        }
        return new Pair<String>(std1, std2);
    }

    static String safeER7Conversion(String xmlMessage) throws HL7Exception {
        Message m = parser.parse(xmlMessage);
        String check = parser.encode(m, "XML");
        if (!EncodedMessageComparator.equivalent(xmlMessage, check)) {
            throw new HL7Exception("Parsed and encoded message not equivalent to original (possibilities: invalid message, bug in parser)");
        }
        return parser.encode(m, "VB");
    }
}

