/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MinLLPReader;
import ca.uhn.hl7v2.llp.MinLLPWriter;
import ca.uhn.hl7v2.protocol.StreamSource;
import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AbstractTransport;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MLLPTransport
extends AbstractTransport
implements TransportLayer {
    private MinLLPReader myReader;
    private MinLLPWriter myWriter;
    private StreamSource myStreamSource;
    private Properties myCharsetMappings;

    public MLLPTransport(StreamSource theStreamSource) throws TransportException {
        this.myStreamSource = theStreamSource;
        this.myCharsetMappings = MLLPTransport.loadCharsetMappings();
    }

    private static Properties loadCharsetMappings() throws TransportException {
        Properties mappings = new Properties();
        String resource = "ca/uhn/hl7v2/protocol/impl/charset_map.properties";
        InputStream in = MLLPTransport.class.getClassLoader().getResourceAsStream(resource);
        try {
            mappings.load(in);
        }
        catch (IOException e) {
            throw new TransportException("Can't load character set mappings from " + resource, e);
        }
        return mappings;
    }

    @Override
    public void doSend(Transportable theMessage) throws TransportException {
        try {
            String charset = (String)theMessage.getMetadata().get("MSH-18");
            if (charset != null) {
                charset = this.myCharsetMappings.getProperty(charset, charset);
                this.myWriter.writeMessage(theMessage.getMessage(), charset);
            } else {
                this.myWriter.writeMessage(theMessage.getMessage());
            }
        }
        catch (LLPException e) {
            throw new TransportException(e);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public Transportable doReceive() throws TransportException {
        TransportableImpl result = null;
        try {
            String message = this.myReader.getMessage();
            if (message != null) {
                result = new TransportableImpl(message);
            }
        }
        catch (LLPException e) {
            throw new TransportException(e);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        return result;
    }

    @Override
    public void doConnect() throws TransportException {
        this.myStreamSource.connect();
        try {
            this.myReader = new MinLLPReader(this.myStreamSource.getInboundStream());
            this.myWriter = new MinLLPWriter(this.myStreamSource.getOutboundStream());
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    @Override
    public void doDisconnect() throws TransportException {
        try {
            if (this.myReader != null) {
                this.myReader.close();
            }
            if (this.myWriter != null) {
                this.myWriter.close();
            }
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
        finally {
            this.myReader = null;
            this.myWriter = null;
        }
        this.myStreamSource.disconnect();
    }
}

