/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingDetector;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.FixFieldDataType;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.util.XMLUtils;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLParser
extends Parser {
    private static final String ESCAPE_ATTRNAME = "V";
    private static final String ESCAPE_NODENAME = "escape";
    private static final Logger log = LoggerFactory.getLogger(XMLParser.class);
    protected static final String NS = "urn:hl7-org:v2xml";
    private static final Pattern NS_PATTERN = Pattern.compile("xmlns(.*)=\"urn:hl7-org:v2xml\"");
    private String textEncoding;

    public XMLParser() {
    }

    public XMLParser(HapiContext context) {
        super(context);
    }

    public XMLParser(ModelClassFactory theFactory) {
        super(theFactory);
    }

    @Override
    public String getEncoding(String message) {
        return EncodingDetector.isXmlEncoded(message) ? this.getDefaultEncoding() : null;
    }

    @Override
    public String getDefaultEncoding() {
        return "XML";
    }

    @Deprecated
    public void setKeepAsOriginalNodes(String[] keepAsOriginalNodes) {
        this.getParserConfiguration().setXmlDisableWhitespaceTrimmingOnNodeNames(keepAsOriginalNodes);
    }

    @Deprecated
    public String[] getKeepAsOriginalNodes() {
        return this.getParserConfiguration().getXmlDisableWhitespaceTrimmingOnNodeNames().toArray(new String[this.getParserConfiguration().getXmlDisableWhitespaceTrimmingOnNodeNames().size()]);
    }

    public abstract Message parseDocument(Document var1, String var2) throws HL7Exception;

    @Override
    protected Message doParse(String message, String version) throws HL7Exception {
        Document doc = this.parseStringIntoDocument(message);
        Message m = this.parseDocument(doc, version);
        return m;
    }

    protected synchronized Document parseStringIntoDocument(String message) throws HL7Exception {
        try {
            return XMLUtils.parse(message);
        }
        catch (Exception e) {
            throw new HL7Exception("Exception parsing XML", e);
        }
    }

    @Override
    protected String doEncode(Message source, String encoding) throws HL7Exception {
        if (!encoding.equals("XML")) {
            throw new EncodingNotSupportedException("XMLParser supports only XML encoding");
        }
        return this.encode(source);
    }

    @Override
    protected String doEncode(Message source) throws HL7Exception {
        if (source instanceof GenericMessage) {
            throw new HL7Exception("Can't XML-encode a GenericMessage.  Message must have a recognized structure.");
        }
        Document doc = this.encodeDocument(source);
        try {
            return XMLUtils.serialize(doc, this.getParserConfiguration().isPrettyPrintWhenEncodingXml());
        }
        catch (Exception e) {
            throw new HL7Exception("Exception serializing XML document to string", e);
        }
    }

    public abstract Document encodeDocument(Message var1) throws HL7Exception;

    protected void assertNamespaceURI(String ns) throws HL7Exception {
        if (!NS.equals(ns)) {
            throw new HL7Exception("Namespace URI must be urn:hl7-org:v2xml");
        }
    }

    public void parse(Segment segmentObject, Element segmentElement) throws HL7Exception {
        HashSet<String> done = new HashSet<String>();
        NodeList all = segmentElement.getChildNodes();
        for (int i = 0; i < all.getLength(); ++i) {
            String elementName = all.item(i).getNodeName();
            if (all.item(i).getNodeType() != 1 || done.contains(elementName)) continue;
            this.assertNamespaceURI(all.item(i).getNamespaceURI());
            done.add(elementName);
            int index = elementName.indexOf(46);
            if (index >= 0 && elementName.length() > index) {
                String fieldNumString = elementName.substring(index + 1);
                int fieldNum = Integer.parseInt(fieldNumString);
                this.parseReps(segmentObject, segmentElement, elementName, fieldNum);
                continue;
            }
            log.debug("Child of segment {} doesn't look like a field {}", (Object)segmentObject.getName(), (Object)elementName);
        }
        if (segmentObject.getClass().getName().contains("OBX")) {
            FixFieldDataType.fixOBX5(segmentObject, this.getFactory(), this.getHapiContext().getParserConfiguration());
        }
        if (segmentObject.getClass().getName().contains("MFE") && Version.versionOf(segmentObject.getMessage().getVersion()).isGreaterThan(Version.V23)) {
            FixFieldDataType.fixMFE4(segmentObject, this.getFactory(), this.getHapiContext().getParserConfiguration());
        }
    }

    private void parseReps(Segment segmentObject, Element segmentElement, String fieldName, int fieldNum) throws HL7Exception {
        NodeList reps = segmentElement.getElementsByTagName(fieldName);
        for (int i = 0; i < reps.getLength(); ++i) {
            this.parse(segmentObject.getField(fieldNum, i), (Element)reps.item(i));
        }
    }

    public boolean encode(Segment segmentObject, Element segmentElement) throws HL7Exception {
        boolean hasValue = false;
        int n = segmentObject.numFields();
        for (int i = 1; i <= n; ++i) {
            Type[] reps;
            String name = this.makeElementName(segmentObject, i);
            for (Type rep : reps = segmentObject.getField(i)) {
                Element newNode = segmentElement.getOwnerDocument().createElement(name);
                boolean componentHasValue = this.encode(rep, newNode);
                if (!componentHasValue) continue;
                try {
                    segmentElement.appendChild(newNode);
                }
                catch (DOMException e) {
                    throw new HL7Exception("DOMException encoding Segment: ", e);
                }
                hasValue = true;
            }
        }
        return hasValue;
    }

    public void parse(Type datatypeObject, Element datatypeElement) throws HL7Exception {
        if (datatypeObject instanceof Varies) {
            this.parseVaries((Varies)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Primitive) {
            this.parsePrimitive((Primitive)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Composite) {
            this.parseComposite((Composite)datatypeObject, datatypeElement);
        }
    }

    private void parseVaries(Varies datatypeObject, Element datatypeElement) throws HL7Exception {
        if (!this.hasChildElement(datatypeElement)) {
            datatypeObject.setData(new GenericPrimitive(datatypeObject.getMessage()));
        } else {
            datatypeObject.setData(new GenericComposite(datatypeObject.getMessage()));
        }
        this.parse(datatypeObject.getData(), datatypeElement);
    }

    private boolean hasChildElement(Element e) {
        NodeList children = e.getChildNodes();
        boolean hasElement = false;
        for (int c = 0; c < children.getLength() && !hasElement; ++c) {
            if (children.item(c).getNodeType() != 1 || ESCAPE_NODENAME.equals(children.item(c).getNodeName())) continue;
            hasElement = true;
        }
        return hasElement;
    }

    private void parsePrimitive(Primitive datatypeObject, Element datatypeElement) throws HL7Exception {
        NodeList children = datatypeElement.getChildNodes();
        StringBuilder builder = new StringBuilder();
        for (int c = 0; c < children.getLength(); ++c) {
            Node child = children.item(c);
            try {
                if (child.getNodeType() == 3) {
                    String value = child.getNodeValue();
                    if (value == null || value.length() <= 0) continue;
                    if (this.keepAsOriginal(child.getParentNode())) {
                        builder.append(value);
                        continue;
                    }
                    builder.append(this.removeWhitespace(value));
                    continue;
                }
                if (child.getNodeType() != 1 || !ESCAPE_NODENAME.equals(child.getLocalName())) continue;
                this.assertNamespaceURI(child.getNamespaceURI());
                EncodingCharacters ec = EncodingCharacters.getInstance(datatypeObject.getMessage());
                Element elem = (Element)child;
                String attr = elem.getAttribute(ESCAPE_ATTRNAME).trim();
                if (attr.length() <= 0) continue;
                builder.append(ec.getEscapeCharacter()).append(attr).append(ec.getEscapeCharacter());
                continue;
            }
            catch (Exception e) {
                log.error("Error parsing primitive value from TEXT_NODE", (Throwable)e);
            }
        }
        datatypeObject.setValue(builder.toString());
    }

    protected boolean keepAsOriginal(Node node) {
        if (this.getParserConfiguration().isXmlDisableWhitespaceTrimmingOnAllNodes()) {
            return true;
        }
        return node.getNodeName() != null && this.getParserConfiguration().getXmlDisableWhitespaceTrimmingOnNodeNames().contains(node.getNodeName());
    }

    protected String removeWhitespace(String s) {
        s = s.replace('\r', ' ');
        s = s.replace('\n', ' ');
        s = s.replace('\t', ' ');
        boolean repeatedSpacesExist = true;
        while (repeatedSpacesExist) {
            int loc = s.indexOf("  ");
            if (loc < 0) {
                repeatedSpacesExist = false;
                continue;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(s.substring(0, loc));
            buf.append(" ");
            buf.append(s.substring(loc + 2));
            s = buf.toString();
        }
        return s.trim();
    }

    private void parseComposite(Composite datatypeObject, Element datatypeElement) throws HL7Exception {
        if (datatypeObject instanceof GenericComposite) {
            NodeList children = datatypeElement.getChildNodes();
            int compNum = 0;
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                Element nextElement = (Element)children.item(i);
                this.assertNamespaceURI(nextElement.getNamespaceURI());
                String localName = nextElement.getLocalName();
                int dotIndex = localName.indexOf(".");
                if (dotIndex > -1) {
                    compNum = Integer.parseInt(localName.substring(dotIndex + 1)) - 1;
                } else {
                    log.debug("Datatype element {} doesn't have a valid numbered name, usgin default index of {}", (Object)datatypeElement.getLocalName(), (Object)compNum);
                }
                Type nextComponent = datatypeObject.getComponent(compNum);
                this.parse(nextComponent, nextElement);
                ++compNum;
            }
        } else {
            boolean foundExtraComponent;
            Type[] children = datatypeObject.getComponents();
            for (int i = 0; i < children.length; ++i) {
                NodeList matchingElements = datatypeElement.getElementsByTagNameNS(NS, this.makeElementName(datatypeObject, i + 1));
                if (matchingElements.getLength() <= 0) continue;
                this.parse(children[i], (Element)matchingElements.item(0));
            }
            int nextExtraCmpIndex = 0;
            do {
                foundExtraComponent = false;
                NodeList matchingElements = datatypeElement.getElementsByTagNameNS(NS, this.makeElementName(datatypeObject, children.length + nextExtraCmpIndex + 1));
                if (matchingElements.getLength() > 0) {
                    this.parse(datatypeObject.getExtraComponents().getComponent(nextExtraCmpIndex), (Element)matchingElements.item(0));
                    foundExtraComponent = true;
                }
                ++nextExtraCmpIndex;
            } while (foundExtraComponent);
        }
    }

    private String makeElementName(Segment s, int child) {
        return s.getName() + "." + child;
    }

    private String makeElementName(Composite composite, int child) {
        return composite.getName() + "." + child;
    }

    private boolean encode(Type datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasData = false;
        if (datatypeObject instanceof Varies) {
            hasData = this.encodeVaries((Varies)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Primitive) {
            hasData = this.encodePrimitive((Primitive)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Composite) {
            hasData = this.encodeComposite((Composite)datatypeObject, datatypeElement);
        }
        return hasData;
    }

    private boolean encodeVaries(Varies datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasData = false;
        if (datatypeObject.getData() != null) {
            hasData = this.encode(datatypeObject.getData(), datatypeElement);
        }
        return hasData;
    }

    private boolean encodePrimitive(Primitive datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasValue;
        String value = datatypeObject.getValue();
        boolean bl = hasValue = value != null && value.length() > 0;
        if (hasValue) {
            try {
                int pos;
                EncodingCharacters ec = EncodingCharacters.getInstance(datatypeObject.getMessage());
                char esc = ec.getEscapeCharacter();
                int oldpos = 0;
                boolean escaping = false;
                while ((pos = value.indexOf(esc, oldpos)) >= 0) {
                    String v = value.substring(oldpos, pos);
                    if (!escaping) {
                        if (v.length() > 0) {
                            datatypeElement.appendChild(datatypeElement.getOwnerDocument().createTextNode(v));
                        }
                        escaping = true;
                    } else if (v.startsWith(".") || "H".equals(v) || "N".equals(v)) {
                        Element escape = datatypeElement.getOwnerDocument().createElement(ESCAPE_NODENAME);
                        escape.setAttribute(ESCAPE_ATTRNAME, v);
                        datatypeElement.appendChild(escape);
                        escaping = false;
                    } else {
                        datatypeElement.appendChild(datatypeElement.getOwnerDocument().createTextNode(esc + v));
                    }
                    oldpos = pos + 1;
                }
                if (oldpos <= value.length()) {
                    StringBuilder sb = new StringBuilder();
                    if (escaping) {
                        sb.append(esc);
                    }
                    sb.append(value.substring(oldpos));
                    datatypeElement.appendChild(datatypeElement.getOwnerDocument().createTextNode(sb.toString()));
                }
            }
            catch (Exception e) {
                throw new DataTypeException("Exception encoding Primitive: ", e);
            }
        }
        return hasValue;
    }

    private boolean encodeComposite(Composite datatypeObject, Element datatypeElement) throws DataTypeException {
        Type[] components = datatypeObject.getComponents();
        boolean hasValue = false;
        for (int i = 0; i < components.length; ++i) {
            String name = this.makeElementName(datatypeObject, i + 1);
            Element newNode = datatypeElement.getOwnerDocument().createElement(name);
            boolean componentHasValue = this.encode(components[i], newNode);
            if (!componentHasValue) continue;
            try {
                datatypeElement.appendChild(newNode);
            }
            catch (DOMException e) {
                throw new DataTypeException("DOMException encoding Composite: ", e);
            }
            hasValue = true;
        }
        return hasValue;
    }

    @Override
    public Segment getCriticalResponseData(String message) throws HL7Exception {
        String version = this.getVersion(message);
        Segment criticalData = Parser.makeControlMSH(version, this.getFactory());
        Terser.set(criticalData, 1, 0, 1, 1, XMLParser.parseLeaf(message, "MSH.1", 0));
        Terser.set(criticalData, 2, 0, 1, 1, XMLParser.parseLeaf(message, "MSH.2", 0));
        Terser.set(criticalData, 10, 0, 1, 1, XMLParser.parseLeaf(message, "MSH.10", 0));
        String procID = XMLParser.parseLeaf(message, "MSH.11", 0);
        if (procID == null || procID.length() == 0) {
            procID = XMLParser.parseLeaf(message, "PT.1", message.indexOf("MSH.11"));
        }
        Terser.set(criticalData, 11, 0, 1, 1, procID);
        return criticalData;
    }

    @Override
    public String getAckID(String message) {
        String ackID = null;
        try {
            ackID = XMLParser.parseLeaf(message, "msa.2", 0).trim();
        }
        catch (HL7Exception hL7Exception) {
            // empty catch block
        }
        return ackID;
    }

    @Override
    public String getVersion(String message) throws HL7Exception {
        String version = XMLParser.parseLeaf(message, "MSH.12", 0);
        if (version == null || version.trim().length() == 0) {
            version = XMLParser.parseLeaf(message, "VID.1", message.indexOf("MSH.12"));
        }
        return version;
    }

    protected static String parseLeaf(String message, String tagName, int startAt) throws HL7Exception {
        int tagStart;
        String ns;
        String prefix = "";
        Matcher m = NS_PATTERN.matcher(message);
        if (m.find() && (ns = m.group(1)) != null && ns.length() > 0) {
            prefix = ns.substring(1) + ":";
        }
        if ((tagStart = message.indexOf("<" + prefix + tagName, startAt)) < 0) {
            tagStart = message.indexOf("<" + prefix + tagName.toUpperCase(), startAt);
        }
        int valStart = message.indexOf(">", tagStart) + 1;
        int valEnd = message.indexOf("<", valStart);
        if (tagStart < 0 || valEnd < valStart) {
            throw new HL7Exception("Couldn't find " + tagName + " in message beginning: " + message.substring(0, Math.min(150, message.length())), ErrorCode.REQUIRED_FIELD_MISSING);
        }
        String value = message.substring(valStart, valEnd);
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&apos;", "'");
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        return value;
    }

    @Override
    public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Message doParseForSpecificPackage(String theMessage, String theVersion, String thePackageName) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }
}

