/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;

public class EncodingCharacters
implements Cloneable {
    private char fieldSep;
    private char[] encChars;

    public EncodingCharacters(char fieldSeparator, String encodingCharacters) {
        this.fieldSep = fieldSeparator;
        this.encChars = new char[5];
        if (encodingCharacters == null) {
            this.setComponentSeparator('^');
            this.setRepetitionSeparator('~');
            this.setEscapeCharacter('\\');
            this.setSubcomponentSeparator('&');
            this.setTruncationCharacter('#');
        } else {
            char extraChar;
            encodingCharacters.getChars(0, 4, this.encChars, 0);
            if (encodingCharacters.length() > 4 && (extraChar = encodingCharacters.charAt(4)) != fieldSeparator) {
                this.setTruncationCharacter(extraChar);
            }
        }
    }

    public static EncodingCharacters getInstance(Message message) throws HL7Exception {
        String encodingCharactersValue = message.getEncodingCharactersValue();
        if (encodingCharactersValue == null || encodingCharactersValue.length() == 0) {
            throw new HL7Exception("encoding characters not populated");
        }
        Character fieldSeparatorValue = message.getFieldSeparatorValue();
        if (fieldSeparatorValue == null) {
            throw new HL7Exception("Field separator not populated");
        }
        return new EncodingCharacters(fieldSeparatorValue.charValue(), encodingCharactersValue);
    }

    public EncodingCharacters(char fieldSeparator, char componentSeparator, char repetitionSeparator, char escapeCharacter, char subcomponentSeparator) {
        this(fieldSeparator, String.valueOf(componentSeparator) + repetitionSeparator + escapeCharacter + subcomponentSeparator);
    }

    public EncodingCharacters(char fieldSeparator, char componentSeparator, char repetitionSeparator, char escapeCharacter, char subcomponentSeparator, char truncationCharacter) {
        this(fieldSeparator, String.valueOf(componentSeparator) + repetitionSeparator + escapeCharacter + subcomponentSeparator + truncationCharacter);
    }

    public EncodingCharacters(EncodingCharacters other) {
        this.fieldSep = other.getFieldSeparator();
        this.encChars = new char[5];
        this.setComponentSeparator(other.getComponentSeparator());
        this.setRepetitionSeparator(other.getRepetitionSeparator());
        this.setEscapeCharacter(other.getEscapeCharacter());
        this.setSubcomponentSeparator(other.getSubcomponentSeparator());
        this.setTruncationCharacter(other.getTruncationCharacter());
    }

    public char getFieldSeparator() {
        return this.fieldSep;
    }

    public char getComponentSeparator() {
        return this.encChars[0];
    }

    public char getRepetitionSeparator() {
        return this.encChars[1];
    }

    public char getEscapeCharacter() {
        return this.encChars[2];
    }

    public char getSubcomponentSeparator() {
        return this.encChars[3];
    }

    public char getTruncationCharacter() {
        return this.encChars[4];
    }

    public String toString() {
        return String.valueOf(this.encChars);
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        return new EncodingCharacters(this);
    }

    public void setFieldSeparator(char newFieldSep) {
        this.fieldSep = newFieldSep;
    }

    public void setComponentSeparator(char newComponentSep) {
        this.encChars[0] = newComponentSep;
    }

    public void setRepetitionSeparator(char newRepetitionSep) {
        this.encChars[1] = newRepetitionSep;
    }

    public void setEscapeCharacter(char newEscapeChar) {
        this.encChars[2] = newEscapeChar;
    }

    public void setSubcomponentSeparator(char newSubcomponentSep) {
        this.encChars[3] = newSubcomponentSep;
    }

    public void setTruncationCharacter(char newTruncationChar) {
        this.encChars[4] = newTruncationChar;
    }

    public boolean equals(Object o) {
        if (o instanceof EncodingCharacters) {
            EncodingCharacters other = (EncodingCharacters)o;
            return this.getFieldSeparator() == other.getFieldSeparator() && this.getComponentSeparator() == other.getComponentSeparator() && this.getEscapeCharacter() == other.getEscapeCharacter() && this.getRepetitionSeparator() == other.getRepetitionSeparator() && this.getSubcomponentSeparator() == other.getSubcomponentSeparator() && this.getTruncationCharacter() == other.getTruncationCharacter();
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.getComponentSeparator() * this.getEscapeCharacter() * this.getFieldSeparator() * this.getRepetitionSeparator() * this.getSubcomponentSeparator() * this.getTruncationCharacter();
    }

    public static EncodingCharacters defaultInstance() {
        return new EncodingCharacters('|', null);
    }
}

