/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.store;

import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.store.AbstractCodeStore;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ProfileCodeStore
extends AbstractCodeStore {
    private Map<String, List<String>> codes = new HashMap<String, List<String>>();

    public ProfileCodeStore(String uri) throws ProfileException, IOException {
        try {
            if (uri == null) {
                throw new ProfileException("The input url parameter cannot be null");
            }
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(new ProfileCodeStoreHandler());
            reader.parse(uri);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProfileException(e.toString(), e);
        }
    }

    public ProfileCodeStore(URL url) throws ProfileException, IOException {
        this(url.toExternalForm());
    }

    @Override
    public String[] getValidCodes(String codeSystem) throws ProfileException {
        List<String> result = this.getCodeTable(codeSystem);
        if (result == null) {
            throw new ProfileException("Unknown code system: " + codeSystem);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean knowsCodes(String codeSystem) {
        try {
            return this.getCodeTable(codeSystem) != null;
        }
        catch (ProfileException e) {
            return false;
        }
    }

    private List<String> getCodeTable(String codeSystem) throws ProfileException {
        if (codeSystem == null) {
            throw new ProfileException("The input codeSystem parameter cannot be null");
        }
        if (codeSystem.length() < 4) {
            throw new ProfileException("The input codeSystem parameter cannot be less than 4 characters long");
        }
        String tableId = codeSystem.substring(codeSystem.length() - 4);
        return this.codes.get(tableId);
    }

    private class ProfileCodeStoreHandler
    extends DefaultHandler {
        private String currentTable;
        private static final String HL7_TABLE_QNAME = "hl7table";
        private static final String TABLE_ELEMENT_QNAME = "tableElement";

        private ProfileCodeStoreHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (HL7_TABLE_QNAME.equals(qName)) {
                this.currentTable = attributes.getValue("id");
                ProfileCodeStore.this.codes.put(this.currentTable, new ArrayList());
            } else if (TABLE_ELEMENT_QNAME.equals(qName)) {
                ((List)ProfileCodeStore.this.codes.get(this.currentTable)).add(attributes.getValue("code"));
            }
        }
    }
}

