/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.PrimitiveTypeRule;

public class TrimLeadingWhitespace
implements PrimitiveTypeRule {
    public String correct(String value) {
        String trmValue = null;
        if (value != null) {
            char[] stringChr = value.toCharArray();
            for (int i = 0; i < stringChr.length && trmValue == null; ++i) {
                if (Character.isWhitespace(stringChr[i])) continue;
                trmValue = String.valueOf(stringChr, i, stringChr.length - i);
            }
        }
        return trmValue;
    }

    public boolean test(String value) {
        return true;
    }

    public String getDescription() {
        return "Leading whitespace removed";
    }

    public String getSectionReference() {
        return null;
    }
}

