/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.IStructureDefinition;
import ca.uhn.hl7v2.parser.NonStandardStructureDefinition;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageIterator
implements Iterator<Structure> {
    private Message myMessage;
    private String myDirection;
    private boolean myNextIsSet;
    private boolean myHandleUnexpectedSegments;
    private List<Position> myCurrentDefinitionPath = new ArrayList<Position>();
    private static final HapiLog log = HapiLogFactory.getHapiLog(MessageIterator.class);

    public MessageIterator(Message start, IStructureDefinition startDefinition, String direction, boolean handleUnexpectedSegments) {
        this.myMessage = start;
        this.myDirection = direction;
        this.myHandleUnexpectedSegments = handleUnexpectedSegments;
        this.myCurrentDefinitionPath.add(new Position(startDefinition, 0));
    }

    private Position getCurrentPosition() {
        return this.getTail(this.myCurrentDefinitionPath);
    }

    private Position getTail(List<Position> theDefinitionPath) {
        return theDefinitionPath.get(theDefinitionPath.size() - 1);
    }

    private List<Position> popUntilMatchFound(List<Position> theDefinitionPath) {
        Position newCurrentPosition = this.getTail(theDefinitionPath = new ArrayList<Position>(theDefinitionPath.subList(0, theDefinitionPath.size() - 1)));
        IStructureDefinition newCurrentStructureDefinition = newCurrentPosition.getStructureDefinition();
        if (newCurrentStructureDefinition.getAllPossibleFirstChildren().contains(this.myDirection)) {
            return theDefinitionPath;
        }
        if (newCurrentStructureDefinition.isFinalChildOfParent()) {
            if (theDefinitionPath.size() > 1) {
                return this.popUntilMatchFound(theDefinitionPath);
            }
            if (log.isDebugEnabled()) {
                log.debug("Popped to root of message and did not find a match for " + this.myDirection);
            }
            return null;
        }
        return theDefinitionPath;
    }

    @Override
    public boolean hasNext() {
        log.debug("hasNext() for direction " + this.myDirection);
        if (this.myDirection == null) {
            throw new IllegalStateException("Direction not set");
        }
        while (!this.myNextIsSet) {
            IStructureDefinition structureDefinition;
            Position currentPosition = this.getCurrentPosition();
            if (log.isDebugEnabled()) {
                log.debug("hasNext() current position: " + currentPosition);
            }
            if ((structureDefinition = currentPosition.getStructureDefinition()).isSegment() && structureDefinition.getName().startsWith(this.myDirection) && (structureDefinition.isRepeating() || currentPosition.getRepNumber() == -1)) {
                this.myNextIsSet = true;
                currentPosition.incrementRep();
                continue;
            }
            if (structureDefinition.isSegment() && structureDefinition.getNextLeaf() == null && !structureDefinition.getNamesOfAllPossibleFollowingLeaves().contains(this.myDirection)) {
                if (!this.myHandleUnexpectedSegments) {
                    return false;
                }
                this.addNonStandardSegmentAtCurrentPosition();
                continue;
            }
            if (structureDefinition.hasChildren() && structureDefinition.getAllPossibleFirstChildren().contains(this.myDirection)) {
                currentPosition.incrementRep();
                this.myCurrentDefinitionPath.add(new Position(structureDefinition.getFirstChild(), -1));
                continue;
            }
            if (!structureDefinition.hasChildren() && !structureDefinition.getNamesOfAllPossibleFollowingLeaves().contains(this.myDirection)) {
                if (!this.myHandleUnexpectedSegments) {
                    return false;
                }
                this.addNonStandardSegmentAtCurrentPosition();
                continue;
            }
            if (structureDefinition.isFinalChildOfParent()) {
                List<Position> newDefinitionPath = this.popUntilMatchFound(this.myCurrentDefinitionPath);
                if (newDefinitionPath != null) {
                    this.myCurrentDefinitionPath = newDefinitionPath;
                    continue;
                }
                if (!this.myHandleUnexpectedSegments) {
                    return false;
                }
                this.addNonStandardSegmentAtCurrentPosition();
                continue;
            }
            currentPosition.setStructureDefinition(structureDefinition.getNextSibling());
            currentPosition.resetRepNumber();
        }
        return true;
    }

    private void addNonStandardSegmentAtCurrentPosition() throws Error {
        String newSegmentName;
        if (log.isDebugEnabled()) {
            log.debug("Creating non standard segment " + this.myDirection + " on group: " + this.getCurrentPosition().getStructureDefinition().getParent().getName());
        }
        ArrayList<Position> parentDefinitionPath = new ArrayList<Position>(this.myCurrentDefinitionPath.subList(0, this.myCurrentDefinitionPath.size() - 1));
        Group parentStructure = (Group)this.navigateToStructure(parentDefinitionPath);
        Position currentPosition = this.getCurrentPosition();
        String nameAsItAppearsInParent = currentPosition.getStructureDefinition().getNameAsItAppearsInParent();
        int index = Arrays.asList(parentStructure.getNames()).indexOf(nameAsItAppearsInParent) + 1;
        try {
            newSegmentName = parentStructure.addNonstandardSegment(this.myDirection, index);
        }
        catch (HL7Exception e) {
            throw new Error("Unable to add nonstandard segment " + this.myDirection + ": ", e);
        }
        IStructureDefinition previousSibling = this.getCurrentPosition().getStructureDefinition();
        IStructureDefinition parentStructureDefinition = ((Position)parentDefinitionPath.get(parentDefinitionPath.size() - 1)).getStructureDefinition();
        NonStandardStructureDefinition nextDefinition = new NonStandardStructureDefinition(parentStructureDefinition, previousSibling, newSegmentName, index);
        this.myCurrentDefinitionPath = parentDefinitionPath;
        this.myCurrentDefinitionPath.add(new Position(nextDefinition, 0));
        this.myNextIsSet = true;
    }

    @Override
    public Structure next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more nodes in message");
        }
        Structure currentStructure = this.navigateToStructure(this.myCurrentDefinitionPath);
        this.clearNext();
        return currentStructure;
    }

    private Structure navigateToStructure(List<Position> theDefinitionPath) throws Error {
        Structure currentStructure = null;
        for (Position next : theDefinitionPath) {
            if (currentStructure == null) {
                currentStructure = this.myMessage;
                continue;
            }
            try {
                IStructureDefinition structureDefinition = next.getStructureDefinition();
                Group currentStructureGroup = currentStructure;
                String nextStructureName = structureDefinition.getNameAsItAppearsInParent();
                currentStructure = currentStructureGroup.get(nextStructureName, next.getRepNumber());
            }
            catch (HL7Exception e) {
                throw new Error("Failed to retrieve structure: ", e);
            }
        }
        return currentStructure;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove a node from a message");
    }

    public String getDirection() {
        return this.myDirection;
    }

    public void setDirection(String direction) {
        this.clearNext();
        this.myDirection = direction;
    }

    private void clearNext() {
        this.myNextIsSet = false;
    }

    public int getNextIndexWithinParent() {
        return this.getCurrentPosition().getStructureDefinition().getPosition();
    }

    public static class Position {
        private IStructureDefinition myStructureDefinition;
        private int myRepNumber = -1;

        public IStructureDefinition getStructureDefinition() {
            return this.myStructureDefinition;
        }

        public void resetRepNumber() {
            this.myRepNumber = -1;
        }

        public void setStructureDefinition(IStructureDefinition theStructureDefinition) {
            this.myStructureDefinition = theStructureDefinition;
        }

        public int getRepNumber() {
            return this.myRepNumber;
        }

        public Position(IStructureDefinition theStructureDefinition, int theRepNumber) {
            this.myStructureDefinition = theStructureDefinition;
            this.myRepNumber = theRepNumber;
        }

        public void incrementRep() {
            ++this.myRepNumber;
        }

        public boolean equals(Object o) {
            boolean equals = false;
            if (o != null && o instanceof Position) {
                Position p = (Position)o;
                if (p.myStructureDefinition.equals(this.myStructureDefinition) && p.myRepNumber == this.myRepNumber) {
                    equals = true;
                }
            }
            return equals;
        }

        public int hashCode() {
            return this.myStructureDefinition.hashCode() + this.myRepNumber;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            if (this.myStructureDefinition.getParent() != null) {
                ret.append(this.myStructureDefinition.getParent().getName());
            } else {
                ret.append("Root");
            }
            ret.append(":");
            ret.append(this.myStructureDefinition.getName());
            ret.append("(");
            ret.append(this.myRepNumber);
            ret.append(")");
            return ret.toString();
        }
    }
}

