/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.scoring;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.instance.scoring.RuleScore;
import org.hl7.fhir.validation.instance.scoring.ScoreOutcome;
import org.hl7.fhir.validation.instance.scoring.ScoredElement;

public class ScoringEngine {
    private IWorkerContext context;
    private FHIRPathEngine fpe;
    private UcumService ucumService;

    public ScoringEngine(IWorkerContext context, FHIRPathEngine fpe) {
        this.context = context;
        this.fpe = fpe;
        this.ucumService = context.getUcumService();
    }

    public ScoreOutcome generateScores(StructureDefinition structure, Element element) {
        ScoreOutcome outcome = new ScoreOutcome();
        outcome.setElement(new ScoredElement(element.fhirType(), -1, element.fhirType(), 0.0, 0.0, new ArrayList<String>(), new ArrayList<Extension>()));
        for (Element child : element.getChildren()) {
            this.scoreElement(structure, element.fhirType(), outcome.getRules(), outcome.getElement(), element, element, child);
        }
        return outcome;
    }

    private List<Extension> makeScoreRulesList(List<Base.ValidationInfo> list) {
        ArrayList<Extension> rules = new ArrayList<Extension>();
        for (Base.ValidationInfo info : list) {
            for (Extension ext : info.getDefinition().getExtension()) {
                if (!Utilities.existsInList((String)ext.getUrl(), (String[])new String[]{"http://hl7.org/fhir/tools/StructureDefinition/scoring-rule"})) continue;
                rules.add(ext);
            }
        }
        return rules;
    }

    private void scoreElement(StructureDefinition structure, String path, List<RuleScore> ruleList, ScoredElement res, Element root, Element focus, Element element) {
        ElementDefinition ed;
        List vi = element.getValidationInfoForProfile(structure);
        List<Extension> scoreRules = this.makeScoreRulesList(vi);
        Object n = element.getName();
        if (!vi.isEmpty() && (ed = ((Base.ValidationInfo)vi.get(0)).getDefinition()).hasSliceName()) {
            n = (String)n + ":" + ed.getSliceName();
        }
        String npath = element.getIndex() == -1 ? path + "." + (String)n : path + "." + (String)n + "[" + element.getIndex() + "]";
        double score = 0.0;
        double total = 0.0;
        ArrayList<String> reasons = new ArrayList<String>();
        for (Extension ext : scoreRules) {
            RuleScore rule;
            double value = this.getScoreValue(ext);
            total += value;
            boolean passes = this.passesCondition(npath, ext, root, focus, element, reasons);
            List<String> rules = this.getScoreRuleCodes(ext);
            for (String rule2 : rules) {
                if (!passes) continue;
                try {
                    passes = this.checkRule(npath, element, rule2, reasons);
                }
                catch (Exception e) {
                    reasons.add("Exception: " + e.getMessage());
                }
            }
            if (passes) {
                score += value;
            }
            if ((rule = this.getRule(ruleList, ext, value)) == null) continue;
            rule.count(passes);
        }
        ScoredElement e = new ScoredElement((String)n, element.getIndex(), element.fhirType(), score, total, reasons, scoreRules);
        res.addChild(e);
        for (Element child : element.getChildren()) {
            this.scoreElement(structure, npath, ruleList, e, root, child.isResource() ? child : focus, child);
        }
    }

    private RuleScore getRule(List<RuleScore> rules, Extension ext, double value) {
        String key = ext.getExtensionString("key");
        if (key == null) {
            return null;
        }
        for (RuleScore r : rules) {
            if (!r.getKey().equals(key)) continue;
            return r;
        }
        RuleScore r = new RuleScore(key, value);
        rules.add(r);
        return r;
    }

    private boolean checkRule(String path, Element element, String rule, List<String> reasons) throws UcumException {
        if ("valid".equals(rule)) {
            return element.isValid();
        }
        if (element.isPrimitive()) {
            if (element.fhirType().equals("canonical")) {
                return this.checkCanonicalRule(path, element, rule, reasons);
            }
            return this.checkPrimitiveRule(path, element, rule, reasons);
        }
        if ("Coding".equals(element.fhirType())) {
            return this.checkCodingRule(path, element, rule, reasons);
        }
        if ("CodeableConcept".equals(element.fhirType())) {
            return this.checkCodeableConceptRule(path, element, rule, reasons);
        }
        if ("Identifier".equals(element.fhirType())) {
            return this.checkIdentifierRule(path, element, rule, reasons);
        }
        if ("Quantity".equals(element.fhirType())) {
            return this.checkQuantityRule(path, element, rule, reasons);
        }
        if ("HumanName".equals(element.fhirType())) {
            return this.checkHumanNameRule(path, element, rule, reasons);
        }
        if ("Address".equals(element.fhirType())) {
            return this.checkAddressRule(path, element, rule, reasons);
        }
        if ("Attachment".equals(element.fhirType())) {
            return this.checkAttachmentRule(path, element, rule, reasons);
        }
        if ("ContactPoint".equals(element.fhirType())) {
            return this.checkContactPointRule(path, element, rule, reasons);
        }
        if ("Period".equals(element.fhirType())) {
            return this.checkPeriodRule(path, element, rule, reasons);
        }
        if ("Range".equals(element.fhirType())) {
            return this.checkRangeRule(path, element, rule, reasons);
        }
        if ("Reference".equals(element.fhirType())) {
            return this.checkReferenceRule(path, element, rule, reasons);
        }
        return this.checkGeneralRule(path, element, rule, reasons);
    }

    private boolean checkCanonicalRule(String path, Element element, String rule, List<String> reasons) {
        return this.checkPrimitiveRule(path, element, rule, reasons);
    }

    private boolean checkPrimitiveRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            case "value": {
                return element.hasPrimitiveValue();
            }
        }
        if (rule.startsWith("system:")) {
            return rule.substring(7).equals(element.getNamedChildValue(new String[]{"system"}));
        }
        if (rule.startsWith("binding:")) {
            Coding c = ObjectConverter.readAsCoding((Element)element);
            ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, rule.substring(8));
            if (vs == null) {
                reasons.add("Unable to find ValueSet: " + rule.substring(8));
                return false;
            }
            ValidationResult vr = this.context.validateCode(ValidationOptions.defaults(), c, vs);
            return vr.isOk();
        }
        if (rule.startsWith("regex:")) {
            return element.primitiveValue().matches(rule.substring(6));
        }
        reasons.add("Unknown rule '" + rule + "' on an Identifier at " + path);
        return false;
    }

    private boolean checkCodingRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            case "system": {
                return element.hasChildren("system");
            }
            case "version": {
                return element.hasChildren("version");
            }
            case "code": {
                return element.hasChildren("code");
            }
            case "display": {
                return element.hasChildren("display");
            }
        }
        if (rule.startsWith("system:")) {
            return rule.substring(7).equals(element.getNamedChildValue(new String[]{"system"}));
        }
        if (rule.startsWith("binding:")) {
            Coding c = ObjectConverter.readAsCoding((Element)element);
            ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, rule.substring(8));
            if (vs == null) {
                reasons.add("Unable to find ValueSet: " + rule.substring(8));
                return false;
            }
            ValidationResult vr = this.context.validateCode(ValidationOptions.defaults(), c, vs);
            return vr.isOk();
        }
        reasons.add("Unknown rule '" + rule + "' on an Identifier at " + path);
        return false;
    }

    private boolean checkCodeableConceptRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            case "coding": {
                return element.hasChildren("coding");
            }
            case "text": {
                return element.hasChildren("text");
            }
        }
        if (rule.startsWith("system:")) {
            return rule.substring(7).equals(element.getNamedChildValue(new String[]{"system"}));
        }
        if (rule.startsWith("binding:")) {
            CodeableConcept cc = ObjectConverter.readAsCodeableConcept((Element)element);
            ValueSet vs = (ValueSet)this.context.fetchResource(ValueSet.class, rule.substring(8));
            if (vs == null) {
                reasons.add("Unable to find ValueSet: " + rule.substring(8));
                return false;
            }
            ValidationResult vr = this.context.validateCode(ValidationOptions.defaults(), cc, vs);
            return vr.isOk();
        }
        reasons.add("Unknown rule '" + rule + "' on an Identifier at " + path);
        return false;
    }

    private boolean checkIdentifierRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            case "use": {
                return element.hasChildren("use");
            }
            case "type": {
                return element.hasChildren("type");
            }
            case "complete": {
                return element.hasChildren("system") && element.hasChildren("value");
            }
        }
        if (rule.startsWith("system:")) {
            return rule.substring(7).equals(element.getNamedChildValue(new String[]{"system"}));
        }
        reasons.add("Unknown rule '" + rule + "' on an Identifier at " + path);
        return false;
    }

    private boolean checkQuantityRule(String path, Element element, String rule, List<String> reasons) throws UcumException {
        switch (rule) {
            case "code": {
                return element.hasChildren("code") && element.hasChildren("system");
            }
            case "ucum": {
                return "http://unitsofmeasure.org".equals(element.getNamedChildValue(new String[]{"system"}));
            }
        }
        if (rule.startsWith("compares:")) {
            return this.ucumService.isComparable(rule.substring(9), element.getNamedChildValue(new String[]{"code"}));
        }
        reasons.add("Unknown rule '" + rule + "' on a Quantity at " + path);
        return false;
    }

    private boolean checkHumanNameRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            case "text": {
                return element.hasChildren("text");
            }
            case "family": {
                return element.hasChildren("family");
            }
            case "given": {
                return element.hasChild("given");
            }
            case "content": {
                return element.hasChildren("text") || element.hasChildren("given");
            }
            case "use": {
                return element.hasChild("use");
            }
        }
        reasons.add("Unknown rule '" + rule + "' on a HumanName at " + path);
        return false;
    }

    private boolean checkAddressRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            case "type": {
                return element.hasChild("type");
            }
            case "text": {
                return element.hasChildren("text");
            }
            case "line": {
                return element.hasChildren("line");
            }
            case "postalCode": {
                return element.hasChild("postalCode");
            }
            case "content": {
                return element.hasChildren("text") || element.hasChildren("line");
            }
            case "use": {
                return element.hasChild("use");
            }
        }
        reasons.add("Unknown rule '" + rule + "' on an Address at " + path);
        return false;
    }

    private boolean checkAttachmentRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            case "url": {
                return element.hasChild("url");
            }
            case "data": {
                return element.hasChild("data");
            }
            case "content": {
                return element.hasChild("url") || element.hasChild("data");
            }
            case "contentType": {
                return element.hasChild("contentType");
            }
            case "triple": {
                return (element.hasChild("url") || element.hasChild("data")) && element.hasChild("contentType");
            }
            case "hash": {
                return element.hasChild("hash");
            }
        }
        reasons.add("Unknown rule '" + rule + "' on an Attachment at " + path);
        return false;
    }

    private boolean checkContactPointRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            case "value": {
                return element.hasChild("value");
            }
            case "system": {
                return element.hasChild("system");
            }
            case "use": {
                return element.hasChild("value");
            }
            case "resolves": {
                return element.hasChild("value") && element.hasChild("system");
            }
            case "triple": {
                return element.hasChild("value") && element.hasChild("system") && element.hasChild("use");
            }
            case "auto": {
                return element.hasChild("value") && element.hasChild("system") && Utilities.existsInList((String)element.getNamedChildValue(new String[]{"system"}), (String[])new String[]{"email", "url", "sms"});
            }
        }
        reasons.add("Unknown rule '" + rule + "' on a ContactPoint at " + path);
        return false;
    }

    private boolean checkPeriodRule(String path, Element element, String rule, List<String> reasons) {
        Element start = element.getNamedChild("start", false);
        Element end = element.getNamedChild("end", false);
        switch (rule) {
            case "both": {
                return start != null && end != null;
            }
            case "end": {
                return end != null;
            }
            case "start": {
                return start != null;
            }
            case "precision": {
                return start.primitiveValue().length() == end.primitiveValue().length();
            }
            case "timeOfDay": {
                return start.primitiveValue().length() > 10 && end.primitiveValue().length() > 10;
            }
        }
        reasons.add("Unknown rule '" + rule + "' on a Period at " + path);
        return false;
    }

    private boolean checkRangeRule(String path, Element element, String rule, List<String> reasons) throws UcumException {
        Element low = element.getNamedChild("low", false);
        Element high = element.getNamedChild("high", false);
        switch (rule) {
            case "both": {
                return low != null && high != null;
            }
            case "high": {
                return high != null;
            }
            case "low": {
                return low != null;
            }
            case "units": {
                return low.hasChild("units") && high.hasChild("units") && low.hasChild("code") && high.hasChild("code");
            }
            case "units-match": {
                return low.hasChild("code") && high.hasChild("code") && this.ucumService.isComparable(low.getNamedChildValue(new String[]{"units"}), high.getNamedChildValue(new String[]{"units"}));
            }
            case "units-same": {
                return low.hasChild("code") && high.hasChild("code") && StringUtils.compare((String)low.getNamedChildValue(new String[]{"units"}), (String)high.getNamedChildValue(new String[]{"units"})) == 0;
            }
        }
        if (rule.startsWith("compares:")) {
            return this.ucumService.isComparable(rule.substring(9), low.getNamedChildValue(new String[]{"code"})) && this.ucumService.isComparable(rule.substring(9), high.getNamedChildValue(new String[]{"code"}));
        }
        reasons.add("Unknown rule '" + rule + "' on a Range at " + path);
        return false;
    }

    private boolean checkReferenceRule(String path, Element element, String rule, List<String> reasons) {
        String ref = element.getNamedChildValue(new String[]{"reference"});
        switch (rule) {
            case "reference": {
                return ref != null;
            }
            case "rest": {
                return ref != null && ref.matches("((http|https):\\/\\/([A-Za-z0-9\\\\\\.\\:\\%\\$\\-_]*\\/)*?)?(Account|ActivityDefinition|ActorDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|ArtifactAssessment|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BiologicallyDerivedProductDispense|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseDefinition|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceAssociation|DeviceDefinition|DeviceDispense|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentReference|Encounter|EncounterHistory|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|FormularyItem|GenomicStudy|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingSelection|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryItem|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestOrchestration|Requirements|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestPlan|TestReport|TestScript|Transport|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?");
            }
            case "local-rest": {
                return ref != null && ref.matches("(Account|ActivityDefinition|ActorDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|ArtifactAssessment|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BiologicallyDerivedProductDispense|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseDefinition|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceAssociation|DeviceDefinition|DeviceDispense|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentReference|Encounter|EncounterHistory|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|FormularyItem|GenomicStudy|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingSelection|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryItem|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestOrchestration|Requirements|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestPlan|TestReport|TestScript|Transport|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}");
            }
            case "absolute": {
                return ref != null && ref.matches("((http|https):\\/\\/([A-Za-z0-9\\\\\\.\\:\\%\\$\\-_]*\\/)*?)?(Account|ActivityDefinition|ActorDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|ArtifactAssessment|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BiologicallyDerivedProductDispense|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseDefinition|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceAssociation|DeviceDefinition|DeviceDispense|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentReference|Encounter|EncounterHistory|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|FormularyItem|GenomicStudy|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingSelection|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryItem|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestOrchestration|Requirements|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestPlan|TestReport|TestScript|Transport|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && Utilities.isAbsoluteUrl((String)ref);
            }
            case "identifier": {
                return element.hasChild("identifier");
            }
            case "display": {
                return element.hasChild("display");
            }
        }
        reasons.add("Unknown rule '" + rule + "' on a Reference at " + path);
        return false;
    }

    private boolean checkGeneralRule(String path, Element element, String rule, List<String> reasons) {
        switch (rule) {
            default: 
        }
        reasons.add("Unknown rule '" + rule + "' on a " + element.fhirType() + " at " + path);
        return false;
    }

    private boolean passesCondition(String path, Extension ext, Element root, Element focus, Element element, List<String> reasons) {
        if (ext.hasExtension("condition")) {
            String v = ext.getExtensionString("condition");
            try {
                ExpressionNode node = this.fpe.parse(v);
                return this.fpe.evaluateToBoolean(null, (Base)root, (Base)focus, (Base)element, node);
            }
            catch (Exception e) {
                reasons.add("Error evaluating FHIRPath '" + v + "' at '" + path + "': " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private List<String> getScoreRuleCodes(Extension ext) {
        ArrayList<String> rules = new ArrayList<String>();
        for (Extension e : ext.getExtensionsByUrl("rule")) {
            rules.add(e.getValue().primitiveValue());
        }
        return rules;
    }

    private double getScoreValue(Extension ext) {
        double value = 1.0;
        if (ext.hasExtension("value")) {
            String v = ext.getExtensionString("value");
            value = Double.parseDouble(v);
        }
        return value;
    }
}

