/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.advisor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.validation.IMessagingServices;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.constants.BindingKind;
import org.hl7.fhir.r5.utils.validation.constants.ContainedReferenceValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.instance.advisor.BasePolicyAdvisorForFullValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesDrivenPolicyAdvisor
extends BasePolicyAdvisorForFullValidation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RulesDrivenPolicyAdvisor.class);
    private IValidationPolicyAdvisor base;
    private List<SuppressMessageRule> suppressMessageRules = new ArrayList<SuppressMessageRule>();
    private int suppressed = 0;

    public RulesDrivenPolicyAdvisor(ReferenceValidationPolicy refpol, Set<String> referencesTo) {
        super(refpol, referencesTo);
        this.base = null;
    }

    public RulesDrivenPolicyAdvisor(IValidationPolicyAdvisor base) {
        super(base.getReferencePolicy(), base.getCheckReferencesTo());
        this.base = base;
    }

    boolean pathMatches(String[] specifier, String[] actual) {
        if (specifier == null) {
            return true;
        }
        for (int i = 0; i < specifier.length; ++i) {
            if (i == actual.length) {
                return false;
            }
            if (this.pathSegmentMatches(specifier[i], actual[i])) continue;
            return false;
        }
        if (actual.length > specifier.length) {
            return specifier[specifier.length - 1].equals("*");
        }
        return true;
    }

    boolean pathSegmentMatches(String specifier, String actual) {
        if ("*".equals(specifier)) {
            return true;
        }
        if (!specifier.contains("[")) {
            if (actual.contains("[")) {
                actual = actual.substring(0, actual.indexOf("["));
            }
            return specifier.equals(actual);
        }
        return specifier.equals(actual);
    }

    boolean stringMatches(String specifier, @Nonnull String actual) {
        if (specifier == null) {
            return true;
        }
        if (specifier.endsWith("*")) {
            return specifier.substring(0, specifier.length() - 1).equalsIgnoreCase(actual.substring(0, Integer.min(specifier.length() - 1, actual.length())));
        }
        return specifier.equalsIgnoreCase(actual);
    }

    boolean regexMatches(String specifier, @Nonnull String actual) {
        if (specifier == null) {
            return true;
        }
        return actual.matches(specifier);
    }

    protected void addSuppressMessageRule(@Nonnull String id, String path, boolean regex) {
        log.debug("SuppressingRule was added for: " + id + " at path " + path + " as regex?: " + regex);
        this.suppressMessageRules.add(new SuppressMessageRule(id, path, regex));
    }

    protected void addSuppressMessageRule(@Nonnull String id) {
        log.debug("SuppressingRule was added for: " + id);
        this.suppressMessageRules.add(new SuppressMessageRule(id));
    }

    @Override
    public boolean isSuppressMessageId(String path, String messageId) {
        String[] p = path.split("\\.");
        for (SuppressMessageRule rule : this.suppressMessageRules) {
            if (!rule.matches(messageId, path, p)) continue;
            log.debug("Suppressed: " + messageId + " at path " + path + " with rule-path: " + rule.path);
            return true;
        }
        if (this.base != null) {
            return this.base.isSuppressMessageId(path, messageId);
        }
        return super.isSuppressMessageId(path, messageId);
    }

    @Override
    public ReferenceValidationPolicy policyForReference(IResourceValidator validator, Object appContext, String path, String url, IValidationPolicyAdvisor.ReferenceDestinationType destinationType) {
        if (this.base != null) {
            return this.base.policyForReference(validator, appContext, path, url, destinationType);
        }
        return super.policyForReference(validator, appContext, path, url, destinationType);
    }

    @Override
    public ContainedReferenceValidationPolicy policyForContained(IResourceValidator validator, Object appContext, StructureDefinition structure, ElementDefinition element, String containerType, String containerId, Element.SpecialElement containingResourceType, String path, String url) {
        if (this.base != null) {
            return this.base.policyForContained(validator, appContext, structure, element, containerType, containerId, containingResourceType, path, url);
        }
        return super.policyForContained(validator, appContext, structure, element, containerType, containerId, containingResourceType, path, url);
    }

    @Override
    public EnumSet<IValidationPolicyAdvisor.ResourceValidationAction> policyForResource(IResourceValidator validator, Object appContext, StructureDefinition type, String path) {
        if (this.base != null) {
            return this.base.policyForResource(validator, appContext, type, path);
        }
        return super.policyForResource(validator, appContext, type, path);
    }

    @Override
    public EnumSet<IValidationPolicyAdvisor.ElementValidationAction> policyForElement(IResourceValidator validator, Object appContext, StructureDefinition structure, ElementDefinition element, String path) {
        if (this.base != null) {
            return this.base.policyForElement(validator, appContext, structure, element, path);
        }
        return super.policyForElement(validator, appContext, structure, element, path);
    }

    @Override
    public EnumSet<IValidationPolicyAdvisor.CodedContentValidationAction> policyForCodedContent(IResourceValidator validator, Object appContext, String stackPath, ElementDefinition definition, StructureDefinition structure, BindingKind kind, IValidationPolicyAdvisor.AdditionalBindingPurpose purpose, ValueSet valueSet, List<String> systems) {
        if (this.base != null) {
            return this.base.policyForCodedContent(validator, appContext, stackPath, definition, structure, kind, purpose, valueSet, systems);
        }
        return super.policyForCodedContent(validator, appContext, stackPath, definition, structure, kind, purpose, valueSet, systems);
    }

    @Override
    public List<StructureDefinition> getImpliedProfilesForResource(IResourceValidator validator, Object appContext, String stackPath, ElementDefinition definition, StructureDefinition structure, Element resource, boolean valid, IMessagingServices msgServices, List<ValidationMessage> messages) {
        if (this.base != null) {
            return this.base.getImpliedProfilesForResource(validator, appContext, stackPath, definition, structure, resource, valid, msgServices, messages);
        }
        return super.getImpliedProfilesForResource(validator, appContext, stackPath, definition, structure, resource, valid, msgServices, messages);
    }

    private class SuppressMessageRule {
        private String id;
        private String path;
        private String[] pathSegments;
        private boolean regex;

        protected SuppressMessageRule(String id, String path, boolean regex) {
            this.id = id;
            this.path = path;
            this.pathSegments = path.split("\\.");
            this.regex = regex;
        }

        protected SuppressMessageRule(String id) {
            this.id = id;
        }

        public boolean matches(@Nonnull String mid, @Nonnull String path, String[] p) {
            if (this.regex) {
                return RulesDrivenPolicyAdvisor.this.stringMatches(this.id, mid) && RulesDrivenPolicyAdvisor.this.regexMatches(this.path, path);
            }
            return RulesDrivenPolicyAdvisor.this.stringMatches(this.id, mid) && RulesDrivenPolicyAdvisor.this.pathMatches(this.pathSegments, p);
        }
    }
}

