/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.renderers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.validation.service.renderers.ValidationOutputRenderer;

public class NativeRenderer
extends ValidationOutputRenderer {
    private Manager.FhirFormat format;

    public NativeRenderer(Manager.FhirFormat format) {
        this.format = format;
    }

    @Override
    public boolean handlesBundleDirectly() {
        return true;
    }

    @Override
    public void render(OperationOutcome op) throws IOException {
        Object x = this.format == Manager.FhirFormat.JSON ? new JsonParser() : new XmlParser();
        x.setOutputStyle(IParser.OutputStyle.PRETTY);
        x.compose((OutputStream)this.dst, (Resource)op);
    }

    @Override
    public void render(Bundle bundle) throws IOException {
        Object x = this.format == Manager.FhirFormat.JSON ? new JsonParser() : new XmlParser();
        x.setOutputStyle(IParser.OutputStyle.PRETTY);
        x.compose((OutputStream)this.dst, (Resource)bundle);
    }

    @Override
    public boolean isSingleFile() {
        return true;
    }

    @Override
    public String getStyleCode() {
        return this.format.toString().toLowerCase();
    }

    @Override
    public void setFolder(File dir) {
        throw new Error("Not supported");
    }
}

