/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.renderers;

import java.io.File;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.validation.service.renderers.ValidationOutputRenderer;

public class CSVRenderer
extends ValidationOutputRenderer {
    @Override
    public void start(boolean moreThanOne) {
        super.start(moreThanOne);
        this.dst.println("file, line, col, level, message" + (this.showMessageIds ? "message-id" : ""));
    }

    @Override
    public void render(OperationOutcome oo) {
        String file = ExtensionUtilities.readStringExtension((DomainResource)oo, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file");
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            int line = ExtensionUtilities.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", (int)-1);
            int col = ExtensionUtilities.readIntegerExtension((Element)issue, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", (int)-1);
            this.dst.println(file + ", " + (line == -1 ? "" : Integer.toString(line)) + ", " + (col == -1 ? "" : Integer.toString(col)) + ", " + issue.getSeverity().getDisplay() + ", \"" + issue.getDetails().getText() + "\"" + (String)(this.showMessageIds ? "," + issue.getExtensionString("http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id") : ""));
        }
    }

    @Override
    public boolean isSingleFile() {
        return true;
    }

    @Override
    public String getStyleCode() {
        return "csv";
    }

    @Override
    public void setFolder(File dir) {
        throw new Error("Not supported");
    }
}

