/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.context.Slf4JLoggingService;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.LanguageUtils;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.elementmodel.XmlParser;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.fhirpath.FHIRPathFunctionDefinition;
import org.hl7.fhir.r5.fhirpath.IHostApplicationServices;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.liquid.BaseTableWrapper;
import org.hl7.fhir.r5.liquid.GlobalObject;
import org.hl7.fhir.r5.liquid.LiquidEngine;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.gen.PECodeGenerator;
import org.hl7.fhir.r5.renderers.spreadsheets.CodeSystemSpreadsheetGenerator;
import org.hl7.fhir.r5.renderers.spreadsheets.ConceptMapSpreadsheetGenerator;
import org.hl7.fhir.r5.renderers.spreadsheets.StructureDefinitionSpreadsheetGenerator;
import org.hl7.fhir.r5.renderers.spreadsheets.ValueSetSpreadsheetGenerator;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyCache;
import org.hl7.fhir.r5.testfactory.TestDataFactory;
import org.hl7.fhir.r5.testfactory.TestDataHostServices;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.SystemExitManager;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.i18n.JsonLangFileProducer;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;
import org.hl7.fhir.utilities.i18n.PoGetTextProducer;
import org.hl7.fhir.utilities.i18n.XLIFFProducer;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.Content;
import org.hl7.fhir.validation.IgLoader;
import org.hl7.fhir.validation.ResourceChecker;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.ValidationRecord;
import org.hl7.fhir.validation.ValidatorUtils;
import org.hl7.fhir.validation.instance.advisor.BasePolicyAdvisorForFullValidation;
import org.hl7.fhir.validation.instance.advisor.JsonDrivenPolicyAdvisor;
import org.hl7.fhir.validation.instance.advisor.TextDrivenPolicyAdvisor;
import org.hl7.fhir.validation.service.DisabledValidationPolicyAdvisor;
import org.hl7.fhir.validation.service.GenerateSnapshotParameters;
import org.hl7.fhir.validation.service.HTMLOutputGenerator;
import org.hl7.fhir.validation.service.PassiveExpiringSessionCache;
import org.hl7.fhir.validation.service.SessionCache;
import org.hl7.fhir.validation.service.StandAloneValidatorFetcher;
import org.hl7.fhir.validation.service.TransformParameters;
import org.hl7.fhir.validation.service.ValidateSourceParameters;
import org.hl7.fhir.validation.service.ValidatorWatchMode;
import org.hl7.fhir.validation.service.model.CodeGenParameters;
import org.hl7.fhir.validation.service.model.FHIRPathParameters;
import org.hl7.fhir.validation.service.model.FileInfo;
import org.hl7.fhir.validation.service.model.InstanceFactoryParameters;
import org.hl7.fhir.validation.service.model.InstanceValidatorParameters;
import org.hl7.fhir.validation.service.model.MapParameters;
import org.hl7.fhir.validation.service.model.OutputParameters;
import org.hl7.fhir.validation.service.model.PackageNameParameters;
import org.hl7.fhir.validation.service.model.TransformLangParameters;
import org.hl7.fhir.validation.service.model.TransformVersionParameters;
import org.hl7.fhir.validation.service.model.ValidatedFragments;
import org.hl7.fhir.validation.service.model.ValidationContext;
import org.hl7.fhir.validation.service.model.ValidationContextUtilities;
import org.hl7.fhir.validation.service.model.ValidationEngineParameters;
import org.hl7.fhir.validation.service.model.ValidationOutcome;
import org.hl7.fhir.validation.service.model.ValidationRequest;
import org.hl7.fhir.validation.service.model.ValidationResponse;
import org.hl7.fhir.validation.service.model.ValidationTime;
import org.hl7.fhir.validation.service.model.WatchParameters;
import org.hl7.fhir.validation.service.renderers.CSVRenderer;
import org.hl7.fhir.validation.service.renderers.CompactRenderer;
import org.hl7.fhir.validation.service.renderers.DefaultRenderer;
import org.hl7.fhir.validation.service.renderers.ESLintCompactRenderer;
import org.hl7.fhir.validation.service.renderers.NativeRenderer;
import org.hl7.fhir.validation.service.renderers.ValidationOutputRenderer;
import org.hl7.fhir.validation.service.utils.Common;
import org.hl7.fhir.validation.service.utils.EngineMode;
import org.hl7.fhir.validation.service.utils.Slf4JOutputStream;
import org.hl7.fhir.validation.service.utils.VersionSourceInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationService.class);
    private final SessionCache sessionCache;
    private String runDate;
    private final Map<String, ValidationEngine> baseEngines = new ConcurrentHashMap<String, ValidationEngine>();
    private int installedPackageCount;
    private int generatedSnapshotCount;

    @Deprecated(since="2025-11-07")
    public void putBaseEngine(String key, ValidationContext validationContext) throws IOException, URISyntaxException {
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        InstanceValidatorParameters instanceValidatorParameters = ValidationContextUtilities.getInstanceValidatorParameters(validationContext);
        this.putBaseEngine(key, validationEngineParameters, instanceValidatorParameters);
    }

    public void putBaseEngine(String key, ValidationEngineParameters validationEngineParameters, InstanceValidatorParameters defaultInstanceValidatorParameters) throws IOException, URISyntaxException {
        if (validationEngineParameters.getSv() == null) {
            throw new IllegalArgumentException("Cannot create a base engine without an explicit version");
        }
        String definitions = VersionUtilities.packageForVersion((String)validationEngineParameters.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)validationEngineParameters.getSv());
        ValidationEngine baseEngine = this.buildValidationEngine(validationEngineParameters, defaultInstanceValidatorParameters, definitions, new TimeTracker());
        this.baseEngines.put(key, baseEngine);
    }

    public ValidationEngine getBaseEngine(String key) {
        return this.baseEngines.get(key);
    }

    public Set<String> getBaseEngineKeys() {
        return this.baseEngines.keySet();
    }

    public boolean hasBaseEngineForKey(String key) {
        return this.baseEngines.containsKey(key);
    }

    public ValidationService() {
        this.sessionCache = new PassiveExpiringSessionCache();
        this.runDate = new SimpleDateFormat("hh:mm:ss", new Locale("en", "US")).format(new Date());
    }

    public ValidationService(SessionCache cache) {
        this.sessionCache = cache;
    }

    public ValidationResponse validateSources(ValidationRequest request) throws Exception {
        List<String> sources;
        InstanceValidatorParameters instanceValidatorParameters;
        ValidationEngineParameters validationEngineParameters;
        TimeTracker timeTracker = new TimeTracker();
        if (request.getValidationContext() != null) {
            validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(request.getValidationContext());
            instanceValidatorParameters = ValidationContextUtilities.getInstanceValidatorParameters(request.getValidationContext());
            sources = request.getValidationContext().getSources();
            if (request.getValidationContext().getMode() == EngineMode.INSTALL || request.getValidationContext().getMode() == EngineMode.VALIDATION) {
                validationEngineParameters.setInferFhirVersion(Boolean.TRUE);
            }
        } else {
            validationEngineParameters = request.getValidationEngineParameters();
            instanceValidatorParameters = request.getInstanceValidatorParameters() == null ? new InstanceValidatorParameters() : request.getInstanceValidatorParameters();
            sources = request.getSources();
        }
        String sessionId = this.initializeValidator(validationEngineParameters, instanceValidatorParameters, null, timeTracker, sources, request.sessionId);
        ValidationEngine validationEngine = this.sessionCache.fetchSessionValidatorEngine(sessionId);
        validationEngine.setLanguage(validationEngineParameters.getLang());
        validationEngine.setLocale(validationEngineParameters.getLocale());
        if (instanceValidatorParameters.getProfiles().isEmpty()) {
            log.info("  .. validate " + request.listSourceFiles());
        } else {
            log.info("  .. validate " + request.listSourceFiles() + " against " + instanceValidatorParameters.getProfiles().toString());
        }
        ValidationResponse response = new ValidationResponse().setSessionId(sessionId).setValidationTimes(new HashMap<String, ValidationTime>());
        for (FileInfo fileToValidate : request.getFilesToValidate()) {
            Manager.FhirFormat format;
            if (fileToValidate.getFileType() == null && (format = ResourceChecker.checkIsResource(validationEngine.getContext(), fileToValidate.getFileContent().getBytes(), fileToValidate.getFileName(), false)) != null) {
                fileToValidate.setFileType(format.getExtension());
            }
            ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
            if (fileToValidate.getFileType() == null) {
                ValidationOutcome outcome = this.getValidationOutcomeForUnknownFileFormat(new FileInfo(fileToValidate.getFileName(), fileToValidate.getFileContent(), null));
                response.addOutcome(outcome);
                continue;
            }
            ValidatedFragments validatedFragments = validationEngine.validateAsFragments(fileToValidate.getFileContent().getBytes(), Manager.FhirFormat.getFhirFormat((String)fileToValidate.getFileType()), instanceValidatorParameters.getProfiles(), messages);
            List<ValidationOutcome> validationOutcomes = this.getValidationOutcomesFromValidatedFragments(fileToValidate, validatedFragments);
            for (ValidationOutcome validationOutcome : validationOutcomes) {
                response.addOutcome(validationOutcome);
            }
            if (!validationEngineParameters.isShowTimes()) continue;
            response.getValidationTimes().put(fileToValidate.getFileName(), validatedFragments.getValidationTime());
        }
        log.info("  Max Memory: " + Runtime.getRuntime().maxMemory());
        return response;
    }

    private List<ValidationOutcome> getValidationOutcomesFromValidatedFragments(FileInfo fileToValidate, ValidatedFragments validatedFragments) {
        LinkedList<ValidationOutcome> outcomes = new LinkedList<ValidationOutcome>();
        if (validatedFragments.getValidatedFragments().size() == 1 && !validatedFragments.getValidatedFragments().get(0).isDerivedContent()) {
            ValidatedFragment validatedFragment = validatedFragments.getValidatedFragments().get(0);
            ValidationOutcome outcome = new ValidationOutcome();
            FileInfo fileInfo = new FileInfo(fileToValidate.getFileName(), new String(validatedFragment.getContent()), validatedFragment.getExtension());
            outcome.setMessages(validatedFragment.getErrors());
            outcome.setFileInfo(fileInfo);
            outcomes.add(outcome);
        } else {
            for (ValidatedFragment validatedFragment : validatedFragments.getValidatedFragments()) {
                ValidationOutcome outcome = new ValidationOutcome();
                FileInfo fileInfo = new FileInfo(validatedFragment.getFilename(), new String(validatedFragment.getContent()), validatedFragment.getExtension());
                outcome.setMessages(validatedFragment.getErrors());
                outcome.setFileInfo(fileInfo);
                outcomes.add(outcome);
            }
        }
        return outcomes;
    }

    private ValidationOutcome getValidationOutcomeForUnknownFileFormat(FileInfo fileInfo) {
        ValidationOutcome outcome = new ValidationOutcome();
        ArrayList<ValidationMessage> errorList = new ArrayList<ValidationMessage>(){
            {
                this.add(new ValidationMessage().setType(ValidationMessage.IssueType.EXCEPTION).setLevel(ValidationMessage.IssueSeverity.FATAL).setMessage("Unable to infer format from file. Please check that your file is in a valid FHIR format."));
            }
        };
        outcome.setMessages((List<ValidationMessage>)errorList);
        outcome.setFileInfo(fileInfo);
        return outcome;
    }

    @Deprecated(since="2025-11-07")
    public VersionSourceInformation scanForVersions(ValidationContext validationContext) throws IOException {
        List<String> igs = validationContext.getIgs();
        List<String> sources = validationContext.getSources();
        boolean isRecursive = validationContext.isRecursive();
        return this.scanForVersions(igs, sources, isRecursive);
    }

    public VersionSourceInformation scanForVersions(List<String> igs, List<String> sources, boolean isRecursive) throws IOException {
        VersionSourceInformation versions = new VersionSourceInformation();
        IgLoader igLoader = new IgLoader(new FilesystemPackageCacheManager.Builder().build(), new SimpleWorkerContext.SimpleWorkerContextBuilder().fromNothing(), null);
        for (String src : igs) {
            igLoader.scanForIgVersion(src, isRecursive, versions);
        }
        igLoader.scanForVersions(sources, versions);
        return versions;
    }

    @Deprecated(since="2025-11-05")
    public void validateSources(ValidationContext validationContext, ValidationEngine validator, ValidatorWatchMode watch, int watchScanDelay, int watchSettleTime) throws Exception {
        WatchParameters watchParameters = ValidationContextUtilities.getWatchParameters(validationContext);
        InstanceValidatorParameters instanceValidatorParameters = ValidationContextUtilities.getInstanceValidatorParameters(validationContext);
        List<String> sources = validationContext.getSources();
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        this.validateSources(validator, new ValidateSourceParameters(instanceValidatorParameters, sources, outputParameters.getOutput(), watchParameters));
    }

    public void validateSources(ValidationEngine validationEngine, ValidateSourceParameters validateSourceParameters) throws Exception {
        WatchParameters watchParameters;
        InstanceValidatorParameters instanceValidatorParameters = validateSourceParameters.instanceValidatorParameters() == null ? validationEngine.getDefaultInstanceValidatorParameters() : validateSourceParameters.instanceValidatorParameters();
        WatchParameters watchParameters2 = watchParameters = validateSourceParameters.watchParameters() == null ? new WatchParameters() : validateSourceParameters.watchParameters();
        if (!instanceValidatorParameters.getProfiles().isEmpty()) {
            log.info("  Profiles: " + String.valueOf(instanceValidatorParameters.getProfiles()));
        }
        IgLoader igLoader = new IgLoader(validationEngine.getPcm(), validationEngine.getContext(), validationEngine.getVersion());
        ArrayList<ValidationRecord> records = new ArrayList<ValidationRecord>();
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        int ec = 0;
        boolean first = true;
        do {
            long start = System.currentTimeMillis();
            Resource resource = validationEngine.validate(validateSourceParameters.sources(), instanceValidatorParameters.getProfiles(), refs, records, igLoader, watchParameters.getWatchMode() == ValidatorWatchMode.ALL, watchParameters.getWatchSettleTime(), first);
            first = false;
            boolean statusNeeded = false;
            if (resource != null) {
                statusNeeded = true;
                MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                log.info("Done. " + validationEngine.getContext().clock().report() + ". Memory = " + Utilities.describeSize((long)(mbean.getHeapMemoryUsage().getUsed() + mbean.getNonHeapMemoryUsage().getUsed())));
                log.info("");
                PrintStream dst = null;
                ValidationOutputRenderer renderer = this.makeValidationOutputRenderer(validateSourceParameters.output(), instanceValidatorParameters.getOutputStyle());
                renderer.setCrumbTrails(instanceValidatorParameters.isCrumbTrails());
                renderer.setShowMessageIds(instanceValidatorParameters.isShowMessageIds());
                renderer.setRunDate(this.runDate);
                if (renderer.isSingleFile()) {
                    dst = validateSourceParameters.output() == null ? new PrintStream(new Slf4JOutputStream()) : new PrintStream(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{validateSourceParameters.output()})));
                    renderer.setOutput(dst);
                } else {
                    File dir = ManagedFileAccess.file((String)validateSourceParameters.output());
                    if (!dir.isDirectory()) {
                        throw new Error("The output location " + dir.getAbsolutePath() + " must be an existing directory for the output style " + renderer.getStyleCode());
                    }
                    renderer.setFolder(dir);
                }
                if (resource instanceof Bundle) {
                    if (renderer.handlesBundleDirectly()) {
                        renderer.render((Bundle)resource);
                    } else {
                        renderer.start(((Bundle)resource).getEntry().size() > 1);
                        for (Bundle.BundleEntryComponent e : ((Bundle)resource).getEntry()) {
                            OperationOutcome op = (OperationOutcome)e.getResource();
                            ec += this.countErrors(op);
                            renderer.render(op);
                        }
                        renderer.finish();
                    }
                } else if (resource == null) {
                    ++ec;
                    log.info("No output from validation - nothing to validate");
                } else {
                    renderer.start(false);
                    OperationOutcome op = (OperationOutcome)resource;
                    ec = this.countErrors(op);
                    renderer.render((OperationOutcome)resource);
                    renderer.finish();
                }
                if (validateSourceParameters.output() != null && dst != null) {
                    dst.close();
                }
                if (instanceValidatorParameters.getHtmlOutput() != null) {
                    String html = new HTMLOutputGenerator(records).generate(System.currentTimeMillis() - start);
                    FileUtilities.stringToFile((String)html, (String)instanceValidatorParameters.getHtmlOutput());
                    log.info("HTML Summary in " + instanceValidatorParameters.getHtmlOutput());
                }
                if (instanceValidatorParameters.isShowTerminologyRouting()) {
                    log.info("");
                    log.info("Terminology Routing Dump ---------------------------------------");
                    if (validationEngine.getContext().getTxClientManager().getInternalLog().isEmpty()) {
                        log.info("(nothing happened)");
                    } else {
                        for (TerminologyClientManager.InternalLogEvent logEvent : validationEngine.getContext().getTxClientManager().getInternalLog()) {
                            log.info(logEvent.getMessage() + " -> " + logEvent.getServer() + " (for VS " + logEvent.getVs() + " with systems '" + logEvent.getSystems() + "', choices = '" + logEvent.getChoices() + "')");
                        }
                    }
                    validationEngine.getContext().getTxClientManager().getInternalLog().clear();
                }
            }
            if (watchParameters.getWatchMode() == ValidatorWatchMode.NONE) continue;
            if (statusNeeded) {
                log.info("Watching for changes (" + Integer.toString(watchParameters.getWatchScanDelay()) + "ms cycle)");
            }
            Thread.sleep(watchParameters.getWatchScanDelay());
        } while (watchParameters.getWatchMode() != ValidatorWatchMode.NONE);
        if (ec > 0) {
            SystemExitManager.setError((int)1);
        }
    }

    private int countErrors(OperationOutcome oo) {
        int error = 0;
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            if (issue.getSeverity() != OperationOutcome.IssueSeverity.FATAL && issue.getSeverity() != OperationOutcome.IssueSeverity.ERROR) continue;
            ++error;
        }
        return error;
    }

    private ValidationOutputRenderer makeValidationOutputRenderer(String output, String style) {
        if (Utilities.noString((String)style)) {
            if (output == null) {
                return new DefaultRenderer();
            }
            if (output.endsWith(".json")) {
                return new NativeRenderer(Manager.FhirFormat.JSON);
            }
            return new NativeRenderer(Manager.FhirFormat.XML);
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"eslint-compact"})) {
            return new ESLintCompactRenderer();
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"compact-split"})) {
            return new CompactRenderer(true);
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"compact"})) {
            return new CompactRenderer(false);
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"csv"})) {
            return new CSVRenderer();
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"xml"})) {
            return new NativeRenderer(Manager.FhirFormat.XML);
        }
        if (Utilities.existsInList((String)style, (String[])new String[]{"json"})) {
            return new NativeRenderer(Manager.FhirFormat.JSON);
        }
        log.info("Unknown output style '" + style + "'");
        return new DefaultRenderer();
    }

    @Deprecated(since="2025-11-05")
    public void convertSources(ValidationContext validationContext, ValidationEngine validationEngine) throws Exception {
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.convertSources(validationEngine, sources, outputParameters.getOutput(), outputParameters.getOutputSuffix());
    }

    public void convertSources(ValidationEngine validationEngine, List<String> sources, String output, String outputSuffix) throws Exception {
        if (!(output == null ^ outputSuffix == null)) {
            throw new Exception("Convert requires one of {-output, -outputSuffix} parameter to be set");
        }
        if (sources.size() == 1 && output != null) {
            log.info(" ...convert");
            validationEngine.convert(sources.get(0), output);
        } else {
            if (outputSuffix == null) {
                throw new Exception("Converting multiple/wildcard sources requires a -outputSuffix parameter to be set");
            }
            for (int i = 0; i < sources.size(); ++i) {
                String outputPath = sources.get(i) + "." + outputSuffix;
                validationEngine.convert(sources.get(i), outputPath);
                log.info(" ...convert [" + i + "] (" + sources.get(i) + " to " + outputPath + ")");
            }
        }
    }

    @Deprecated(since="2025-11-05")
    public void evaluateFhirpath(ValidationContext validationContext, ValidationEngine validationEngine) throws Exception {
        FHIRPathParameters fhirPathParameters = ValidationContextUtilities.getFHIRPathParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.evaluateFhirpath(validationEngine, fhirPathParameters.getFhirpath(), sources);
    }

    public void evaluateFhirpath(ValidationEngine validationEngine, String fhirPath, List<String> sources) throws Exception {
        log.info(" ...evaluating " + fhirPath);
        log.info(validationEngine.evaluateFhirPath(sources.get(0), fhirPath));
    }

    @Deprecated(since="2025-11-05")
    public void generateSnapshot(ValidationContext validationContext, ValidationEngine validationEngine) throws Exception {
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.generateSnapshot(validationEngine, new GenerateSnapshotParameters(validationEngineParameters.getSv(), sources, outputParameters.getOutput(), outputParameters.getOutputSuffix()));
    }

    public void generateSnapshot(ValidationEngine validationEngine, GenerateSnapshotParameters generateSnapshotParameters) throws Exception {
        if (!(generateSnapshotParameters.output() == null ^ generateSnapshotParameters.outputSuffix() == null)) {
            throw new Exception("Snapshot generation requires one of {-output, -outputSuffix} parameter to be set");
        }
        if (generateSnapshotParameters.sources().size() == 1 && generateSnapshotParameters.output() != null) {
            StructureDefinition r = validationEngine.snapshot(generateSnapshotParameters.sources().get(0), generateSnapshotParameters.version());
            log.info(" ...generated snapshot successfully");
            validationEngine.handleOutput((Resource)r, generateSnapshotParameters.output(), generateSnapshotParameters.version());
        } else {
            if (generateSnapshotParameters.outputSuffix() == null) {
                throw new Exception("Snapshot generation for multiple/wildcard sources requires a -outputSuffix parameter to be set");
            }
            for (int i = 0; i < generateSnapshotParameters.sources().size(); ++i) {
                StructureDefinition r = validationEngine.snapshot(generateSnapshotParameters.sources().get(i), generateSnapshotParameters.version());
                String outputDest = generateSnapshotParameters.sources().get(i) + "." + generateSnapshotParameters.outputSuffix();
                validationEngine.handleOutput((Resource)r, outputDest, generateSnapshotParameters.version());
                log.info(" ...generated snapshot [" + i + "] successfully (" + generateSnapshotParameters.sources().get(i) + " to " + outputDest + ")");
            }
        }
    }

    @Deprecated(since="2025-11-05")
    public void generateNarrative(ValidationContext validationContext, ValidationEngine validationEngine) throws Exception {
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.generateNarrative(validationEngine, validationEngineParameters.getSv(), sources, outputParameters.getOutput());
    }

    public void generateNarrative(ValidationEngine validationEngine, String version, List<String> sources, String output) throws Exception {
        Resource r = validationEngine.generate(sources.get(0), version);
        log.info(" ...generated narrative successfully");
        if (output != null) {
            validationEngine.handleOutput(r, output, version);
        }
    }

    @Deprecated(since="2025-11-05")
    public void transform(ValidationContext validationContext, ValidationEngine validationEngine) throws Exception {
        MapParameters mapParameters = ValidationContextUtilities.getMapParameters(validationContext);
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.transform(validationEngine, new TransformParameters(mapParameters.getMap(), validationEngineParameters.getMapLog(), validationEngineParameters.getTxServer(), sources, outputParameters.getOutput()));
    }

    public void transform(ValidationEngine validationEngine, TransformParameters transformParameters) throws Exception {
        if (transformParameters.sources().size() > 1) {
            throw new Exception("Can only have one source when doing a transform (found " + String.valueOf(transformParameters.sources()) + ")");
        }
        if (transformParameters.txServer() == null) {
            throw new Exception("Must provide a terminology server when doing a transform");
        }
        if (transformParameters.map() == null) {
            throw new Exception("Must provide a map when doing a transform");
        }
        try {
            ContextUtilities cu = new ContextUtilities((IWorkerContext)validationEngine.getContext());
            List structures = cu.allStructures();
            for (StructureDefinition sd : structures) {
                if (sd.hasSnapshot()) continue;
                cu.generateSnapshot(sd);
            }
            validationEngine.setMapLog(transformParameters.mapLog());
            Element r = validationEngine.transform(transformParameters.sources().get(0), transformParameters.map());
            log.info(" ...success");
            if (transformParameters.output() != null) {
                FileOutputStream s = ManagedFileAccess.outStream((String)transformParameters.output());
                if (transformParameters.output() != null && transformParameters.output().endsWith(".json")) {
                    new org.hl7.fhir.r5.elementmodel.JsonParser((IWorkerContext)validationEngine.getContext()).compose(r, (OutputStream)s, IParser.OutputStyle.PRETTY, null);
                } else {
                    new XmlParser((IWorkerContext)validationEngine.getContext()).compose(r, (OutputStream)s, IParser.OutputStyle.PRETTY, null);
                }
                s.close();
            }
        }
        catch (Exception e) {
            log.info(" ...Failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Deprecated(since="2025-11-06")
    public void compile(ValidationContext validationContext, ValidationEngine validationEngine) throws Exception {
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        MapParameters mapParameters = ValidationContextUtilities.getMapParameters(validationContext);
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.compile(validationEngine, mapParameters.getMap(), validationEngineParameters.getMapLog(), sources, outputParameters.getOutput());
    }

    public void compile(ValidationEngine validationEngine, String map, String mapLog, List<String> sources, String output) throws Exception {
        if (sources.size() > 0) {
            throw new Exception("Cannot specify sources when compling transform (found " + String.valueOf(sources) + ")");
        }
        if (map == null) {
            throw new Exception("Must provide a map when compiling a transform");
        }
        if (output == null) {
            throw new Exception("Must provide an output name when compiling a transform");
        }
        try {
            ContextUtilities cu = new ContextUtilities((IWorkerContext)validationEngine.getContext());
            List structures = cu.allStructures();
            for (StructureDefinition sd : structures) {
                if (sd.hasSnapshot()) continue;
                cu.generateSnapshot(sd);
            }
            validationEngine.setMapLog(mapLog);
            StructureMap structureMap = validationEngine.compile(map);
            if (structureMap == null) {
                throw new Exception("Unable to locate map " + map);
            }
            validationEngine.handleOutput((Resource)structureMap, output, validationEngine.getVersion());
            log.info(" ...success");
        }
        catch (Exception e) {
            log.info(" ...Failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Deprecated(since="2025-11-05")
    public void transformVersion(ValidationContext validationContext, ValidationEngine validationEngine) throws Exception {
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        TransformVersionParameters transformVersionParameters = ValidationContextUtilities.getTransformVersionParameters(validationContext);
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.transformVersion(validationEngine, new org.hl7.fhir.validation.service.TransformVersionParameters(transformVersionParameters.getTargetVer(), validationEngineParameters.getMapLog(), transformVersionParameters.getCanDoNative(), sources, outputParameters.getOutput()));
    }

    public void transformVersion(ValidationEngine validationEngine, org.hl7.fhir.validation.service.TransformVersionParameters transformVersionParameters) throws Exception {
        if (transformVersionParameters.sources().size() > 1) {
            throw new Exception("Can only have one source when converting versions (found " + String.valueOf(transformVersionParameters.sources()) + ")");
        }
        if (transformVersionParameters.targetVer() == null) {
            throw new Exception("Must provide a map when converting versions");
        }
        if (transformVersionParameters.output() == null) {
            throw new Exception("Must nominate an output when converting versions");
        }
        try {
            if (transformVersionParameters.mapLog() != null) {
                validationEngine.setMapLog(transformVersionParameters.mapLog());
            }
            byte[] r = validationEngine.transformVersion(transformVersionParameters.sources().get(0), transformVersionParameters.targetVer(), transformVersionParameters.output().endsWith(".json") ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML, transformVersionParameters.canDoNative());
            log.info(" ...success");
            FileUtilities.bytesToFile((byte[])r, (String)transformVersionParameters.output());
        }
        catch (Exception e) {
            log.info(" ...Failure: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Deprecated(since="2025-11-07")
    public ValidationEngine initializeValidator(ValidationContext validationContext, String definitions, TimeTracker tt) throws Exception {
        return this.sessionCache.fetchSessionValidatorEngine(this.initializeValidator(validationContext, definitions, tt, null));
    }

    @Deprecated(since="2025-11-07")
    public String initializeValidator(ValidationContext validationContext, String definitions, TimeTracker tt, String sessionId) throws Exception {
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        InstanceValidatorParameters defaultInstanceValidatorParams = ValidationContextUtilities.getInstanceValidatorParameters(validationContext);
        return this.initializeValidator(validationEngineParameters, defaultInstanceValidatorParams, definitions, tt, validationContext.getSources(), sessionId);
    }

    public ValidationEngine initializeValidator(ValidationEngineParameters validationEngineParameters, InstanceValidatorParameters defaultInstanceValidatorParameters, String definitions, TimeTracker tt, List<String> sources) throws Exception {
        return this.sessionCache.fetchSessionValidatorEngine(this.initializeValidator(validationEngineParameters, defaultInstanceValidatorParameters, definitions, tt, sources, null));
    }

    public String initializeValidator(ValidationEngineParameters validationEngineParameters, InstanceValidatorParameters defaultInstanceValidatorParameters, String definitions, TimeTracker tt, List<String> sources, String sessionId) throws Exception {
        tt.milestone();
        if (!this.sessionCache.sessionExists(sessionId)) {
            if (sessionId != null) {
                log.info("No such cached session exists for session id " + sessionId + ", re-instantiating validator.");
            }
            this.sessionCache.cleanUp();
            if (validationEngineParameters.getSv() == null) {
                String sv = this.determineVersion(validationEngineParameters.getIgs(), sources, validationEngineParameters.isRecursive(), validationEngineParameters.isInferFhirVersion());
                validationEngineParameters.setSv(sv);
            }
            String engineDefinitions = definitions != null ? definitions : VersionUtilities.packageForVersion((String)validationEngineParameters.getSv()) + "#" + VersionUtilities.getCurrentVersion((String)validationEngineParameters.getSv());
            ValidationEngine validationEngine = this.getValidationEngineFromParameters(validationEngineParameters, defaultInstanceValidatorParameters, engineDefinitions, tt);
            sessionId = this.sessionCache.cacheSession(validationEngine);
            log.info("Cached new session. Cache size = " + this.sessionCache.getSessionIds().size());
        } else {
            log.info("Cached session exists for session id " + sessionId + ", returning stored validator session id. Cache size = " + this.sessionCache.getSessionIds().size());
        }
        return sessionId;
    }

    private ValidationEngine getValidationEngineFromParameters(ValidationEngineParameters validationEngineParameters, InstanceValidatorParameters defaultInstanceValidatorParameters, String definitions, TimeTracker tt) throws Exception {
        ValidationEngine validationEngine;
        if (validationEngineParameters.getBaseEngine() != null && this.hasBaseEngineForKey(validationEngineParameters.getBaseEngine())) {
            validationEngine = new ValidationEngine(this.getBaseEngine(validationEngineParameters.getBaseEngine()));
        } else {
            if (definitions == null) {
                throw new IllegalArgumentException("Cannot create a validator engine (definitions == null)");
            }
            validationEngine = this.buildValidationEngine(validationEngineParameters, defaultInstanceValidatorParameters, definitions, tt);
        }
        return validationEngine;
    }

    protected ValidationEngine.ValidationEngineBuilder getValidationEngineBuilder() {
        return new ValidationEngine.ValidationEngineBuilder();
    }

    @Nonnull
    protected ValidationEngine buildValidationEngine(ValidationEngineParameters validationEngineParameters, InstanceValidatorParameters defaultInstanceValidatorParameters, String definitions, TimeTracker timeTracker) throws IOException, URISyntaxException {
        log.info("  Loading FHIR v" + validationEngineParameters.getSv() + " from " + definitions);
        InstanceValidatorParameters instanceValidatorParameters = defaultInstanceValidatorParameters == null ? new InstanceValidatorParameters() : defaultInstanceValidatorParameters;
        ValidationEngine validationEngine = this.getValidationEngineBuilder().withDefaultInstanceValidatorParameters(new InstanceValidatorParameters(instanceValidatorParameters)).withVersion(validationEngineParameters.getSv()).withTimeTracker(timeTracker).withUserAgent(Common.getValidatorUserAgent()).withThoVersion("6.2.0").withExtensionsVersion("5.2.0").fromSource(definitions);
        FhirPublication ver = FhirPublication.fromCode((String)validationEngineParameters.getSv());
        log.info("  Loaded FHIR - " + validationEngine.getContext().countAllCaches() + " resources (" + timeTracker.milestone() + ")");
        String lineStart = "  Terminology server " + validationEngineParameters.getTxServer();
        String txver = validationEngine.setTerminologyServer(validationEngineParameters.getTxServer(), validationEngineParameters.getTxLog(), ver, !validationEngineParameters.getNoEcosystem());
        log.info(lineStart + " - Version " + txver + " (" + timeTracker.milestone() + ")");
        validationEngine.setDebug(validationEngineParameters.isDoDebug());
        validationEngine.getContext().setLogger((ILoggingService)new Slf4JLoggingService(log));
        this.loadIgsAndExtensions(validationEngine, validationEngineParameters.getIgs(), validationEngineParameters.isRecursive());
        if (validationEngineParameters.getTxCache() != null) {
            TerminologyCache cache = new TerminologyCache(new Object(), validationEngineParameters.getTxCache());
            validationEngine.getContext().initTxCache(cache);
        }
        if (validationEngine.getContext().getTxCache() == null || validationEngine.getContext().getTxCache().getFolder() == null) {
            log.info("  No Terminology Cache");
        } else {
            log.info("  Terminology Cache at " + validationEngine.getContext().getTxCache().getFolder());
            if (validationEngineParameters.isClearTxCache()) {
                log.info("  Terminology Cache Entries Cleaned out");
                validationEngine.getContext().getTxCache().clear();
            }
        }
        validationEngine.setDoNative(validationEngineParameters.isDoNative());
        log.info("  Get set... ");
        validationEngine.getCertSources().addAll(validationEngineParameters.getCertSources());
        validationEngine.getMatchetypes().addAll(validationEngineParameters.getMatchetypes());
        validationEngine.setShowTimes(validationEngineParameters.isShowTimes());
        validationEngine.setLanguage(validationEngineParameters.getLang());
        validationEngine.setLocale(validationEngineParameters.getLocale());
        validationEngine.setSnomedExtension(validationEngineParameters.getSnomedCTCode());
        validationEngine.setNoExtensibleBindingMessages(validationEngineParameters.isNoExtensibleBindingMessages());
        validationEngine.setDisplayWarnings(validationEngineParameters.isDisplayWarnings());
        validationEngine.setAiService(validationEngineParameters.getAIService());
        ReferenceValidationPolicy refpol = ReferenceValidationPolicy.CHECK_VALID;
        if (!validationEngineParameters.isDisableDefaultResourceFetcher()) {
            StandAloneValidatorFetcher fetcher = new StandAloneValidatorFetcher(validationEngine.getPcm(), (IWorkerContext)validationEngine.getContext(), validationEngine);
            validationEngine.setFetcher(fetcher);
            validationEngine.getContext().setLocator((IWorkerContextManager.ICanonicalResourceLocator)fetcher);
            validationEngine.setPolicyAdvisor(fetcher);
            if (validationEngineParameters.isCheckReferences()) {
                fetcher.setReferencePolicy(ReferenceValidationPolicy.CHECK_VALID);
            } else {
                fetcher.setReferencePolicy(ReferenceValidationPolicy.IGNORE);
            }
            fetcher.setResolutionContext(validationEngineParameters.getResolutionContext());
        } else {
            DisabledValidationPolicyAdvisor fetcher = new DisabledValidationPolicyAdvisor();
            validationEngine.setPolicyAdvisor(fetcher);
            refpol = ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS;
        }
        if (validationEngineParameters.getAdvisorFile() != null) {
            if (validationEngineParameters.getAdvisorFile().endsWith(".json")) {
                validationEngine.getPolicyAdvisor().setPolicyAdvisor((IValidationPolicyAdvisor)new JsonDrivenPolicyAdvisor(validationEngine.getPolicyAdvisor().getPolicyAdvisor(), ManagedFileAccess.file((String)validationEngineParameters.getAdvisorFile())));
            } else {
                validationEngine.getPolicyAdvisor().setPolicyAdvisor((IValidationPolicyAdvisor)new TextDrivenPolicyAdvisor(validationEngine.getPolicyAdvisor().getPolicyAdvisor(), ManagedFileAccess.file((String)validationEngineParameters.getAdvisorFile())));
            }
        } else {
            validationEngine.getPolicyAdvisor().setPolicyAdvisor((IValidationPolicyAdvisor)new BasePolicyAdvisorForFullValidation(validationEngine.getPolicyAdvisor() == null ? refpol : validationEngine.getPolicyAdvisor().getReferencePolicy()));
        }
        TerminologyCache.setNoCaching((boolean)validationEngineParameters.isNoInternalCaching());
        validationEngine.prepare();
        log.info("  ...go! (" + timeTracker.milestone() + ")");
        return validationEngine;
    }

    protected void loadIgsAndExtensions(ValidationEngine validationEngine, List<String> igs, boolean isRecursive) throws IOException, URISyntaxException {
        IgLoader igLoader = new IgLoader(validationEngine.getPcm(), validationEngine.getContext(), validationEngine.getVersion(), validationEngine.isDebug());
        igLoader.loadIg(validationEngine.getIgs(), validationEngine.getBinaries(), "hl7.terminology", false);
        if (!VersionUtilities.isR5Ver((String)validationEngine.getContext().getVersion())) {
            igLoader.loadIg(validationEngine.getIgs(), validationEngine.getBinaries(), "hl7.fhir.uv.extensions", false);
        }
        for (String src : igs) {
            igLoader.loadIg(validationEngine.getIgs(), validationEngine.getBinaries(), src, isRecursive);
        }
        log.info("  Package Summary: " + validationEngine.getContext().loadedPackageSummary());
    }

    @Deprecated(since="2025-11-07")
    public String determineVersion(ValidationContext validationContext) throws IOException {
        return this.determineVersion(validationContext.getIgs(), validationContext.getSources(), validationContext.isRecursive(), validationContext.isInferFhirVersion());
    }

    public String determineVersion(List<String> igs, List<String> sources, boolean isRecursive, boolean isInferFhirVersion) throws IOException {
        if (!isInferFhirVersion) {
            return "5.0";
        }
        log.info("Scanning for versions (no -version parameter):");
        VersionSourceInformation versions = this.scanForVersions(igs, sources, isRecursive);
        for (String s : versions.getReport()) {
            if (s.equals("(nothing found)")) continue;
            log.info("  " + s);
        }
        if (versions.isEmpty()) {
            log.info("  No Version Info found: Using Default version R5");
            return "5.0.0";
        }
        if (versions.size() == 1) {
            log.info("-> use version " + versions.version());
            return versions.version();
        }
        throw new IllegalArgumentException("-> Multiple versions found. Specify a particular version using the -version parameter");
    }

    @Deprecated(since="2025-11-05")
    public void generateSpreadsheet(ValidationContext validationContext, ValidationEngine validator) throws Exception {
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.generateSpreadsheet(validator, validationEngineParameters.getSv(), sources, outputParameters.getOutput());
    }

    public void generateSpreadsheet(ValidationEngine validationEngine, String version, List<String> sources, String output) throws Exception {
        CanonicalResource cr = validationEngine.loadCanonicalResource(sources.get(0), version);
        boolean ok = true;
        if (cr instanceof StructureDefinition) {
            new StructureDefinitionSpreadsheetGenerator((IWorkerContext)validationEngine.getContext(), false, false).renderStructureDefinition((StructureDefinition)cr, false).finish((OutputStream)ManagedFileAccess.outStream((String)output));
        } else if (cr instanceof CodeSystem) {
            new CodeSystemSpreadsheetGenerator((IWorkerContext)validationEngine.getContext()).renderCodeSystem((CodeSystem)cr).finish((OutputStream)ManagedFileAccess.outStream((String)output));
        } else if (cr instanceof ValueSet) {
            new ValueSetSpreadsheetGenerator((IWorkerContext)validationEngine.getContext()).renderValueSet((ValueSet)cr).finish((OutputStream)ManagedFileAccess.outStream((String)output));
        } else if (cr instanceof ConceptMap) {
            new ConceptMapSpreadsheetGenerator((IWorkerContext)validationEngine.getContext()).renderConceptMap((ConceptMap)cr).finish((OutputStream)ManagedFileAccess.outStream((String)output));
        } else {
            ok = false;
            log.info(" ...Unable to generate spreadsheet for " + sources.get(0) + ": no way to generate a spreadsheet for a " + cr.fhirType());
        }
        if (ok) {
            log.info(" ...generated spreadsheet successfully");
        }
    }

    @Deprecated(since="2025-11-05")
    public void transformLang(ValidationContext validationContext, ValidationEngine validationEngine) throws IOException {
        TransformLangParameters transformLangParameters = ValidationContextUtilities.getTransformLangParameters(validationContext);
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        List<String> sources = validationContext.getSources();
        this.transformLang(validationEngine, new org.hl7.fhir.validation.service.TransformLangParameters(transformLangParameters.getLangTransform(), transformLangParameters.getInputs(), transformLangParameters.getSrcLang(), transformLangParameters.getTgtLang(), sources, outputParameters.getOutput()));
    }

    public void transformLang(ValidationEngine validationEngine, org.hl7.fhir.validation.service.TransformLangParameters transformLangParameters) throws IOException {
        switch (transformLangParameters.langTransform()) {
            case "extract": {
                this.transformLangExtract(validationEngine, transformLangParameters.srcLang(), transformLangParameters.tgtLang(), transformLangParameters.sources(), transformLangParameters.output());
                break;
            }
            case "inject": {
                this.transformLangInject(validationEngine, transformLangParameters.inputs(), transformLangParameters.sources(), transformLangParameters.output());
                break;
            }
            default: {
                log.info(" ...Unknown lang transform mode " + transformLangParameters.langTransform());
            }
        }
    }

    private void transformLangExtract(ValidationEngine validator, String srcLang, String tgtLang, List<String> sources, String output) throws IOException {
        FileUtilities.createDirectory((String)output);
        PoGetTextProducer po = new PoGetTextProducer(output, ".", false);
        XLIFFProducer xliff = new XLIFFProducer(output, ".", false);
        JsonLangFileProducer jl = new JsonLangFileProducer(output, ".", false);
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        ValidatorUtils.parseSources(sources, refs, validator.getContext());
        for (ValidatorUtils.SourceFile ref : refs) {
            log.info("  Extract Translations from " + String.valueOf(ref));
            Content cnt = validator.getIgLoader().loadContent(ref.getRef(), "translate", false, true);
            Element e = Manager.parseSingle((IWorkerContext)validator.getContext(), (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
            LanguageFileProducer.LanguageProducerSession ps = po.startSession(e.fhirType() + "-" + e.getIdBase(), srcLang);
            LanguageFileProducer.LanguageProducerLanguageSession psl = ps.forLang(tgtLang);
            new LanguageUtils((IWorkerContext)validator.getContext()).generateTranslations(e, psl);
            psl.finish();
            ps.finish();
            ps = xliff.startSession(e.fhirType() + "-" + e.getIdBase(), srcLang);
            psl = ps.forLang(tgtLang);
            new LanguageUtils((IWorkerContext)validator.getContext()).generateTranslations(e, psl);
            psl.finish();
            ps.finish();
            ps = jl.startSession(e.fhirType() + "-" + e.getIdBase(), srcLang);
            psl = ps.forLang(tgtLang);
            new LanguageUtils((IWorkerContext)validator.getContext()).generateTranslations(e, psl);
            psl.finish();
            ps.finish();
        }
        log.info("Done - produced " + (po.fileCount() + xliff.fileCount()) + " files in " + output);
    }

    private void transformLangInject(ValidationEngine validator, List<String> inputs, List<String> sources, String output) throws IOException {
        FileUtilities.createDirectory((String)output);
        ArrayList<LanguageFileProducer.TranslationUnit> translations = new ArrayList<LanguageFileProducer.TranslationUnit>();
        for (String input : inputs) {
            this.loadTranslationSource(translations, input);
        }
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        ValidatorUtils.parseSources(sources, refs, validator.getContext());
        int t = 0;
        for (ValidatorUtils.SourceFile ref : refs) {
            log.info("  Inject Translations into " + String.valueOf(ref));
            Content cnt = validator.getIgLoader().loadContent(ref.getRef(), "translate", false, true);
            Element e = Manager.parseSingle((IWorkerContext)validator.getContext(), (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
            t += new LanguageUtils((IWorkerContext)validator.getContext()).importFromTranslations(e, translations);
            Manager.compose((IWorkerContext)validator.getContext(), (Element)e, (OutputStream)ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{output, ManagedFileAccess.file((String)ref.getRef()).getName()})), (Manager.FhirFormat)cnt.getCntType(), (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
        }
        log.info("Done - imported " + t + " translations into " + refs.size() + " in " + output);
    }

    private void loadTranslationSource(List<LanguageFileProducer.TranslationUnit> translations, String input) throws IOException {
        File f = ManagedFileAccess.file((String)input);
        if (f.exists()) {
            if (f.isDirectory()) {
                for (File fd : f.listFiles()) {
                    this.loadTranslationSource(translations, fd.getAbsolutePath());
                }
            } else if (f.getName().endsWith(".po")) {
                try {
                    translations.addAll(new PoGetTextProducer().loadSource((InputStream)ManagedFileAccess.inStream((File)f)));
                }
                catch (Exception e) {
                    log.info("Error reading PO File " + f.getAbsolutePath() + ": " + e.getMessage());
                }
            } else if (f.getName().endsWith(".xliff")) {
                try {
                    translations.addAll(new XLIFFProducer().loadSource((InputStream)ManagedFileAccess.inStream((File)f)));
                }
                catch (Exception e) {
                    log.info("Error reading XLIFF File " + f.getAbsolutePath() + ": " + e.getMessage());
                }
            } else {
                try {
                    translations.addAll(new PoGetTextProducer().loadSource((InputStream)ManagedFileAccess.inStream((File)f)));
                }
                catch (Exception e) {
                    try {
                        translations.addAll(new XLIFFProducer().loadSource((InputStream)ManagedFileAccess.inStream((File)f)));
                    }
                    catch (Exception e2) {
                        log.info("Error reading File " + f.getAbsolutePath() + " as XLIFF: " + e2.getMessage());
                        log.info("Error reading File " + f.getAbsolutePath() + " as PO: " + e.getMessage());
                    }
                }
            }
        } else {
            log.info("Input not found: " + input);
        }
    }

    @Deprecated(since="2025-09-19")
    public void install(ValidationContext validationContext, ValidationEngine validator) throws FHIRException, IOException {
        this.install(validationContext.getIgs(), validator);
    }

    public void install(List<String> igs, ValidationEngine validator) throws FHIRException, IOException {
        this.installedPackageCount = 0;
        this.generatedSnapshotCount = 0;
        log.info("Generating Snapshots");
        for (String ig : igs) {
            this.installIG(validator, ig);
        }
        log.info("Installed/Processed " + this.installedPackageCount + " packages, generated " + this.generatedSnapshotCount + " snapshots");
    }

    private void installIG(ValidationEngine validationEngine, String ig) throws FHIRException, IOException {
        validationEngine.loadPackage(ig, null);
        NpmPackage npm = validationEngine.getPcm().loadPackage(ig);
        if (!npm.isCore()) {
            for (String dependency : npm.dependencies()) {
                this.installIG(validationEngine, dependency);
            }
            log.info("Processing " + ig);
            ++this.installedPackageCount;
            for (String resourceName : npm.listResources(new String[]{"StructureDefinition"})) {
                String filename = npm.getFilePath(resourceName);
                Resource resource = validationEngine.loadResource(FileUtilities.fileToBytes((String)filename), filename);
                if (!(resource instanceof StructureDefinition)) {
                    throw new FHIRException("Require a StructureDefinition for generating a snapshot");
                }
                StructureDefinition structureDefinition = (StructureDefinition)resource;
                if (structureDefinition.hasSnapshot()) continue;
                StructureDefinition baseDefinition = (StructureDefinition)validationEngine.getContext().fetchResource(StructureDefinition.class, structureDefinition.getBaseDefinition());
                ++this.generatedSnapshotCount;
                new ProfileUtilities((IWorkerContext)validationEngine.getContext(), new ArrayList(), null).setAutoFixSliceNames(true).generateSnapshot(baseDefinition, structureDefinition, structureDefinition.getUrl(), null, structureDefinition.getName());
                validationEngine.handleOutput((Resource)structureDefinition, filename, validationEngine.getVersion());
            }
        }
    }

    @Deprecated(since="2024-11-06")
    public void codeGen(ValidationContext validationContext, ValidationEngine validationEngine) throws IOException {
        ValidationEngineParameters validationEngineParameters = ValidationContextUtilities.getValidationEngineParameters(validationContext);
        InstanceValidatorParameters instanceValidatorParameters = ValidationContextUtilities.getInstanceValidatorParameters(validationContext);
        PackageNameParameters packageNameParameters = ValidationContextUtilities.getPackageNameParameters(validationContext);
        CodeGenParameters codeGenParameters = ValidationContextUtilities.getCodeGenParameters(validationContext);
        OutputParameters outputParameters = ValidationContextUtilities.getOutputParameters(validationContext);
        this.codeGen(validationEngine, new org.hl7.fhir.validation.service.CodeGenParameters(validationEngineParameters.getSv(), instanceValidatorParameters.getProfiles(), codeGenParameters.getOptions(), packageNameParameters.getPackageName(), outputParameters.getOutput()));
    }

    public void codeGen(ValidationEngine validationEngine, org.hl7.fhir.validation.service.CodeGenParameters codeGenParameters) throws IOException {
        boolean ok = true;
        if (codeGenParameters.profiles().isEmpty()) {
            log.info("Must specify at least one profile to generate code for with -profile or -profiles ");
            ok = false;
        }
        if (codeGenParameters.packageName() == null) {
            log.info("Must provide a Java package name (-package-name)");
            ok = false;
        }
        if (codeGenParameters.version() == null) {
            log.info("Must specify a version (-version)");
            ok = false;
        } else if (!VersionUtilities.isR4Ver((String)codeGenParameters.version()) && !VersionUtilities.isR5Ver((String)codeGenParameters.version())) {
            log.info("Only versions 4 and 5 are supported (-version)");
            ok = false;
        }
        if (codeGenParameters.output() == null) {
            log.info("Must provide an output directory (-output)");
            ok = false;
        }
        FileUtilities.createDirectory((String)codeGenParameters.output());
        if (ok) {
            PECodeGenerator gen = new PECodeGenerator((IWorkerContext)validationEngine.getContext());
            gen.setFolder(codeGenParameters.output());
            gen.setExtensionPolicy(PECodeGenerator.ExtensionPolicy.Complexes);
            gen.setNarrative(codeGenParameters.options().contains("narrative"));
            gen.setMeta(codeGenParameters.options().contains("meta"));
            gen.setLanguage(Locale.getDefault().toLanguageTag());
            gen.setContained(codeGenParameters.options().contains("contained"));
            gen.setKeyElementsOnly(!codeGenParameters.options().contains("all-elements"));
            gen.setGenDate(new SimpleDateFormat().format(new Date()));
            gen.setPkgName(codeGenParameters.packageName());
            if (VersionUtilities.isR4Ver((String)codeGenParameters.version())) {
                gen.setVersion("r4");
            } else {
                gen.setVersion("r5");
            }
            for (String profile : codeGenParameters.profiles()) {
                if (profile.endsWith("*")) {
                    for (StructureDefinition sd : validationEngine.getContext().fetchResourcesByType(StructureDefinition.class)) {
                        if (!sd.getUrl().startsWith(profile.replace("*", ""))) continue;
                        gen.setCanonical(sd.getUrl());
                        log.info("Generating PE code for " + sd.getUrl());
                        String s = gen.execute();
                        log.info("Generated PE code for " + sd.getUrl() + ": " + s);
                    }
                    continue;
                }
                gen.setCanonical(profile);
                log.info("Generating PE code for " + profile);
                String s = gen.execute();
                log.info("Generated PE code for " + profile + ": " + s);
            }
            log.info("Done");
        }
    }

    @Deprecated(since="2025-11-05")
    public void instanceFactory(ValidationContext validationContext, ValidationEngine validationEngine) throws IOException {
        InstanceFactoryParameters instanceFactoryParameters = ValidationContextUtilities.getInstanceFactoryParameters(validationContext);
        this.instanceFactory(validationEngine, instanceFactoryParameters.getSource());
    }

    public void instanceFactory(ValidationEngine validationEngine, String source) throws IOException {
        boolean ok = true;
        if (source == null) {
            log.info("Must specify a source (-version)");
            ok = false;
        } else if (!ManagedFileAccess.file((String)source).exists()) {
            log.info("Factory source '" + source + "' not found");
            ok = false;
        }
        if (ok) {
            log.info("Preparing to execute");
            FHIRPathEngine fpe = new FHIRPathEngine((IWorkerContext)validationEngine.getContext());
            TestDataHostServices hs = new TestDataHostServices(validationEngine.getContext(), new DateTimeType(new Date()), new StringType(VersionUtilities.getSpecUrl((String)validationEngine.getContext().getVersion())));
            hs.registerFunction((FHIRPathFunctionDefinition)new GlobalObject.GlobalObjectRandomFunction());
            hs.registerFunction((FHIRPathFunctionDefinition)new BaseTableWrapper.TableColumnFunction());
            hs.registerFunction((FHIRPathFunctionDefinition)new BaseTableWrapper.TableDateColumnFunction());
            hs.registerFunction((FHIRPathFunctionDefinition)new TestDataFactory.CellLookupFunction());
            hs.registerFunction((FHIRPathFunctionDefinition)new TestDataFactory.TableLookupFunction());
            fpe.setHostServices((IHostApplicationServices)hs);
            LiquidEngine liquid = new LiquidEngine((IWorkerContext)validationEngine.getContext(), (IHostApplicationServices)hs);
            String path = FileUtilities.getDirectoryForFile((String)source);
            String logPath = Utilities.path((String[])new String[]{path, "log"});
            FileUtilities.createDirectory((String)logPath);
            JsonObject json = JsonParser.parseObjectFromFile((String)source);
            for (JsonObject fact : json.forceArray("factories").asJsonObjects()) {
                TestDataFactory tdf = new TestDataFactory((IWorkerContext)validationEngine.getContext(), fact, liquid, fpe, "http://hl7.org/fhir/test", path, logPath, new HashMap(), new Locale("us"));
                tdf.setTesting(true);
                log.info("Execute Test Data Factory '" + tdf.getName() + "'. Log in " + Utilities.path((String[])new String[]{logPath, tdf.statedLog()}));
                tdf.execute();
            }
            log.info("Done");
        }
    }
}

