/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DigitalSignatureSupport {
    public static SignedInfo buildSignInfo(X509Certificate cert, byte[] signableSource, String canon, Instant instant, String name, String purpose, String purposeDesc) throws NoSuchAlgorithmException, CertificateEncodingException, UnsupportedEncodingException, InvalidCanonicalizerException, CanonicalizationException, ParserConfigurationException, SAXException, IOException {
        byte[] xc = DigitalSignatureSupport.canonicalizeXml(new String(signableSource, StandardCharsets.UTF_8), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String digestB64 = DigitalSignatureSupport.getDigest(xc, name + "-source");
        String algorithm = cert.getPublicKey().getAlgorithm();
        String signatureMethod = "RSA".equals(algorithm) ? "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256" : "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
        StringBuilder signedInfo = new StringBuilder();
        signedInfo.append("  <SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n");
        signedInfo.append("    <CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"/>\n");
        signedInfo.append("    <SignatureMethod Algorithm=\"").append(signatureMethod).append("\"/>\n");
        signedInfo.append("    <Reference URI=\"#\">\n");
        signedInfo.append("      <Transforms>\n");
        signedInfo.append("        <Transform Algorithm=\"" + canon + "\"/>\n");
        signedInfo.append("      </Transforms>\n");
        signedInfo.append("      <DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>\n");
        signedInfo.append("      <DigestValue>").append(digestB64).append("</DigestValue>\n");
        signedInfo.append("    </Reference>\n");
        if (instant != null) {
            StringBuilder xades = new StringBuilder();
            xades.append("<x:SignedProperties xmlns:x=\"http://uri.etsi.org/01903/v1.3.2#\" Id=\"SignedProperties\">");
            xades.append("<x:SignedSignatureProperties>");
            xades.append("<x:SigningTime>" + DateTimeFormatter.ISO_INSTANT.format(instant) + "</x:SigningTime>");
            xades.append("</x:SignedSignatureProperties>");
            xades.append(DigitalSignatureSupport.cmmId(purpose, purposeDesc));
            xades.append("</x:SignedProperties>");
            byte[] xxc = DigitalSignatureSupport.canonicalizeXml(xades.toString(), "http://www.w3.org/2001/10/xml-exc-c14n#");
            String xadesB64 = DigitalSignatureSupport.getDigest(xxc, name + "-xades");
            signedInfo.append("    <Reference Type=\"http://uri.etsi.org/01903#SignedProperties\" URI=\"#SignedProperties\">\n");
            signedInfo.append("      <DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>\n");
            signedInfo.append("      <DigestValue>").append(xadesB64).append("</DigestValue>\n");
            signedInfo.append("    </Reference>\n");
        }
        signedInfo.append("  </SignedInfo>\n");
        byte[] signedInfoBytes = DigitalSignatureSupport.canonicalizeXml(signedInfo.toString(), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        return new SignedInfo(signedInfo.toString(), signedInfoBytes);
    }

    public static String cmmId(String purpose, String purposeDesc) {
        if (purpose == null) {
            return "";
        }
        String xp = purposeDesc == null ? "" : "<x:Description>" + Utilities.escapeXml((String)purposeDesc) + "</x:Description>";
        return "<x:SignedDataObjectProperties><x:CommitmentTypeIndication><x:CommitmentTypeId><x:Identifier>" + Utilities.escapeXml((String)purpose) + "</x:Identifier>" + xp + "</x:CommitmentTypeId></x:CommitmentTypeIndication></x:SignedDataObjectProperties>";
    }

    public static String getDigest(byte[] xc, String name) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] digestValue = sha256.digest(xc);
        String digestB64 = Base64.getEncoder().encodeToString(digestValue);
        return digestB64;
    }

    public static byte[] canonicalizeXml(String xmlString, String canonMethod) throws ParserConfigurationException, UnsupportedEncodingException, SAXException, IOException, InvalidCanonicalizerException, CanonicalizationException {
        if (!Init.isInitialized()) {
            Init.init();
        }
        DocumentBuilderFactory dbf = XMLUtil.newXXEProtectedDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)canonMethod);
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        canonicalizer.canonicalizeSubtree((Node)doc.getDocumentElement(), (OutputStream)ba);
        ba.close();
        return ba.toByteArray();
    }

    public static byte[] canonicalizeXml(Element xml, String canonMethod) throws ParserConfigurationException, UnsupportedEncodingException, SAXException, IOException, InvalidCanonicalizerException, CanonicalizationException {
        if (!Init.isInitialized()) {
            Init.init();
        }
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)canonMethod);
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        canonicalizer.canonicalizeSubtree((Node)xml, (OutputStream)ba);
        ba.close();
        return ba.toByteArray();
    }

    public static SignedInfo buildSignInfoXades(X509Certificate cert, byte[] signableSource, String canon, byte[] xades, String name, String purpose, String purposeDesc) throws CertificateEncodingException, NoSuchAlgorithmException, UnsupportedEncodingException, InvalidCanonicalizerException, CanonicalizationException, ParserConfigurationException, SAXException, IOException, TransformerException {
        if (xades == null) {
            return DigitalSignatureSupport.buildSignInfo(cert, signableSource, canon, null, name, purpose, purposeDesc);
        }
        byte[] xc = DigitalSignatureSupport.canonicalizeXml(new String(signableSource, StandardCharsets.UTF_8), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String digestB64 = DigitalSignatureSupport.getDigest(xc, name + "-source");
        String algorithm = cert.getPublicKey().getAlgorithm();
        String signatureMethod = "RSA".equals(algorithm) ? "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256" : "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
        StringBuilder signedInfo = new StringBuilder();
        signedInfo.append("  <SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n");
        signedInfo.append("    <CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"/>\n");
        signedInfo.append("    <SignatureMethod Algorithm=\"").append(signatureMethod).append("\"/>\n");
        signedInfo.append("    <Reference URI=\"#\">\n");
        signedInfo.append("      <Transforms>\n");
        signedInfo.append("        <Transform Algorithm=\"" + canon + "\"/>\n");
        signedInfo.append("      </Transforms>\n");
        signedInfo.append("      <DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>\n");
        signedInfo.append("      <DigestValue>").append(digestB64).append("</DigestValue>\n");
        signedInfo.append("    </Reference>\n");
        String xadesB64 = DigitalSignatureSupport.getDigest(xades, name + "-xades");
        signedInfo.append("    <Reference Type=\"http://uri.etsi.org/01903#SignedProperties\" URI=\"#SignedProperties\">\n");
        signedInfo.append("      <DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"/>\n");
        signedInfo.append("      <DigestValue>").append(xadesB64).append("</DigestValue>\n");
        signedInfo.append("    </Reference>\n");
        signedInfo.append("  </SignedInfo>\n");
        byte[] signedInfoBytes = DigitalSignatureSupport.canonicalizeXml(signedInfo.toString(), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        return new SignedInfo(signedInfo.toString(), signedInfoBytes);
    }

    public static Set<String> getNamesFromCertificate(X509Certificate cert, boolean debug) {
        HashSet<String> names;
        block10: {
            names = new HashSet<String>();
            names.add(cert.getSubjectX500Principal().getName());
            names.add(cert.getSubjectX500Principal().getName("RFC1779"));
            names.add(cert.getSubjectX500Principal().getName("RFC2253"));
            names.add(cert.getSubjectX500Principal().getName("CANONICAL"));
            try {
                if (cert.getSubjectAlternativeNames() != null) {
                    for (List<?> t : cert.getSubjectAlternativeNames()) {
                        int valueType = -1;
                        for (Object tt : t) {
                            if (tt instanceof Integer) {
                                valueType = (Integer)tt;
                            }
                            if (tt instanceof String && (valueType == 0 || valueType == 6)) {
                                names.add(tt.toString());
                            }
                            if (!(tt instanceof byte[])) continue;
                            try {
                                ByteArrayInputStream input = new ByteArrayInputStream((byte[])tt);
                                input.read();
                                input.read();
                                input.read();
                                int oidLength = input.read();
                                byte[] oidBytes = new byte[oidLength];
                                input.read(oidBytes);
                                String oid = DigitalSignatureSupport.parseOID(oidBytes);
                                names.add(oid.trim());
                                input.read();
                                input.read();
                                int nextByte = input.read() & 0xFF;
                                if (nextByte == 160) {
                                    input.read();
                                    nextByte = input.read() & 0xFF;
                                }
                                int stringLength = input.read();
                                byte[] stringBytes = new byte[stringLength];
                                input.read(stringBytes);
                                String value = new String(stringBytes, "UTF-8");
                                names.add(value.trim());
                            }
                            catch (Exception e) {
                                if (!debug) continue;
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!debug) break block10;
                e.printStackTrace();
            }
        }
        return names;
    }

    private static String parseOID(byte[] oidBytes) {
        if (oidBytes.length == 0) {
            return "";
        }
        ArrayList<Long> components = new ArrayList<Long>();
        int firstByte = oidBytes[0] & 0xFF;
        components.add(Long.valueOf(firstByte / 40));
        components.add(Long.valueOf(firstByte % 40));
        long value = 0L;
        for (int i = 1; i < oidBytes.length; ++i) {
            int b = oidBytes[i] & 0xFF;
            value = value << 7 | (long)(b & 0x7F);
            if ((b & 0x80) != 0) continue;
            components.add(value);
            value = 0L;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < components.size(); ++i) {
            if (i > 0) {
                result.append(".");
            }
            result.append(components.get(i));
        }
        return result.toString();
    }

    public static class SignedInfo {
        private String source;
        private byte[] signable;

        public SignedInfo(String source, byte[] signable) {
            this.source = source;
            this.signable = signable;
        }

        public String getSource() {
            return this.source;
        }

        public byte[] getSignable() {
            return this.signable;
        }
    }

    public static class DigitalSignatureWrapper {
        private Element doc;
        private Element contentReference;
        private Element xadesReference;

        public DigitalSignatureWrapper(Element doc) {
            this.doc = doc;
        }

        public List<Element> getDigSigReferences() {
            Element sigInfo = XMLUtil.getNamedChild((Element)this.doc, (String)"SignedInfo");
            return XMLUtil.getNamedChildren((Element)sigInfo, (String)"Reference");
        }

        public String getDigSigSigned() {
            return XMLUtil.getNamedChildText((Element)this.doc, (String)"SignedBytes");
        }

        public String getDigSigAlg() {
            Element sigInfo = XMLUtil.getNamedChild((Element)this.doc, (String)"SignedInfo");
            return XMLUtil.getNamedChildAttribute((Element)sigInfo, (String)"SignatureMethod", (String)"Algorithm");
        }

        public String getDigSigSigValue() {
            return XMLUtil.getNamedChildText((Element)this.doc, (String)"SignatureValue");
        }

        public Element getDigSigX509() {
            Element keyInfo = XMLUtil.getNamedChild((Element)this.doc, (String)"KeyInfo");
            Element x509Data = XMLUtil.getNamedChild((Element)keyInfo, (String)"X509Data");
            return XMLUtil.getNamedChild((Element)x509Data, (String)"X509Certificate");
        }

        public String getDigSigCanonicalization() {
            Element sigInfo = XMLUtil.getNamedChild((Element)this.doc, (String)"SignedInfo");
            Element ref = XMLUtil.getNamedChild((Element)sigInfo, (String)"Reference");
            Element xforms = XMLUtil.getNamedChild((Element)ref, (String)"Transforms");
            return XMLUtil.getNamedChildAttribute((Element)xforms, (String)"Transform", (String)"Algorithm");
        }

        public String getDigSigTime() {
            Element object = XMLUtil.getNamedChild((Element)this.doc, (String)"Object");
            Element qualifyingProperties = XMLUtil.getNamedChild((Element)object, (String)"QualifyingProperties");
            Element signedProperties = XMLUtil.getNamedChild((Element)qualifyingProperties, (String)"SignedProperties");
            Element signedSignatureProperties = XMLUtil.getNamedChild((Element)signedProperties, (String)"SignedSignatureProperties");
            Element signingTime = XMLUtil.getNamedChild((Element)signedSignatureProperties, (String)"SigningTime");
            if (signingTime != null) {
                return signingTime.getTextContent();
            }
            Element signatureProperties = XMLUtil.getNamedChild((Element)object, (String)"SignatureProperties");
            Element signatureProperty = XMLUtil.getNamedChild((Element)signatureProperties, (String)"SignatureProperty");
            return XMLUtil.getNamedChildText((Element)signatureProperty, (String)"SigningTime");
        }

        public Element getContentReference() {
            return this.contentReference;
        }

        public void setContentReference(Element contentReference) {
            this.contentReference = contentReference;
        }

        public Element getXadesReference() {
            return this.xadesReference;
        }

        public void setXadesReference(Element xadesReference) {
            this.xadesReference = xadesReference;
        }

        public Element getXadesSignable() {
            Element object = XMLUtil.getNamedChild((Element)this.doc, (String)"Object");
            Element qualifyingProperties = XMLUtil.getNamedChild((Element)object, (String)"QualifyingProperties");
            return XMLUtil.getNamedChild((Element)qualifyingProperties, (String)"SignedProperties");
        }

        public String getPurpose() {
            Element object = XMLUtil.getNamedChild((Element)this.doc, (String)"Object");
            Element qualifyingProperties = XMLUtil.getNamedChild((Element)object, (String)"QualifyingProperties");
            Element signedProperties = XMLUtil.getNamedChild((Element)qualifyingProperties, (String)"SignedProperties");
            Element signedSignatureProperties = XMLUtil.getNamedChild((Element)signedProperties, (String)"SignedDataObjectProperties");
            Element signedDataObjectProperties = XMLUtil.getNamedChild((Element)signedSignatureProperties, (String)"CommitmentTypeIndication");
            Element commitmentTypeId = XMLUtil.getNamedChild((Element)signedDataObjectProperties, (String)"CommitmentTypeId");
            if (commitmentTypeId != null) {
                return XMLUtil.getNamedChildText((Element)commitmentTypeId, (String)"Identifier");
            }
            return null;
        }

        public String getPurposeDesc() {
            Element object = XMLUtil.getNamedChild((Element)this.doc, (String)"Object");
            Element qualifyingProperties = XMLUtil.getNamedChild((Element)object, (String)"QualifyingProperties");
            Element signedProperties = XMLUtil.getNamedChild((Element)qualifyingProperties, (String)"SignedProperties");
            Element signedSignatureProperties = XMLUtil.getNamedChild((Element)signedProperties, (String)"SignedDataObjectProperties");
            Element signedDataObjectProperties = XMLUtil.getNamedChild((Element)signedSignatureProperties, (String)"CommitmentTypeIndication");
            Element commitmentTypeId = XMLUtil.getNamedChild((Element)signedDataObjectProperties, (String)"CommitmentTypeId");
            if (commitmentTypeId != null) {
                return XMLUtil.getNamedChildText((Element)commitmentTypeId, (String)"Description");
            }
            return null;
        }
    }
}

