/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hl7.fhir.r5.elementmodel.Manager;

public class RePackageParameters {
    @JsonProperty(value="packages")
    @SerializedName(value="packages")
    private List<String> packages = new ArrayList<String>();
    @JsonProperty(value="modeParams")
    @SerializedName(value="modeParams")
    private Set<String> modeParams = new HashSet<String>();
    @JsonProperty(value="format")
    @SerializedName(value="format")
    private Manager.FhirFormat format;

    @SerializedName(value="packages")
    @JsonProperty(value="packages")
    public List<String> getPackages() {
        return this.packages;
    }

    @SerializedName(value="packages")
    @JsonProperty(value="packages")
    public RePackageParameters setPackages(List<String> packages) {
        this.packages = packages;
        return this;
    }

    public RePackageParameters addPackage(String ig) {
        if (this.packages == null) {
            this.packages = new ArrayList<String>();
        }
        this.packages.add(ig);
        return this;
    }

    @SerializedName(value="modeParams")
    @JsonProperty(value="modeParams")
    public Set<String> getModeParams() {
        return this.modeParams;
    }

    @SerializedName(value="modeParams")
    @JsonProperty(value="modeParams")
    public RePackageParameters setModeParams(Set<String> modeParams) {
        this.modeParams = modeParams;
        return this;
    }

    public RePackageParameters addModeParam(String modeParam) {
        this.modeParams.add(modeParam);
        return this;
    }

    @SerializedName(value="format")
    @JsonProperty(value="format")
    public Manager.FhirFormat getFormat() {
        return this.format;
    }

    @SerializedName(value="format")
    @JsonProperty(value="format")
    public RePackageParameters setFormat(Manager.FhirFormat format) {
        this.format = format;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RePackageParameters that = (RePackageParameters)o;
        return Objects.equals(this.packages, that.packages) && Objects.equals(this.modeParams, that.modeParams) && Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.packages, this.modeParams, this.format);
    }

    public String toString() {
        return "RePackageParameters{packages=" + String.valueOf(this.packages) + ", modeParams=" + String.valueOf(this.modeParams) + ", format=" + String.valueOf(this.format) + "}";
    }
}

