/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.fhir.ucum.UcumEssenceService;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.convertors.misc.IGR2ConvertorAdvisor5;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.formats.JsonParser;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.formats.XmlParser;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.utils.StructureMapUtilities;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.context.Slf4JLoggingService;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.extensions.ExtensionUtilities;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.formats.FormatUtilities;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.structuremap.ITransformerServices;
import org.hl7.fhir.r5.utils.validation.BundleValidationRule;
import org.hl7.fhir.r5.utils.validation.IMessagingServices;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.r5.utils.validation.constants.BindingKind;
import org.hl7.fhir.r5.utils.validation.constants.CheckDisplayOption;
import org.hl7.fhir.r5.utils.validation.constants.ContainedReferenceValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.IdStatus;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.ByteProvider;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.SIDUtilities;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.NpmPackageIndexBuilder;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.Content;
import org.hl7.fhir.validation.IgLoader;
import org.hl7.fhir.validation.SQLiteINpmPackageIndexBuilderDBImpl;
import org.hl7.fhir.validation.TransformSupportServices;
import org.hl7.fhir.validation.ValidationRecord;
import org.hl7.fhir.validation.ValidatorSettings;
import org.hl7.fhir.validation.ValidatorUtils;
import org.hl7.fhir.validation.VersionConvertor;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.MatchetypeValidator;
import org.hl7.fhir.validation.instance.advisor.BasePolicyAdvisorForFullValidation;
import org.hl7.fhir.validation.instance.utils.ValidationContext;
import org.hl7.fhir.validation.service.IPackageInstaller;
import org.hl7.fhir.validation.service.model.HtmlInMarkdownCheck;
import org.hl7.fhir.validation.service.model.InstanceValidatorParameters;
import org.hl7.fhir.validation.service.model.ValidatedFragments;
import org.hl7.fhir.validation.service.model.ValidationTime;
import org.hl7.fhir.validation.service.utils.ProfileLoader;
import org.hl7.fhir.validation.service.utils.QuestionnaireMode;
import org.hl7.fhir.validation.service.utils.SchemaValidator;
import org.hl7.fhir.validation.service.utils.ValidationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ValidationEngine
implements IValidatorResourceFetcher,
IValidationPolicyAdvisor,
IPackageInstaller,
IWorkerContextManager.IPackageLoadingTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationEngine.class);
    private SimpleWorkerContext context;
    private Map<String, ByteProvider> binaries = new HashMap<String, ByteProvider>();
    private boolean doNative;
    private boolean displayWarnings;
    private boolean logValidationProgress;
    private boolean anyExtensionsAllowed = false;
    private String version;
    private String language;
    private FilesystemPackageCacheManager pcm;
    private PrintWriter mapLog;
    private boolean debug = false;
    private IValidatorResourceFetcher fetcher;
    private IValidationPolicyAdvisor policyAdvisor;
    private IWorkerContextManager.ICanonicalResourceLocator locator;
    private boolean noExtensibleBindingMessages;
    private String aiService;
    private Locale locale;
    private List<ImplementationGuide> igs = new ArrayList<ImplementationGuide>();
    private List<String> extensionDomains = new ArrayList<String>();
    private List<String> certSources = new ArrayList<String>();
    private List<String> matchetypes = new ArrayList<String>();
    private boolean showTimes;
    private FHIRPathEngine fhirPathEngine;
    private IgLoader igLoader;
    @Nonnull
    private final InstanceValidatorParameters defaultInstanceValidatorParameters;
    private ContextUtilities cu = null;
    private Map<String, BaseValidator.ValidationControl> validationControl = new HashMap<String, BaseValidator.ValidationControl>();
    private final Map<String, Boolean> resolvedUrls = new HashMap<String, Boolean>();

    public ValidationEngine(ValidationEngine other) throws FHIRException, IOException {
        this.context = new SimpleWorkerContext(other.context);
        this.binaries.putAll(other.binaries);
        this.doNative = other.doNative;
        this.anyExtensionsAllowed = other.anyExtensionsAllowed;
        this.version = other.version;
        this.language = other.language;
        this.pcm = other.pcm;
        this.mapLog = other.mapLog;
        this.debug = other.debug;
        this.logValidationProgress = other.logValidationProgress;
        this.fetcher = other.fetcher;
        this.policyAdvisor = other.policyAdvisor;
        this.locator = other.locator;
        this.noExtensibleBindingMessages = other.noExtensibleBindingMessages;
        this.aiService = other.aiService;
        this.locale = other.locale;
        this.igs.addAll(other.igs);
        this.extensionDomains.addAll(other.extensionDomains);
        this.certSources.addAll(other.certSources);
        this.matchetypes.addAll(other.matchetypes);
        this.showTimes = other.showTimes;
        this.fhirPathEngine = other.fhirPathEngine;
        this.igLoader = other.igLoader;
        this.displayWarnings = other.displayWarnings;
        this.defaultInstanceValidatorParameters = new InstanceValidatorParameters(other.defaultInstanceValidatorParameters);
    }

    private ValidationEngine() {
        this.defaultInstanceValidatorParameters = new InstanceValidatorParameters();
    }

    private ValidationEngine(InstanceValidatorParameters instanceValidatorParameters) {
        this.defaultInstanceValidatorParameters = Objects.requireNonNullElseGet(instanceValidatorParameters, InstanceValidatorParameters::new);
    }

    private void loadCoreDefinitions(String src, boolean recursive, String terminologyCachePath, String userAgent, TimeTracker tt, ILoggingService loggingService) throws FHIRException, IOException {
        NpmPackage npm = this.getPcm().loadPackage(src, null);
        if (npm != null) {
            this.version = npm.fhirVersion();
            SimpleWorkerContext.SimpleWorkerContextBuilder contextBuilder = new SimpleWorkerContext.SimpleWorkerContextBuilder().withLoggingService(loggingService);
            if (terminologyCachePath != null) {
                contextBuilder = contextBuilder.withTerminologyCachePath(terminologyCachePath);
            }
            if (userAgent != null) {
                contextBuilder.withUserAgent(userAgent);
            }
            this.context = contextBuilder.fromPackage(npm, (IContextResourceLoader)ValidatorUtils.loaderForVersion(this.version), false);
        } else {
            Map<String, ByteProvider> source = this.igLoader.loadIgSource(src, recursive, true);
            if (this.version == null) {
                this.version = this.getVersionFromPack(source);
            }
            SimpleWorkerContext.SimpleWorkerContextBuilder contextBuilder = new SimpleWorkerContext.SimpleWorkerContextBuilder();
            if (terminologyCachePath != null) {
                contextBuilder = contextBuilder.withTerminologyCachePath(terminologyCachePath);
            }
            if (userAgent != null) {
                contextBuilder.withUserAgent(userAgent);
            }
            this.context = contextBuilder.fromDefinitions(source, (IContextResourceLoader)ValidatorUtils.loaderForVersion(this.version), new PackageInformation(src, this.version, new Date()));
            ValidatorUtils.grabNatives(this.getBinaries(), source, "http://hl7.org/fhir");
        }
        try {
            ClassLoader classLoader = ValidationEngine.class.getClassLoader();
            InputStream ue = classLoader.getResourceAsStream("ucum-essence.xml");
            this.context.setUcumService((UcumService)new UcumEssenceService(ue));
        }
        catch (Exception e) {
            throw new FHIRException("Error loading UCUM from embedded ucum-essence.xml: " + e.getMessage(), (Throwable)e);
        }
        this.initContext(tt);
    }

    protected void initContext(TimeTracker tt) throws IOException {
        this.context.setCanNoTS(true);
        this.context.setAllowLoadingDuplicates(true);
        this.context.setExpansionParameters(this.makeExpProfile());
        if (tt != null) {
            this.context.setClock(tt);
        }
        NpmPackage npmX = this.getPcm().loadPackage("hl7.fhir.xver-extensions", "0.1.0");
        this.context.loadFromPackage(npmX, null);
        this.fhirPathEngine = new FHIRPathEngine((IWorkerContext)this.context);
        this.fhirPathEngine.setAllowDoubleQuotes(false);
    }

    private String getVersionFromPack(Map<String, ByteProvider> source) throws FileNotFoundException, IOException {
        if (source.containsKey("version.info")) {
            IniFile vi = new IniFile((InputStream)new ByteArrayInputStream(this.removeBom(source.get("version.info").getBytes())));
            return vi.getStringProperty("FHIR", "version");
        }
        throw new Error("Missing version.info?");
    }

    private byte[] removeBom(byte[] bs) {
        if (bs.length > 3 && bs[0] == -17 && bs[1] == -69 && bs[2] == -65) {
            return Arrays.copyOfRange(bs, 3, bs.length);
        }
        return bs;
    }

    private Parameters makeExpProfile() {
        Parameters ep = new Parameters();
        ep.addParameter("profile-url", "http://hl7.org/fhir/ExpansionProfile/dc8fd4bc-091a-424a-8a3b-6198ef146891");
        return ep;
    }

    public String connectToTSServer(String url, String log, FhirPublication version, boolean useEcosystem) throws URISyntaxException, IOException, FHIRException {
        return this.connectToTSServer(url, log, null, version, useEcosystem);
    }

    public String connectToTSServer(String url, String log, String txCachePath, FhirPublication version, boolean useEcosystem) throws URISyntaxException, IOException, FHIRException {
        this.context.setTlogging(false);
        if (url == null) {
            this.context.setCanRunWithoutTerminology(true);
            this.context.setNoTerminologyServer(true);
            return "n/a: No Terminology Server";
        }
        try {
            TerminologyClientFactory factory = new TerminologyClientFactory(version);
            this.context.connectToTSServer((TerminologyClientManager.ITerminologyClientFactory)factory, url, this.context.getUserAgent(), log, useEcosystem);
            return "Connected to Terminology Server at " + url;
        }
        catch (Exception e) {
            if (this.context.isCanRunWithoutTerminology()) {
                return "n/a: Running without Terminology Server (error: " + e.getMessage() + ")";
            }
            throw e;
        }
    }

    public void loadProfile(String src) throws FHIRException, IOException {
        if (this.context.hasResource(StructureDefinition.class, src)) {
            return;
        }
        if (this.context.hasResource(ImplementationGuide.class, src)) {
            return;
        }
        try {
            byte[] source = ProfileLoader.loadProfileSource(src);
            Manager.FhirFormat fmt = FormatUtilities.determineFormat((byte[])source);
            Resource r = FormatUtilities.makeParser((Manager.FhirFormat)fmt).parse(source);
            this.context.cacheResource(r);
        }
        catch (Exception e) {
            throw new FHIRException("Error loading profile " + src + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public OperationOutcome validate(Manager.FhirFormat format, InputStream stream, List<String> profiles) throws FHIRException, IOException, EOperationOutcome {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        InstanceValidator validator = this.getValidator(format);
        validator.validate(null, messages, stream, format, this.asSdList(profiles));
        return ValidatorUtils.messagesToOutcome(messages, this.context, this.fhirPathEngine);
    }

    public List<StructureDefinition> asSdList(List<String> profiles) throws Error {
        ArrayList<StructureDefinition> list = new ArrayList<StructureDefinition>();
        if (profiles != null) {
            for (String p : profiles) {
                StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
                if (sd == null) {
                    throw new Error("Unable to resolve profile " + p);
                }
                list.add(sd);
            }
        }
        return list;
    }

    public OperationOutcome validate(String source, List<String> profiles, IValidationEngineLoader loader, boolean all) throws FHIRException, IOException, InterruptedException {
        ArrayList<String> l = new ArrayList<String>();
        ArrayList<ValidatorUtils.SourceFile> refs = new ArrayList<ValidatorUtils.SourceFile>();
        l.add(source);
        return (OperationOutcome)this.validate(l, profiles, refs, null, loader, all, 0, true);
    }

    public Resource validate(List<String> sources, List<String> profiles, List<ValidatorUtils.SourceFile> refs, List<ValidationRecord> record, IValidationEngineLoader loader, boolean all, int delay, boolean first) throws FHIRException, IOException, InterruptedException {
        boolean asBundle = ValidatorUtils.parseSources(sources, refs, this.context);
        Bundle results = new Bundle();
        results.setType(Bundle.BundleType.COLLECTION);
        boolean found = false;
        for (ValidatorUtils.SourceFile ref : refs) {
            if (!ref.isProcess()) continue;
            found = true;
        }
        if (!found) {
            return null;
        }
        if (!first && delay != 0) {
            Thread.sleep(delay);
        }
        for (ValidatorUtils.SourceFile ref : refs) {
            if (!ref.isProcess() && !all || ref.isKnownToBeMissing()) continue;
            ref.setCnt(this.igLoader.loadContent(ref.getRef(), "validate", false, first));
            if (loader == null || ref.getCnt() == null) continue;
            try {
                loader.load(ref.getCnt());
            }
            catch (Throwable t) {
                log.debug("Error during round 1 scanning: " + t.getMessage());
            }
        }
        for (ValidatorUtils.SourceFile ref : refs) {
            if (!ref.isProcess() && !all || ref.getCnt() == null) continue;
            TimeTracker.Session tts = this.context.clock().start("validation");
            this.context.clock().milestone();
            log.info("  Validate " + ref.getRef());
            try {
                OperationOutcome outcome = this.validate(ref.getRef(), ref.getCnt().getFocus(), ref.getCnt().getCntType(), profiles, record);
                ExtensionUtilities.addStringExtension((DomainResource)outcome, (String)"http://hl7.org/fhir/StructureDefinition/operationoutcome-file", (String)ref.getRef());
                log.info(" " + this.context.clock().milestone());
                results.addEntry().setResource((Resource)outcome);
                tts.end();
            }
            catch (Exception e) {
                log.error("Validation Infrastructure fail validating " + String.valueOf(ref) + ": " + e.getMessage());
                tts.end();
                throw new FHIRException((Throwable)e);
            }
            ref.setProcess(false);
        }
        if (asBundle) {
            return results;
        }
        return results.getEntryFirstRep().getResource();
    }

    public ValidatedFragments validateAsFragments(byte[] source, Manager.FhirFormat cntType, List<String> profiles, List<ValidationMessage> messages) throws FHIRException, IOException, EOperationOutcome {
        InstanceValidator validator = this.getValidator(cntType);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        return new ValidatedFragments(validator.validatedContent, ValidationTime.fromTimeTracker(validator.timeTracker));
    }

    public OperationOutcome validate(byte[] source, Manager.FhirFormat cntType, List<String> profiles, List<ValidationMessage> messages) throws FHIRException, IOException, EOperationOutcome {
        InstanceValidator validator = this.getValidator(cntType);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        return ValidatorUtils.messagesToOutcome(messages, this.context, this.fhirPathEngine);
    }

    public OperationOutcome validate(String location, ByteProvider source, Manager.FhirFormat cntType, List<String> profiles, List<ValidationRecord> record) throws FHIRException, IOException, EOperationOutcome, SAXException {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.doNative) {
            SchemaValidator.validateSchema(location, cntType, messages);
        }
        InstanceValidator validator = this.getValidator(cntType);
        Element res = validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source.getBytes()), cntType, this.asSdList(profiles));
        boolean first = true;
        for (String fn : this.matchetypes) {
            if (first) {
                messages.removeIf(msg -> msg.getLevel() != ValidationMessage.IssueSeverity.FATAL);
                first = false;
            }
            byte[] cnt = FileUtilities.fileToBytes((String)fn);
            Element exp = Manager.parseSingle((IWorkerContext)validator.getContext(), (InputStream)new ByteArrayInputStream(cnt), (Manager.FhirFormat)FormatUtilities.determineFormat((byte[])cnt));
            log.info("  Validate against matchetype " + fn);
            MatchetypeValidator mv = new MatchetypeValidator(validator.getFHIRPathEngine());
            ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.MatchetypeValidator, ValidationMessage.IssueType.INFORMATIONAL, res.fhirType(), "Validate aginast Matchetype " + fn, ValidationMessage.IssueSeverity.INFORMATION);
            messages.add(vm);
            ArrayList<ValidationMessage> mtErrors = new ArrayList<ValidationMessage>();
            mv.compare(mtErrors, res.fhirType(), exp, res);
            if (mtErrors.isEmpty()) {
                vm.setMessage(vm.getMessage() + " - All OK");
                continue;
            }
            messages.addAll(mtErrors);
        }
        if (this.showTimes) {
            log.info(location + ": " + validator.reportTimes());
        }
        if (record != null) {
            boolean found = false;
            for (ValidationRecord t : record) {
                if (!t.getLocation().equals(location)) continue;
                found = true;
                t.setMessages(messages);
            }
            if (!found) {
                record.add(new ValidationRecord(location, messages));
            }
        }
        return ValidatorUtils.messagesToOutcome(messages, this.context, this.fhirPathEngine);
    }

    public OperationOutcome validate(String location, byte[] source, Manager.FhirFormat cntType, List<String> profiles, IdStatus resourceIdRule, boolean anyExtensionsAllowed, BestPracticeWarningLevel bpWarnings, CheckDisplayOption displayOption) throws FHIRException, IOException, EOperationOutcome, SAXException {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (this.doNative) {
            SchemaValidator.validateSchema(location, cntType, messages);
        }
        InstanceValidator validator = this.getValidator(cntType);
        validator.setResourceIdRule(resourceIdRule);
        validator.setBestPracticeWarningLevel(bpWarnings);
        validator.setCheckDisplay(displayOption);
        validator.validate(null, messages, (InputStream)new ByteArrayInputStream(source), cntType, this.asSdList(profiles));
        return ValidatorUtils.messagesToOutcome(messages, this.context, this.fhirPathEngine);
    }

    public Element transform(String source, String map) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        return this.transform(cnt.getFocus(), cnt.getCntType(), map);
    }

    public org.hl7.fhir.r5.model.StructureMap compile(String mapUri) throws FHIRException, IOException {
        org.hl7.fhir.r5.model.StructureMap map = (org.hl7.fhir.r5.model.StructureMap)this.context.fetchResource(org.hl7.fhir.r5.model.StructureMap.class, mapUri);
        return map;
    }

    public Element transform(ByteProvider source, Manager.FhirFormat cntType, String mapUri) throws FHIRException, IOException {
        ArrayList<Base> outputs = new ArrayList<Base>();
        org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities scu = new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities((IWorkerContext)this.context, (ITransformerServices)new TransformSupportServices(outputs, this.mapLog, this.context));
        org.hl7.fhir.r5.model.StructureMap map = (org.hl7.fhir.r5.model.StructureMap)this.context.fetchResource(org.hl7.fhir.r5.model.StructureMap.class, mapUri);
        if (map == null) {
            throw new Error("Unable to find map " + mapUri + " (Known Maps = " + this.context.listMapUrls() + ")");
        }
        Element resource = this.getTargetResourceFromStructureMap(map);
        StructureDefinition sourceSD = this.getSourceResourceFromStructureMap(map);
        ParserBase parser = Manager.makeParser((IWorkerContext)this.context, (Manager.FhirFormat)cntType);
        if (sourceSD.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) {
            parser.setLogical(sourceSD);
        }
        Element src = parser.parseSingle((InputStream)new ByteArrayInputStream(source.getBytes()), null);
        scu.transform(null, (Base)src, map, (Base)resource);
        resource.populatePaths(null);
        return resource;
    }

    private Element getTargetResourceFromStructureMap(org.hl7.fhir.r5.model.StructureMap map) {
        String targetTypeUrl = null;
        for (StructureMap.StructureMapStructureComponent component : map.getStructure()) {
            if (component.getMode() != StructureMap.StructureMapModelMode.TARGET) continue;
            targetTypeUrl = component.getUrl();
            break;
        }
        if (targetTypeUrl == null) {
            throw new FHIRException("Unable to determine resource URL for target type");
        }
        StructureDefinition structureDefinition = null;
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!sd.getUrl().equalsIgnoreCase(targetTypeUrl)) continue;
            structureDefinition = sd;
            break;
        }
        if (structureDefinition == null) {
            throw new FHIRException("Unable to find StructureDefinition for target type ('" + targetTypeUrl + "')");
        }
        return Manager.build((IWorkerContext)this.getContext(), structureDefinition);
    }

    private StructureDefinition getSourceResourceFromStructureMap(org.hl7.fhir.r5.model.StructureMap map) {
        StructureMap.StructureMapGroupComponent g = (StructureMap.StructureMapGroupComponent)map.getGroup().get(0);
        String type = null;
        for (Object inp : g.getInput()) {
            if (inp.getMode() != StructureMap.StructureMapInputMode.SOURCE) continue;
            if (type != null) {
                throw new DefinitionException("This engine does not support multiple source inputs");
            }
            type = inp.getType();
        }
        String sourceTypeUrl = null;
        for (StructureMap.StructureMapStructureComponent component : map.getStructure()) {
            if (component.getMode() != StructureMap.StructureMapModelMode.SOURCE || !component.getAlias().equalsIgnoreCase(type)) continue;
            sourceTypeUrl = component.getUrl();
            break;
        }
        StructureDefinition structureDefinition = null;
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!sd.getUrl().equalsIgnoreCase(sourceTypeUrl)) continue;
            structureDefinition = sd;
            break;
        }
        if (structureDefinition == null) {
            throw new FHIRException("Unable to find StructureDefinition for source type ('" + sourceTypeUrl + "')");
        }
        return structureDefinition;
    }

    public Resource generate(String source, String version) throws FHIRException, IOException, EOperationOutcome {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Resource res = this.igLoader.loadResourceByVersion(version, cnt.getFocus().getBytes(), source);
        RenderingContext rc = new RenderingContext((IWorkerContext)this.context, null, null, "http://hl7.org/fhir", "", null, RenderingContext.ResourceRendererMode.END_USER, RenderingContext.GenerationRules.VALID_RESOURCE);
        this.genResource(res, rc);
        return res;
    }

    public void genResource(Resource res, RenderingContext rc) throws IOException, EOperationOutcome {
        if (res instanceof Bundle) {
            Bundle bnd = (Bundle)res;
            for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
                if (!be.hasResource()) continue;
                this.genResource(be.getResource(), rc);
            }
        } else {
            RendererFactory.factory((Resource)res, (RenderingContext)rc).renderResource(ResourceWrapper.forResource((ContextUtilities)rc.getContextUtilities(), (Resource)res));
        }
    }

    public void convert(String source, String output) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Element e = Manager.parseSingle((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
        Manager.compose((IWorkerContext)this.context, (Element)e, (OutputStream)ManagedFileAccess.outStream((String)output), (Manager.FhirFormat)(output.endsWith(".json") ? Manager.FhirFormat.JSON : Manager.FhirFormat.XML), (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
    }

    public String evaluateFhirPath(String source, String expression) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        FHIRPathEngine fpe = this.getValidator(null).getFHIRPathEngine();
        Element e = Manager.parseSingle((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
        ExpressionNode exp = fpe.parse(expression);
        return fpe.evaluateToString((Object)new ValidationContext(this.context), (Base)e, (Base)e, (Base)e, exp);
    }

    public StructureDefinition snapshot(String source, String version) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Resource res = this.igLoader.loadResourceByVersion(version, cnt.getFocus().getBytes(), Utilities.getFileNameForName((String)source));
        if (!(res instanceof StructureDefinition)) {
            throw new FHIRException("Require a StructureDefinition for generating a snapshot");
        }
        StructureDefinition sd = (StructureDefinition)res;
        StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        new ProfileUtilities((IWorkerContext)this.context, null, null).setAutoFixSliceNames(true).generateSnapshot(base, sd, sd.getUrl(), null, sd.getName());
        return sd;
    }

    public CanonicalResource loadCanonicalResource(String source, String version) throws FHIRException, IOException {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Resource res = this.igLoader.loadResourceByVersion(version, cnt.getFocus().getBytes(), Utilities.getFileNameForName((String)source));
        if (!(res instanceof CanonicalResource)) {
            throw new FHIRException("Require a CanonicalResource");
        }
        return (CanonicalResource)res;
    }

    public void seeResource(Resource r) throws FHIRException {
        this.context.cacheResource(r);
    }

    public void dropResource(String type, String id) {
        this.context.dropResource(type, id);
    }

    public InstanceValidator getValidator(Manager.FhirFormat format) throws FHIRException, IOException {
        InstanceValidator validator = new InstanceValidator((IWorkerContext)this.context, null, null, new ValidatorSession(), new ValidatorSettings());
        this.context.getTxClientManager().setUsage("validation");
        validator.initializeFromParameters(this.defaultInstanceValidatorParameters);
        validator.getSettings().getCertificateFolders().clear();
        validator.getSettings().getCertificates().clear();
        validator.getSettings().getCertificateFolders().addAll(FhirSettings.getCertificateSources());
        for (String s : this.certSources) {
            File f = ManagedFileAccess.file((String)s);
            if (f.isDirectory()) {
                validator.getSettings().getCertificateFolders().add(s);
                continue;
            }
            validator.getSettings().getCertificates().put(s, FileUtilities.fileToBytes((File)f));
        }
        validator.setValidationLanguage(this.language);
        validator.getSettings().setDisplayWarningMode(this.isDisplayWarnings());
        if (this.language != null && this.locale == null) {
            this.locale = Locale.forLanguageTag(this.language);
        }
        validator.setAssumeValidRestReferences(this.defaultInstanceValidatorParameters.isAssumeValidRestReferences());
        validator.setNoExtensibleWarnings(this.noExtensibleBindingMessages);
        validator.getContext().getManager().setLocale(this.locale);
        validator.setFetcher(this);
        validator.getImplementationGuides().addAll(this.igs);
        validator.getValidationControl().putAll(this.validationControl);
        validator.setAIService(this.aiService);
        validator.setCheckIPSCodes(this.defaultInstanceValidatorParameters.isCheckIPSCodes());
        validator.setCacheFolder(this.context.getTxCache().getFolder());
        if (format == Manager.FhirFormat.SHC) {
            this.igLoader.loadIg(this.getIgs(), this.getBinaries(), "hl7.fhir.uv.shc-vaccination#0.6.2", true);
        }
        validator.setLogProgress(this.logValidationProgress);
        if (this.policyAdvisor != null) {
            validator.setPolicyAdvisor(this.policyAdvisor);
        }
        return validator;
    }

    public void prepare() {
        for (StructureDefinition sd : new ContextUtilities((IWorkerContext)this.context).allStructures()) {
            try {
                this.makeSnapshot(sd);
            }
            catch (Exception e) {
                log.info("Process Note: Unable to generate snapshot for " + sd.present() + ": " + e.getMessage());
                this.context.getLogger().logDebugMessage(ILoggingService.LogCategory.GENERATE, ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private void makeSnapshot(StructureDefinition sd) throws DefinitionException, FHIRException {
        if (sd.hasSnapshot()) {
            return;
        }
        StructureDefinition sdb = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        if (sdb != null) {
            this.makeSnapshot(sdb);
            new ProfileUtilities((IWorkerContext)this.context, null, null).setAutoFixSliceNames(true).generateSnapshot(sdb, sd, sd.getUrl(), null, sd.getName());
        }
    }

    public void handleOutput(Resource r, String output, String version) throws FHIRException, IOException {
        if (output.startsWith("http://")) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            this.handleOutputToStream(r, output, bs, version);
            HTTPResult res = ManagedWebAccess.post(Arrays.asList("web"), (String)output, (byte[])bs.toByteArray(), (String)"application/fhir+xml", (String)"application/fhir+xml");
            res.checkThrowException();
        } else {
            FileOutputStream s = ManagedFileAccess.outStream((String)output);
            this.handleOutputToStream(r, output, s, version);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOutputToStream(Resource r, String fn, OutputStream s, String version) throws FHIRException, IOException {
        if (fn.endsWith(".html") || fn.endsWith(".htm") && r instanceof DomainResource) {
            new XhtmlComposer(false, true).compose(s, ((DomainResource)r).getText().getDiv());
        } else if (VersionUtilities.isR3Ver((String)version)) {
            org.hl7.fhir.dstu3.model.Resource res = VersionConvertorFactory_30_50.convertResource((Resource)r);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                new org.hl7.fhir.dstu3.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            }
        } else if (VersionUtilities.isR4Ver((String)version)) {
            org.hl7.fhir.r4.model.Resource res = VersionConvertorFactory_40_50.convertResource((Resource)r);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.r4.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                new org.hl7.fhir.r4.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map") && !fn.endsWith(".fml")) throw new FHIRException("Unsupported format for " + fn);
                FileUtilities.stringToStream((String)StructureMapUtilities.render((StructureMap)((StructureMap)res)), (OutputStream)s);
            }
        } else if (VersionUtilities.isR2BVer((String)version)) {
            org.hl7.fhir.dstu2016may.model.Resource res = VersionConvertorFactory_14_50.convertResource((Resource)r);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.dstu2016may.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            }
        } else if (VersionUtilities.isR2Ver((String)version)) {
            org.hl7.fhir.dstu2.model.Resource res = VersionConvertorFactory_10_50.convertResource((Resource)r, (BaseAdvisor_10_50)new IGR2ConvertorAdvisor5());
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.dstu2.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            } else {
                if (!fn.endsWith(".json") || fn.endsWith("template.json")) throw new FHIRException("Unsupported format for " + fn);
                new org.hl7.fhir.dstu2.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, res);
            }
        } else {
            if (!VersionUtilities.isR5Plus((String)version)) throw new FHIRException("Encountered unsupported configured version " + version + " loading " + fn);
            if (fn.endsWith(".xml") && !fn.endsWith("template.xml")) {
                new org.hl7.fhir.r5.formats.XmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, r);
            } else if (fn.endsWith(".json") && !fn.endsWith("template.json")) {
                new org.hl7.fhir.r5.formats.JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, r);
            } else {
                if (!fn.endsWith(".txt") && !fn.endsWith(".map") && !fn.endsWith(".fml")) throw new FHIRException("Unsupported format for " + fn);
                FileUtilities.stringToStream((String)org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities.render((org.hl7.fhir.r5.model.StructureMap)((org.hl7.fhir.r5.model.StructureMap)r)), (OutputStream)s);
            }
        }
        s.close();
    }

    public byte[] transformVersion(String source, String targetVer, Manager.FhirFormat format, Boolean canDoNative) throws FHIRException, IOException, Exception {
        Content cnt = this.igLoader.loadContent(source, "validate", false, true);
        Element src = Manager.parseSingle((IWorkerContext)this.context, (InputStream)new ByteArrayInputStream(cnt.getFocus().getBytes()), (Manager.FhirFormat)cnt.getCntType());
        if (canDoNative == null && src.hasChild("url", false) || canDoNative != null && canDoNative.booleanValue()) {
            try {
                if (VersionUtilities.isR2Ver((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR2(targetVer, cnt, format);
                }
                if (VersionUtilities.isR2BVer((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR2b(targetVer, cnt, format);
                }
                if (VersionUtilities.isR3Ver((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR3(targetVer, cnt, format);
                }
                if (VersionUtilities.isR4Ver((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR4(targetVer, cnt, format);
                }
                if (VersionUtilities.isR4BVer((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR4b(targetVer, cnt, format);
                }
                if (VersionUtilities.isR5Ver((String)this.version)) {
                    return VersionConvertor.convertVersionNativeR5(targetVer, cnt, format);
                }
                throw new FHIRException("Source version not supported yet: " + this.version);
            }
            catch (Exception e) {
                log.error("Conversion failed using Java convertor: " + e.getMessage());
            }
        }
        log.info("Loading hl7.fhir.xver.r4");
        this.igLoader.loadIg(this.getIgs(), this.getBinaries(), "hl7.fhir.xver.r4", false);
        String type = src.fhirType();
        String url = this.getMapId(type, targetVer);
        ArrayList<Base> outputs = new ArrayList<Base>();
        org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities scu = new org.hl7.fhir.r5.utils.structuremap.StructureMapUtilities((IWorkerContext)this.context, (ITransformerServices)new TransformSupportServices(outputs, this.mapLog, this.context));
        org.hl7.fhir.r5.model.StructureMap map = (org.hl7.fhir.r5.model.StructureMap)this.context.fetchResource(org.hl7.fhir.r5.model.StructureMap.class, url);
        if (map == null) {
            throw new Error("Unable to find map " + url + " (Known Maps = " + this.context.listMapUrls() + ")");
        }
        Element resource = this.getTargetResourceFromStructureMap(map);
        scu.transform(null, (Base)src, map, (Base)resource);
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (Element)resource, (OutputStream)bs, (Manager.FhirFormat)format, (IParser.OutputStyle)IParser.OutputStyle.PRETTY, null);
        return bs.toByteArray();
    }

    private String getMapId(String type, String targetVer) {
        if (VersionUtilities.isR2Ver((String)this.version)) {
            if (VersionUtilities.isR3Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "2to3";
            }
        } else if (VersionUtilities.isR3Ver((String)this.version)) {
            if (VersionUtilities.isR2Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "3to2";
            }
            if (VersionUtilities.isR4Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "3to4";
            }
        } else if (VersionUtilities.isR4Ver((String)this.version)) {
            if (VersionUtilities.isR3Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "4to3";
            }
            if (VersionUtilities.isR5Ver((String)targetVer)) {
                return "http://hl7.org/fhir/StructureMap/" + type + "4to5";
            }
        } else if (VersionUtilities.isR5Ver((String)this.version) && VersionUtilities.isR4Ver((String)targetVer)) {
            return "http://hl7.org/fhir/StructureMap/" + type + "5to4";
        }
        throw new FHIRException("Source/Target version not supported: " + this.version + " -> " + targetVer);
    }

    public String setTerminologyServer(String src, String log, FhirPublication version, boolean useEcosystem) throws FHIRException, URISyntaxException, IOException {
        return this.connectToTSServer(src, log, version, useEcosystem);
    }

    public ValidationEngine setMapLog(String mapLog) throws FileNotFoundException {
        if (mapLog != null) {
            this.mapLog = new PrintWriter(mapLog);
        }
        return this;
    }

    public ValidationEngine setSnomedExtension(String sct) {
        this.getContext().getExpansionParameters().addParameter("system-version", (DataType)new CanonicalType("http://snomed.info/sct|http://snomed.info/sct/" + sct));
        return this;
    }

    public FilesystemPackageCacheManager getPcm() throws IOException {
        if (this.pcm == null) {
            this.pcm = new FilesystemPackageCacheManager.Builder().build();
        }
        return this.pcm;
    }

    public byte[] fetchRaw(IResourceValidator validator, String source) throws IOException {
        HTTPResult res = ManagedWebAccess.get(Arrays.asList("web"), (String)source);
        res.checkThrowException();
        return res.getContent();
    }

    @Override
    public boolean packageExists(String id, String ver) throws IOException, FHIRException {
        return this.getPcm().packageExists(id, ver);
    }

    @Override
    public void loadPackage(String id, String ver) throws IOException, FHIRException {
        this.igLoader.loadIg(this.getIgs(), this.getBinaries(), id + (String)(ver == null ? "" : "#" + ver), true);
    }

    public Element fetch(IResourceValidator validator, Object appContext, String url) throws FHIRException, IOException {
        Resource resource = this.context.fetchResource(Resource.class, url);
        if (resource != null) {
            return new ObjectConverter((IWorkerContext)this.context).convert(resource);
        }
        if (this.fetcher != null) {
            return this.fetcher.fetch(validator, appContext, url);
        }
        return null;
    }

    public ReferenceValidationPolicy policyForReference(IResourceValidator validator, Object appContext, String path, String url, IValidationPolicyAdvisor.ReferenceDestinationType destinationType) {
        Resource resource = this.context.fetchResource(StructureDefinition.class, url);
        if (resource != null) {
            return ReferenceValidationPolicy.CHECK_VALID;
        }
        if (!url.contains("hl7.org") && !url.contains("fhir.org")) {
            return ReferenceValidationPolicy.IGNORE;
        }
        if (this.policyAdvisor != null) {
            return this.policyAdvisor.policyForReference(validator, appContext, path, url, destinationType);
        }
        return ReferenceValidationPolicy.CHECK_EXISTS_AND_TYPE;
    }

    public ContainedReferenceValidationPolicy policyForContained(IResourceValidator validator, Object appContext, StructureDefinition structure, ElementDefinition element, String containerType, String containerId, Element.SpecialElement containingResourceType, String path, String url) {
        return ContainedReferenceValidationPolicy.CHECK_VALID;
    }

    public EnumSet<IValidationPolicyAdvisor.CodedContentValidationAction> policyForCodedContent(IResourceValidator validator, Object appContext, String stackPath, ElementDefinition definition, StructureDefinition structure, BindingKind kind, IValidationPolicyAdvisor.AdditionalBindingPurpose purpose, ValueSet valueSet, List<String> systems) {
        return EnumSet.allOf(IValidationPolicyAdvisor.CodedContentValidationAction.class);
    }

    public boolean resolveURL(IResourceValidator validator, Object appContext, String path, String url, String type, boolean canonical, List<CanonicalType> targets) throws FHIRException {
        if (this.resolvedUrls.containsKey(type + "|" + url)) {
            return this.resolvedUrls.get(type + "|" + url);
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (this.context.fetchResource(Resource.class, url) != null) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (SIDUtilities.isKnownSID((String)url) || Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/w5", "http://hl7.org/fhir/fivews", "http://hl7.org/fhir/workflow", "http://hl7.org/fhir/ConsentPolicy/opt-out", "http://hl7.org/fhir/ConsentPolicy/opt-in"})) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (Utilities.existsInList((String)url, (String[])new String[]{"http://loinc.org", "http://unitsofmeasure.org", "http://snomed.info/sct"})) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (this.context.getNSUrlMap().containsKey(url)) {
            this.resolvedUrls.put(type + "|" + url, true);
            return true;
        }
        if (url.contains("example.org") || url.contains("acme.com")) {
            this.resolvedUrls.put(type + "|" + url, false);
            return false;
        }
        if (url.contains("*") && !url.contains("?")) {
            List maps;
            if (this.cu == null) {
                this.cu = new ContextUtilities((IWorkerContext)this.context);
            }
            if (!(maps = this.cu.listMaps(url)).isEmpty()) {
                return true;
            }
        }
        if (this.fetcher != null) {
            try {
                boolean ok = this.fetcher.resolveURL(validator, appContext, path, url, type, canonical, targets);
                this.resolvedUrls.put(type + "|" + url, ok);
                return ok;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.resolvedUrls.put(type + "|" + url, false);
                return false;
            }
        }
        this.resolvedUrls.put(type + "|" + url, false);
        return false;
    }

    public CanonicalResource fetchCanonicalResource(IResourceValidator validator, Object appContext, String url) throws URISyntaxException {
        Resource res = this.context.fetchResource(Resource.class, url);
        if (res != null) {
            if (res instanceof CanonicalResource) {
                return (CanonicalResource)res;
            }
            return null;
        }
        return this.fetcher != null ? this.fetcher.fetchCanonicalResource(validator, appContext, url) : null;
    }

    public boolean fetchesCanonicalResource(IResourceValidator validator, String url) {
        return this.fetcher != null && this.fetcher.fetchesCanonicalResource(validator, url);
    }

    public void packageLoaded(String pid, String version) {
        this.resolvedUrls.clear();
    }

    public Resource loadResource(byte[] content, String fn) throws FHIRException, IOException {
        return this.igLoader.loadResourceByVersion(this.version, content, fn);
    }

    public EnumSet<IValidationPolicyAdvisor.ResourceValidationAction> policyForResource(IResourceValidator validator, Object appContext, StructureDefinition type, String path) {
        return EnumSet.allOf(IValidationPolicyAdvisor.ResourceValidationAction.class);
    }

    public EnumSet<IValidationPolicyAdvisor.ElementValidationAction> policyForElement(IResourceValidator validator, Object appContext, StructureDefinition structure, ElementDefinition element, String path) {
        return EnumSet.allOf(IValidationPolicyAdvisor.ElementValidationAction.class);
    }

    public Set<String> fetchCanonicalResourceVersions(IResourceValidator validator, Object appContext, String url) {
        HashSet<String> res = new HashSet<String>();
        for (Resource r : this.context.fetchResourceVersions(Resource.class, url)) {
            if (!(r instanceof CanonicalResource)) continue;
            CanonicalResource cr = (CanonicalResource)r;
            res.add(cr.hasVersion() ? cr.getVersion() : "{{unversioned}}");
        }
        if (this.fetcher != null) {
            res.addAll(this.fetcher.fetchCanonicalResourceVersions(validator, appContext, url));
        }
        return res;
    }

    public List<StructureDefinition> getImpliedProfilesForResource(IResourceValidator validator, Object appContext, String stackPath, ElementDefinition definition, StructureDefinition structure, Element resource, boolean valid, IMessagingServices msgServices, List<ValidationMessage> messages) {
        return new BasePolicyAdvisorForFullValidation(ReferenceValidationPolicy.CHECK_VALID).getImpliedProfilesForResource(validator, appContext, stackPath, definition, structure, resource, valid, msgServices, messages);
    }

    public boolean isSuppressMessageId(String path, String messageId) {
        return this.policyAdvisor.isSuppressMessageId(path, messageId);
    }

    public ReferenceValidationPolicy getReferencePolicy() {
        return ReferenceValidationPolicy.IGNORE;
    }

    public void loadExpansionParameters(String expansionParameters) {
        log.info("Load Expansion Parameters: " + expansionParameters);
        Parameters p = null;
        try {
            p = (Parameters)new org.hl7.fhir.r5.formats.XmlParser().parse((InputStream)new FileInputStream(expansionParameters));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (p == null) {
            try {
                p = (Parameters)new org.hl7.fhir.r5.formats.JsonParser().parse((InputStream)new FileInputStream(expansionParameters));
            }
            catch (Exception e) {
                log.error("Unable to load expansion parameters '" + expansionParameters + "' as either xml or json: " + e.getMessage());
                throw new FHIRException("Unable to load expansion parameters '" + expansionParameters + "' as either xml or json: " + e.getMessage());
            }
        }
        this.context.setExpansionParameters(p);
    }

    public IValidationPolicyAdvisor.SpecialValidationAction policyForSpecialValidation(IResourceValidator validator, Object appContext, IValidationPolicyAdvisor.SpecialValidationRule rule, String stackPath, Element resource, Element element) {
        return IValidationPolicyAdvisor.SpecialValidationAction.CHECK_RULE;
    }

    @Deprecated(since="2025-10-24")
    public boolean isAllowExampleUrls() {
        return this.defaultInstanceValidatorParameters.isAllowExampleUrls();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setAllowExampleUrls(boolean allowExampleUrls) {
        this.defaultInstanceValidatorParameters.setAllowExampleUrls(allowExampleUrls);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isAllowDoubleQuotesInFHIRPath() {
        return this.defaultInstanceValidatorParameters.isAllowDoubleQuotesInFHIRPath();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setAllowDoubleQuotesInFHIRPath(boolean allowDoubleQuotesInFHIRPath) {
        this.defaultInstanceValidatorParameters.setAllowDoubleQuotesInFHIRPath(allowDoubleQuotesInFHIRPath);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isShowMessagesFromReferences() {
        return this.defaultInstanceValidatorParameters.isShowMessagesFromReferences();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setShowMessagesFromReferences(boolean showMessagesFromReferences) {
        this.defaultInstanceValidatorParameters.setShowMessagesFromReferences(showMessagesFromReferences);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isHintAboutNonMustSupport() {
        return this.defaultInstanceValidatorParameters.isHintAboutNonMustSupport();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.defaultInstanceValidatorParameters.setHintAboutNonMustSupport(hintAboutNonMustSupport);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isAssumeValidRestReferences() {
        return this.defaultInstanceValidatorParameters.isAssumeValidRestReferences();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.defaultInstanceValidatorParameters.setAssumeValidRestReferences(assumeValidRestReferences);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public BestPracticeWarningLevel getBestPracticeLevel() {
        return this.defaultInstanceValidatorParameters.getBestPracticeLevel();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setBestPracticeLevel(BestPracticeWarningLevel bestPracticeLevel) {
        this.defaultInstanceValidatorParameters.setBestPracticeLevel(bestPracticeLevel);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public List<BundleValidationRule> getBundleValidationRules() {
        return this.defaultInstanceValidatorParameters.getBundleValidationRules();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setBundleValidationRules(List<BundleValidationRule> bundleValidationRules) {
        this.defaultInstanceValidatorParameters.setBundleValidationRules(bundleValidationRules);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isCheckIPSCodes() {
        return this.defaultInstanceValidatorParameters.isCheckIPSCodes();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setCheckIPSCodes(boolean checkIPSCodes) {
        this.defaultInstanceValidatorParameters.setCheckIPSCodes(checkIPSCodes);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isCrumbTrails() {
        return this.defaultInstanceValidatorParameters.isCrumbTrails();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setCrumbTrails(boolean crumbTrails) {
        this.defaultInstanceValidatorParameters.setCrumbTrails(crumbTrails);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isDoImplicitFHIRPathStringConversion() {
        return this.defaultInstanceValidatorParameters.isDoImplicitFHIRPathStringConversion();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setDoImplicitFHIRPathStringConversion(boolean doImplicitFHIRPathStringConversion) {
        this.defaultInstanceValidatorParameters.setDoImplicitFHIRPathStringConversion(doImplicitFHIRPathStringConversion);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isForPublication() {
        return this.defaultInstanceValidatorParameters.isForPublication();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setForPublication(boolean forPublication) {
        this.defaultInstanceValidatorParameters.setForPublication(forPublication);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public HtmlInMarkdownCheck getHtmlInMarkdownCheck() {
        return this.defaultInstanceValidatorParameters.getHtmlInMarkdownCheck();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setHtmlInMarkdownCheck(HtmlInMarkdownCheck htmlInMarkdownCheck) {
        this.defaultInstanceValidatorParameters.setHtmlInMarkdownCheck(htmlInMarkdownCheck);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public Coding getJurisdiction() {
        return CodeSystemUtilities.readCoding((String)this.defaultInstanceValidatorParameters.getJurisdiction());
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setJurisdiction(Coding jurisdiction) {
        this.defaultInstanceValidatorParameters.setJurisdiction(jurisdiction.getCode());
        return this;
    }

    @Deprecated(since="2025-10-24")
    public ValidationLevel getLevel() {
        return this.defaultInstanceValidatorParameters.getLevel();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setLevel(ValidationLevel level) {
        this.defaultInstanceValidatorParameters.setLevel(level);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isNoExperimentalContent() {
        return this.defaultInstanceValidatorParameters.isNoExperimentalContent();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setNoExperimentalContent(boolean noExperimentalContent) {
        this.defaultInstanceValidatorParameters.setNoExperimentalContent(noExperimentalContent);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isNoInvariantChecks() {
        return this.defaultInstanceValidatorParameters.isNoInvariants();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setNoInvariantChecks(boolean noInvariantChecks) {
        this.defaultInstanceValidatorParameters.setNoInvariants(noInvariantChecks);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isNoUnicodeBiDiControlChars() {
        return this.defaultInstanceValidatorParameters.isNoUnicodeBiDiControlChars();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setNoUnicodeBiDiControlChars(boolean noUnicodeBiDiControlChars) {
        this.defaultInstanceValidatorParameters.setNoUnicodeBiDiControlChars(noUnicodeBiDiControlChars);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public QuestionnaireMode getQuestionnaireMode() {
        return this.defaultInstanceValidatorParameters.getQuestionnaireMode();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setQuestionnaireMode(QuestionnaireMode questionnaireMode) {
        this.defaultInstanceValidatorParameters.setQuestionnaireMode(questionnaireMode);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public ValidationOptions.R5BundleRelativeReferencePolicy getR5BundleRelativeReferencePolicy() {
        return this.defaultInstanceValidatorParameters.getR5BundleRelativeReferencePolicy();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setR5BundleRelativeReferencePolicy(ValidationOptions.R5BundleRelativeReferencePolicy r5BundleRelativeReferencePolicy) {
        this.defaultInstanceValidatorParameters.setR5BundleRelativeReferencePolicy(r5BundleRelativeReferencePolicy);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isSecurityChecks() {
        return this.defaultInstanceValidatorParameters.isSecurityChecks();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setSecurityChecks(boolean securityChecks) {
        this.defaultInstanceValidatorParameters.setSecurityChecks(securityChecks);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isShowMessageIds() {
        return this.defaultInstanceValidatorParameters.isShowMessageIds();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setShowMessageIds(boolean showMessageIds) {
        this.defaultInstanceValidatorParameters.setShowMessageIds(showMessageIds);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isUnknownCodeSystemsCauseErrors() {
        return this.defaultInstanceValidatorParameters.isUnknownCodeSystemsCauseErrors();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setUnknownCodeSystemsCauseErrors(boolean unknownCodeSystemsCauseErrors) {
        this.defaultInstanceValidatorParameters.setUnknownCodeSystemsCauseErrors(unknownCodeSystemsCauseErrors);
        return this;
    }

    @Deprecated(since="2025-10-24")
    public boolean isWantInvariantInMessage() {
        return this.defaultInstanceValidatorParameters.isWantInvariantsInMessages();
    }

    @Deprecated(since="2025-10-24")
    public ValidationEngine setWantInvariantInMessage(boolean wantInvariantInMessage) {
        this.defaultInstanceValidatorParameters.setWantInvariantsInMessages(wantInvariantInMessage);
        return this;
    }

    @Generated
    public SimpleWorkerContext getContext() {
        return this.context;
    }

    @Generated
    public ValidationEngine setContext(SimpleWorkerContext context) {
        this.context = context;
        return this;
    }

    @Generated
    public Map<String, ByteProvider> getBinaries() {
        return this.binaries;
    }

    @Generated
    public ValidationEngine setBinaries(Map<String, ByteProvider> binaries) {
        this.binaries = binaries;
        return this;
    }

    @Generated
    public boolean isDoNative() {
        return this.doNative;
    }

    @Generated
    public ValidationEngine setDoNative(boolean doNative) {
        this.doNative = doNative;
        return this;
    }

    @Generated
    public boolean isDisplayWarnings() {
        return this.displayWarnings;
    }

    @Generated
    public ValidationEngine setDisplayWarnings(boolean displayWarnings) {
        this.displayWarnings = displayWarnings;
        return this;
    }

    @Generated
    public boolean isLogValidationProgress() {
        return this.logValidationProgress;
    }

    @Generated
    public ValidationEngine setLogValidationProgress(boolean logValidationProgress) {
        this.logValidationProgress = logValidationProgress;
        return this;
    }

    @Generated
    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    @Generated
    public ValidationEngine setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
        return this;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public ValidationEngine setVersion(String version) {
        this.version = version;
        return this;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public ValidationEngine setLanguage(String language) {
        this.language = language;
        return this;
    }

    @Generated
    public ValidationEngine setPcm(FilesystemPackageCacheManager pcm) {
        this.pcm = pcm;
        return this;
    }

    @Generated
    public PrintWriter getMapLog() {
        return this.mapLog;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public ValidationEngine setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    @Generated
    public IValidatorResourceFetcher getFetcher() {
        return this.fetcher;
    }

    @Generated
    public ValidationEngine setFetcher(IValidatorResourceFetcher fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Generated
    public IValidationPolicyAdvisor getPolicyAdvisor() {
        return this.policyAdvisor;
    }

    @Generated
    public ValidationEngine setPolicyAdvisor(IValidationPolicyAdvisor policyAdvisor) {
        this.policyAdvisor = policyAdvisor;
        return this;
    }

    @Generated
    public IWorkerContextManager.ICanonicalResourceLocator getLocator() {
        return this.locator;
    }

    @Generated
    public ValidationEngine setLocator(IWorkerContextManager.ICanonicalResourceLocator locator) {
        this.locator = locator;
        return this;
    }

    @Generated
    public boolean isNoExtensibleBindingMessages() {
        return this.noExtensibleBindingMessages;
    }

    @Generated
    public ValidationEngine setNoExtensibleBindingMessages(boolean noExtensibleBindingMessages) {
        this.noExtensibleBindingMessages = noExtensibleBindingMessages;
        return this;
    }

    @Generated
    public String getAiService() {
        return this.aiService;
    }

    @Generated
    public ValidationEngine setAiService(String aiService) {
        this.aiService = aiService;
        return this;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public ValidationEngine setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    @Generated
    public List<ImplementationGuide> getIgs() {
        return this.igs;
    }

    @Generated
    public ValidationEngine setIgs(List<ImplementationGuide> igs) {
        this.igs = igs;
        return this;
    }

    @Generated
    public List<String> getExtensionDomains() {
        return this.extensionDomains;
    }

    @Generated
    public ValidationEngine setExtensionDomains(List<String> extensionDomains) {
        this.extensionDomains = extensionDomains;
        return this;
    }

    @Generated
    public List<String> getCertSources() {
        return this.certSources;
    }

    @Generated
    public ValidationEngine setCertSources(List<String> certSources) {
        this.certSources = certSources;
        return this;
    }

    @Generated
    public List<String> getMatchetypes() {
        return this.matchetypes;
    }

    @Generated
    public ValidationEngine setMatchetypes(List<String> matchetypes) {
        this.matchetypes = matchetypes;
        return this;
    }

    @Generated
    public boolean isShowTimes() {
        return this.showTimes;
    }

    @Generated
    public ValidationEngine setShowTimes(boolean showTimes) {
        this.showTimes = showTimes;
        return this;
    }

    @Generated
    public FHIRPathEngine getFhirPathEngine() {
        return this.fhirPathEngine;
    }

    @Generated
    public ValidationEngine setFhirPathEngine(FHIRPathEngine fhirPathEngine) {
        this.fhirPathEngine = fhirPathEngine;
        return this;
    }

    @Generated
    public IgLoader getIgLoader() {
        return this.igLoader;
    }

    @Generated
    public ValidationEngine setIgLoader(IgLoader igLoader) {
        this.igLoader = igLoader;
        return this;
    }

    @Nonnull
    @Generated
    public InstanceValidatorParameters getDefaultInstanceValidatorParameters() {
        return this.defaultInstanceValidatorParameters;
    }

    @Generated
    public Map<String, BaseValidator.ValidationControl> getValidationControl() {
        return this.validationControl;
    }

    @Generated
    public ValidationEngine setValidationControl(Map<String, BaseValidator.ValidationControl> validationControl) {
        this.validationControl = validationControl;
        return this;
    }

    public static interface IValidationEngineLoader {
        public void load(Content var1) throws FHIRException, IOException;
    }

    public static class ValidationEngineBuilder {
        private final String terminologyCachePath;
        private final String userAgent;
        private final String version;
        private final String txServer;
        private final String txLog;
        private final FhirPublication txVersion;
        private final boolean useEcosystem;
        private final TimeTracker timeTracker;
        private final boolean canRunWithoutTerminologyServer;
        private final ILoggingService loggingService;
        private String thoVersion;
        private String extensionsVersion;
        @Nonnull
        private InstanceValidatorParameters defaultInstanceValidatorParameters;
        private static final boolean USE_ECOSYSTEM_DEFAULT = true;

        public ValidationEngineBuilder() {
            this.terminologyCachePath = null;
            this.userAgent = null;
            this.version = null;
            this.txServer = null;
            this.txLog = null;
            this.txVersion = null;
            this.timeTracker = null;
            this.canRunWithoutTerminologyServer = false;
            this.useEcosystem = true;
            this.loggingService = new Slf4JLoggingService(LoggerFactory.getLogger(ValidationEngine.class));
            this.thoVersion = null;
            this.extensionsVersion = null;
            this.defaultInstanceValidatorParameters = new InstanceValidatorParameters();
        }

        private ValidationEngineBuilder(String terminologyCachePath, String userAgent, String version, String txServer, String txLog, FhirPublication txVersion, boolean useEcosystem, TimeTracker timeTracker, boolean canRunWithoutTerminologyServer, ILoggingService loggingService, String thoVersion, String extensionsVersion, InstanceValidatorParameters defaultInstanceValidatorParameters) {
            this.terminologyCachePath = terminologyCachePath;
            this.userAgent = userAgent;
            this.version = version;
            this.txServer = txServer;
            this.txLog = txLog;
            this.txVersion = txVersion;
            this.timeTracker = timeTracker;
            this.canRunWithoutTerminologyServer = canRunWithoutTerminologyServer;
            this.loggingService = loggingService;
            this.useEcosystem = useEcosystem;
            this.thoVersion = thoVersion;
            this.extensionsVersion = extensionsVersion;
            this.defaultInstanceValidatorParameters = defaultInstanceValidatorParameters;
        }

        public ValidationEngineBuilder withTxServer(String txServer, String txLog, FhirPublication txVersion, boolean useEcosystem) {
            return new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, txServer, txLog, txVersion, useEcosystem, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        public ValidationEngineBuilder withNoTerminologyServer() {
            return new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, null, null, this.txVersion, this.useEcosystem, this.timeTracker, true, this.loggingService, this.thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        public ValidationEngineBuilder withDefaultInstanceValidatorParameters(InstanceValidatorParameters defaultInstanceValidatorParameters) {
            InstanceValidatorParameters instanceValidatorParameters = defaultInstanceValidatorParameters == null ? new InstanceValidatorParameters() : defaultInstanceValidatorParameters;
            return new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.thoVersion, this.extensionsVersion, instanceValidatorParameters);
        }

        public ValidationEngine fromNothing() throws IOException {
            NpmPackageIndexBuilder.setExtensionFactory((NpmPackageIndexBuilder.INpmPackageIndexBuilderDBImplFactory)new SQLiteINpmPackageIndexBuilderDBImpl.SQLiteINpmPackageIndexBuilderDBImplFactory());
            ValidationEngine engine = new ValidationEngine(this.defaultInstanceValidatorParameters);
            SimpleWorkerContext.SimpleWorkerContextBuilder contextBuilder = new SimpleWorkerContext.SimpleWorkerContextBuilder().withLoggingService(this.loggingService);
            if (this.terminologyCachePath != null) {
                contextBuilder = contextBuilder.withTerminologyCachePath(this.terminologyCachePath);
            }
            engine.setContext(contextBuilder.build());
            engine.initContext(this.timeTracker);
            engine.setIgLoader(new IgLoader(engine.getPcm(), engine.getContext(), engine.getVersion(), engine.isDebug()));
            this.loadTx(engine);
            if (VersionUtilities.isR5Plus((String)this.version)) {
                engine.loadPackage("hl7.fhir.uv.extensions", null);
            }
            return engine;
        }

        public ValidationEngine fromSource(String src) throws IOException, URISyntaxException {
            ValidationEngine engine = new ValidationEngine(this.defaultInstanceValidatorParameters);
            engine.loadCoreDefinitions(src, false, this.terminologyCachePath, this.userAgent, this.timeTracker, this.loggingService);
            engine.getContext().setCanRunWithoutTerminology(this.canRunWithoutTerminologyServer);
            engine.getContext().setPackageTracker((IWorkerContextManager.IPackageLoadingTracker)engine);
            if (this.txServer != null) {
                engine.setTerminologyServer(this.txServer, this.txLog, this.txVersion, this.useEcosystem);
            }
            engine.setVersion(this.version);
            engine.setIgLoader(new IgLoader(engine.getPcm(), engine.getContext(), engine.getVersion(), engine.isDebug()));
            if (this.thoVersion != null) {
                this.loadTx(engine);
            }
            if (this.extensionsVersion != null) {
                this.loadExt(engine);
            }
            return engine;
        }

        private void loadTx(ValidationEngine engine) throws FHIRException, IOException {
            String pid = null;
            if (VersionUtilities.isR3Ver((String)this.version)) {
                pid = "hl7.terminology.r3";
            }
            if (VersionUtilities.isR4Ver((String)this.version)) {
                pid = "hl7.terminology.r4";
            }
            if (VersionUtilities.isR4BVer((String)this.version)) {
                pid = "hl7.terminology.r4";
            }
            if (VersionUtilities.isR5Plus((String)this.version)) {
                pid = "hl7.terminology.r5";
            }
            if (pid != null) {
                engine.loadPackage(pid, this.thoVersion);
            }
        }

        private void loadExt(ValidationEngine engine) throws FHIRException, IOException {
            String pid = null;
            if (VersionUtilities.isR3Ver((String)this.version)) {
                pid = "hl7.fhir.uv.extensions.r3";
            }
            if (VersionUtilities.isR4Ver((String)this.version)) {
                pid = "hl7.fhir.uv.extensions.r4";
            }
            if (VersionUtilities.isR4BVer((String)this.version)) {
                pid = "hl7.fhir.uv.extensions.r4";
            }
            if (VersionUtilities.isR5Plus((String)this.version)) {
                pid = "hl7.fhir.uv.extensions.r5";
            }
            if (pid != null) {
                engine.loadPackage(pid, this.extensionsVersion);
            }
        }

        @Generated
        public ValidationEngineBuilder withTerminologyCachePath(String terminologyCachePath) {
            return this.terminologyCachePath == terminologyCachePath ? this : new ValidationEngineBuilder(terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        @Generated
        public ValidationEngineBuilder withUserAgent(String userAgent) {
            return this.userAgent == userAgent ? this : new ValidationEngineBuilder(this.terminologyCachePath, userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        @Generated
        public ValidationEngineBuilder withVersion(String version) {
            return this.version == version ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        @Generated
        public ValidationEngineBuilder withTimeTracker(TimeTracker timeTracker) {
            return this.timeTracker == timeTracker ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        @Generated
        public ValidationEngineBuilder withCanRunWithoutTerminologyServer(boolean canRunWithoutTerminologyServer) {
            return this.canRunWithoutTerminologyServer == canRunWithoutTerminologyServer ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, this.timeTracker, canRunWithoutTerminologyServer, this.loggingService, this.thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        @Generated
        public ValidationEngineBuilder withLoggingService(ILoggingService loggingService) {
            return this.loggingService == loggingService ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, this.timeTracker, this.canRunWithoutTerminologyServer, loggingService, this.thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        @Generated
        public ValidationEngineBuilder withThoVersion(String thoVersion) {
            return this.thoVersion == thoVersion ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, thoVersion, this.extensionsVersion, this.defaultInstanceValidatorParameters);
        }

        @Generated
        public ValidationEngineBuilder withExtensionsVersion(String extensionsVersion) {
            return this.extensionsVersion == extensionsVersion ? this : new ValidationEngineBuilder(this.terminologyCachePath, this.userAgent, this.version, this.txServer, this.txLog, this.txVersion, this.useEcosystem, this.timeTracker, this.canRunWithoutTerminologyServer, this.loggingService, this.thoVersion, extensionsVersion, this.defaultInstanceValidatorParameters);
        }
    }
}

