/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class MatchetypeValidator {
    private static final String EXT_OPT_MODE = "http://hl7.org/fhir/tools/StructureDefinition/matchetype";
    private static final String EXT_OPT_PROP = "http://hl7.org/fhir/tools/StructureDefinition/matchetype-optional";
    private static final String EXT_OPT_COUNT = "http://hl7.org/fhir/tools/StructureDefinition/matchetype-count";
    private static final String EXT_OPT_SORT = "http://hl7.org/fhir/tools/StructureDefinition/matchetype-sort";
    private JsonObject externals;
    private Map<String, String> variables;
    private Set<String> modes;
    private boolean patternMode;
    private FHIRPathEngine fpe;

    public MatchetypeValidator(FHIRPathEngine fpe) {
        this.fpe = fpe;
        this.variables = new HashMap<String, String>();
    }

    public MatchetypeValidator(FHIRPathEngine fpe, Set<String> modes) {
        this.fpe = fpe;
        this.modes = modes;
        this.variables = new HashMap<String, String>();
    }

    public MatchetypeValidator(FHIRPathEngine fpe, Set<String> modes, JsonObject externals) {
        this.fpe = fpe;
        this.modes = modes;
        this.externals = externals;
        this.variables = new HashMap<String, String>();
    }

    public MatchetypeValidator(FHIRPathEngine fpe, Set<String> modes, JsonObject externals, Map<String, String> variables) {
        this.fpe = fpe;
        this.externals = externals;
        this.variables = variables;
    }

    public boolean isPatternMode() {
        return this.patternMode;
    }

    public MatchetypeValidator setPatternMode(boolean patternMode) {
        this.patternMode = patternMode;
        return this;
    }

    public boolean compare(List<ValidationMessage> messages, String path, Element expectedElement, Element actualElement) {
        String mode = expectedElement.getExtensionString(EXT_OPT_MODE);
        if (mode != null) {
            this.patternMode = "partial".equals(mode);
        }
        return this.compareElements(messages, path, expectedElement, actualElement);
    }

    private boolean compareElements(List<ValidationMessage> messages, String path, Element expectedElement, Element actualElement) {
        String n;
        boolean ok = true;
        this.doSort(actualElement, expectedElement);
        List<String> optionals = this.listOptionals(expectedElement);
        List<String> countOnlys = this.listCountOnlys(expectedElement);
        for (Property en : actualElement.children()) {
            n = en.getName();
            if (expectedElement.hasChildren(n)) {
                Property ep = expectedElement.getChildByName(n);
                if (this.compareProperties(messages, path + "." + n, this.elements(ep.getValues(), true), this.elements(en.getValues(), false), countOnlys.contains(n), n, actualElement)) continue;
                ok = false;
                continue;
            }
            if (this.patternMode) continue;
            this.msg(messages, path, actualElement, "properties differ at " + path + ": unexpected element " + n);
            ok = false;
        }
        for (Property en : expectedElement.children()) {
            n = en.getName();
            if (this.isAllMatchetypeExtensions(en) || this.isOptional(n, optionals) || actualElement.hasChildren(n) || this.allOptional(this.elements(en.getValues(), true), null, null)) continue;
            this.msg(messages, path, actualElement, "properties differ at " + path + ": missing element " + n);
            ok = false;
        }
        return ok;
    }

    private void doSort(Element actualElement, Element expectedElement) {
        for (Element extension : expectedElement.getChildren("extension")) {
            String url = extension.getNamedChildValue(new String[]{"url"});
            if (!EXT_OPT_SORT.equals(url)) continue;
            String name = null;
            String expr = null;
            for (Element extension2 : extension.getChildren("extension")) {
                String url2 = extension2.getNamedChildValue(new String[]{"url"});
                if ("element".equals(url2)) {
                    name = extension2.getNamedChildValue(new String[]{"value"});
                    continue;
                }
                if (!"expression".equals(url2)) continue;
                expr = extension2.getNamedChildValue(new String[]{"value"});
            }
            if (name == null || expr == null) continue;
            actualElement.sortChildren((Comparator)new NamedElementSorter(name, expr));
        }
    }

    private boolean isAllMatchetypeExtensions(Property en) {
        for (Element e : this.elements(en.getValues(), true)) {
            if (e.fhirType().equals("Extension")) {
                String url = e.getNamedChildValue(new String[]{"url"});
                if (!Utilities.noString((String)url) && url.startsWith(EXT_OPT_MODE)) continue;
                return false;
            }
            return false;
        }
        return en.getValues().size() > 0;
    }

    private List<String> listOptionals(Element expectedElement) {
        ArrayList<String> res = new ArrayList<String>();
        if (expectedElement.hasExtension(new String[]{EXT_OPT_PROP})) {
            for (String s : expectedElement.getExtensionString(EXT_OPT_PROP).split("\\,")) {
                res.add(s);
            }
        }
        return res;
    }

    private List<String> listCountOnlys(Element expectedElement) {
        ArrayList<String> res = new ArrayList<String>();
        if (expectedElement.hasExtension(new String[]{EXT_OPT_COUNT})) {
            for (String s : expectedElement.getExtensionString(EXT_OPT_COUNT).split("\\,")) {
                res.add(s);
            }
        }
        return res;
    }

    private boolean compareProperties(List<ValidationMessage> messages, String path, List<Element> expectedElements, List<Element> actualElements, boolean countOnly, String name, Element parent) {
        boolean ok = true;
        int as = actualElements.size();
        int es = expectedElements.size();
        if (countOnly) {
            if (as != es) {
                this.notEqualMessage(messages, path, parent, "item count differs at " + path, Integer.toString(es), Integer.toString(as));
                ok = false;
            }
        } else if (as <= 1 && es <= 1) {
            if (!this.comparePropertyValue(messages, path, expectedElements.size() == 1 ? expectedElements.get(0) : null, actualElements.size() == 1 ? actualElements.get(0) : null, false, name, parent)) {
                ok = false;
            }
        } else {
            int expectedMin = this.countExpectedMin(expectedElements, name, parent);
            int oc = this.optionalCount(expectedElements, name, parent);
            if (this.patternMode) {
                int c = 0;
                for (int i = 0; i < expectedElements.size(); ++i) {
                    CommaSeparatedStringBuilder cs = new CommaSeparatedStringBuilder("\r\n");
                    boolean bok = false;
                    while (!bok && c < actualElements.size()) {
                        ArrayList<ValidationMessage> vm = new ArrayList<ValidationMessage>();
                        bok = this.comparePropertyValue(vm, path + "[" + Integer.toString(i) + "]", expectedElements.get(i), actualElements.get(c), false, null, null);
                        if (!bok) {
                            cs.append("actual[" + c + "] != expected[" + i + "]: " + this.msgs(vm));
                        }
                        ++c;
                    }
                    if (bok) continue;
                    ok = false;
                    this.msg(messages, path, parent, "The expected item at " + path + " at index " + i + " was not found: " + cs.toString());
                }
            } else {
                if (as > es || as < expectedMin) {
                    ok = false;
                    this.notEqualMessage(messages, path, parent, "array item count differs at " + path, Integer.toString(es), Integer.toString(as));
                }
                int c = 0;
                for (int i = 0; i < es; ++i) {
                    if (c >= as) {
                        if (i >= es - oc && this.isOptional(expectedElements.get(i), name, parent)) continue;
                        ok = false;
                        this.msg(messages, path, parent, "One or more array items did not match at " + path + " starting at index " + i);
                        continue;
                    }
                    ArrayList<ValidationMessage> vm = new ArrayList<ValidationMessage>();
                    boolean bok = this.comparePropertyValue(vm, path + "[" + Integer.toString(i) + "]", expectedElements.get(i), actualElements.get(c), false, null, null);
                    if (bok) {
                        ++c;
                        continue;
                    }
                    if (this.isOptional(expectedElements.get(c), name, parent)) continue;
                    messages.addAll(vm);
                    ok = false;
                    break;
                }
                if (c < as) {
                    this.msg(messages, path, parent, "Unexpected Node found in array at '" + path + "' at index " + c);
                    ok = false;
                }
            }
        }
        return ok;
    }

    private String msgs(List<ValidationMessage> vmlist) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(";");
        for (ValidationMessage vm : vmlist) {
            b.append(vm.getMessage());
        }
        return b.toString();
    }

    private boolean comparePropertyValue(List<ValidationMessage> messages, String path, Element expected, Element actual, boolean optional, String name, Element parent) {
        if (!expected.fhirType().equals(actual.fhirType())) {
            this.notEqualMessage(messages, path, expected, "properties differ at " + path, expected.fhirType(), actual.fhirType());
            return false;
        }
        if (expected.isPrimitive() && actual.isPrimitive()) {
            String eValue = expected.primitiveValue();
            String aValue = actual.primitiveValue();
            if (!this.matches(aValue, eValue) && !"xhtml".equals(expected.fhirType())) {
                if ("base64Binary".equals(expected.fhirType())) {
                    if (!this.sameBytes(Base64.decodeBase64((String)aValue), Base64.decodeBase64((String)eValue))) {
                        this.notEqualMessage(messages, path, expected, actual.fhirType() + " property values differ at " + path, eValue, aValue);
                        return false;
                    }
                } else {
                    this.notEqualMessage(messages, path, expected, actual.fhirType() + " property values differ at " + path, eValue, aValue);
                    return false;
                }
            }
        }
        return this.compareElements(messages, path, expected, actual);
    }

    private boolean sameBytes(byte[] b1, byte[] b2) {
        if (b1.length == 0 || b2.length == 0) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private int optionalCount(List<Element> arr, String name, Element parent) {
        int c = 0;
        for (Element e : arr) {
            if (!this.isOptional(e, name, parent)) continue;
            ++c;
        }
        return c;
    }

    private boolean isOptional(Element e, String name, Element parent) {
        Element ex = (Element)e.getExtensionValue(new String[]{EXT_OPT_PROP});
        return ex != null && ("true".equals(ex.primitiveValue()) || this.passesOptionalFilter(ex.primitiveValue()));
    }

    private boolean passesOptionalFilter(String token) {
        if (token.startsWith("!")) {
            return this.modes == null || !this.modes.contains(token.substring(1));
        }
        return this.modes != null && this.modes.contains(token);
    }

    private int countExpectedMin(List<Element> elements, String name, Element parent) {
        int count = elements.size();
        for (Element e : elements) {
            if (!this.isOptional(e, name, parent)) continue;
            --count;
        }
        return count;
    }

    private boolean matches(String actualJsonString, String expectedJsonString) {
        if (expectedJsonString.startsWith("$") && expectedJsonString.endsWith("$")) {
            if (expectedJsonString.startsWith("$choice:")) {
                return Utilities.existsInList((String)actualJsonString, this.readChoices(expectedJsonString.substring(8, expectedJsonString.length() - 1)));
            }
            if (expectedJsonString.startsWith("$fragments:")) {
                List<String> fragments = this.readChoices(expectedJsonString.substring(11, expectedJsonString.length() - 1));
                for (String f : fragments) {
                    if (actualJsonString.toLowerCase().contains(f.toLowerCase())) continue;
                    return false;
                }
                return true;
            }
            if (expectedJsonString.startsWith("$external:")) {
                String[] cmd = expectedJsonString.substring(1, expectedJsonString.length() - 1).split("\\:");
                if (this.externals != null) {
                    String s = this.externals.asString(cmd[1]);
                    return actualJsonString.equals(s);
                }
                if (cmd.length <= 2) {
                    return true;
                }
                List<String> fragments = this.readChoices(cmd[2]);
                for (String f : fragments) {
                    if (actualJsonString.toLowerCase().contains(f.toLowerCase())) continue;
                    return false;
                }
                return true;
            }
            switch (expectedJsonString) {
                case "$$": {
                    return true;
                }
                case "$instant$": {
                    return actualJsonString.matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]{1,9})?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))");
                }
                case "$date$": {
                    return actualJsonString.matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]{1,9})?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00)))?");
                }
                case "$uuid$": {
                    return actualJsonString.matches("urn:uuid:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
                }
                case "$string$": {
                    return actualJsonString.equals(actualJsonString.trim());
                }
                case "$id$": {
                    return actualJsonString.matches("[A-Za-z0-9\\-\\.]{1,64}");
                }
                case "$url$": {
                    return actualJsonString.matches("(https?://|www\\.)[-a-zA-Z0-9+&@#/%?=~_|!:.;]*[-a-zA-Z0-9+&@#/%=~_|]");
                }
                case "$token$": {
                    return actualJsonString.matches("[0-9a-zA-Z_][0-9a-zA-Z_\\.\\-]*");
                }
                case "$semver$": {
                    return actualJsonString.matches("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
                }
                case "$version$": {
                    return this.matchesVariable(actualJsonString, "version");
                }
            }
            throw new Error("Unhandled template: " + expectedJsonString);
        }
        return actualJsonString.equals(expectedJsonString);
    }

    private boolean matchesVariable(String value, String name) {
        if (this.variables.containsKey(name)) {
            return value.equals(this.variables.get(name));
        }
        return true;
    }

    private List<String> readChoices(String s) {
        ArrayList<String> list = new ArrayList<String>();
        for (String p : s.split("\\|")) {
            list.add(p);
        }
        return list;
    }

    private boolean isOptional(String n, List<String> optionals) {
        return n.equals("$optional$") || optionals.contains("*") || optionals.contains(n);
    }

    private boolean allOptional(List<Element> value, String name, Element parent) {
        for (Element e : value) {
            if (this.isOptional(e, name, parent)) continue;
            return false;
        }
        return true;
    }

    private List<Element> elements(List<Base> values, boolean expected) {
        ArrayList<Element> res = new ArrayList<Element>();
        for (Base b : values) {
            Element e = (Element)b;
            if (expected && this.matchetypeExtension(e)) continue;
            res.add(e);
        }
        return res;
    }

    private boolean matchetypeExtension(Element e) {
        String url;
        return e.fhirType().equals("Extension") && !Utilities.noString((String)(url = e.getNamedChildValue(new String[]{"url"}))) && url.startsWith(EXT_OPT_MODE);
    }

    private void msg(List<ValidationMessage> errors, String path, Element source, String message) {
        ValidationMessage validationMessage = new ValidationMessage(ValidationMessage.Source.MatchetypeValidator, ValidationMessage.IssueType.VALUE, source.line(), source.col(), path, message, ValidationMessage.IssueSeverity.ERROR);
        errors.add(validationMessage);
    }

    public void notEqualMessage(List<ValidationMessage> errors, String path, Element source, String message, String expected, String actual) {
        String msg = message + ": " + "expected " + this.presentExpected(expected) + " but found '" + actual + "'";
        this.msg(errors, path, source, msg);
    }

    private String presentExpected(String expected) {
        if (expected == null) {
            return "null";
        }
        if (expected.startsWith("$") && expected.endsWith("$")) {
            if (expected.startsWith("$choice:")) {
                return "Contains one of " + this.readChoices(expected.substring(8, expected.length() - 1)).toString();
            }
            if (expected.startsWith("$fragments:")) {
                List<String> fragments = this.readChoices(expected.substring(11, expected.length() - 1));
                return "Contains all of " + fragments.toString();
            }
            if (expected.startsWith("$external:")) {
                String[] cmd = expected.substring(1, expected.length() - 1).split(":");
                if (this.externals != null) {
                    String s = this.externals.asString(cmd[1]);
                    return "'" + s + "' (Ext)";
                }
                List<String> fragments = this.readChoices(cmd[2]);
                return "Contains all of " + fragments.toString() + " (because no external string provided for " + cmd[1] + ")";
            }
            switch (expected) {
                case "$$": {
                    return "$$";
                }
                case "$instant$": {
                    return "'An Instant'";
                }
                case "$date$": {
                    return "'A date'";
                }
                case "$uuid$": {
                    return "'A Uuid'";
                }
                case "$string$": {
                    return "'A string'";
                }
                case "$id$": {
                    return "'An Id'";
                }
                case "$url$": {
                    return "'A URL'";
                }
                case "$token$": {
                    return "'A Token'";
                }
                case "$version$": {
                    return this.variables.containsKey("version") ? this.variables.get("version") : "(anything)";
                }
                case "$semver$": {
                    return "A semver";
                }
            }
            return "Unhandled template: " + expected;
        }
        return "'" + expected + "'";
    }

    public class NamedElementSorter
    implements Comparator<Element> {
        private String name;
        private String expr;

        public NamedElementSorter(String name, String expr) {
            this.name = name;
            this.expr = expr;
        }

        @Override
        public int compare(Element e1, Element e2) {
            if (!this.name.equals(e1.getName()) || !this.name.equals(e2.getName())) {
                return e1.getIndex() - e2.getIndex();
            }
            String s1 = MatchetypeValidator.this.fpe.evaluateToString((Base)e1, this.expr);
            String s2 = MatchetypeValidator.this.fpe.evaluateToString((Base)e2, this.expr);
            return s1.compareTo(s2);
        }
    }
}

