/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.model;

import org.hl7.fhir.utilities.Utilities;

public enum HtmlInMarkdownCheck {
    NONE,
    WARNING,
    ERROR;


    public static boolean isValidCode(String q) {
        return HtmlInMarkdownCheck.fromCode(q) != null;
    }

    public static HtmlInMarkdownCheck fromCode(String q) {
        if (Utilities.noString((String)q)) {
            return null;
        }
        q = q.toLowerCase();
        if (Utilities.existsInList((String)q, (String[])new String[]{"n", "none", "ignore", "i"})) {
            return NONE;
        }
        if (Utilities.existsInList((String)q, (String[])new String[]{"w", "warning", "warnings", "warn"})) {
            return WARNING;
        }
        if (Utilities.existsInList((String)q, (String[])new String[]{"e", "error", "errors", "err"})) {
            return ERROR;
        }
        return null;
    }
}

